/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.framework;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.build.framework.Bundle;
import org.eclipse.birt.build.framework.FrameworkException;

public class Framework {
    File pluginFolder;
    ArrayList<Bundle> bundles = new ArrayList();
    ArrayList<Bundle> fragments = new ArrayList();

    public Bundle addBundle(File bundleFile) throws FrameworkException {
        Bundle bundle = new Bundle(bundleFile);
        if (bundle.isFragment()) {
            this.fragments.add(bundle);
            Bundle host = this.getBundle(bundle.getHostID());
            if (host != null) {
                host.addFragment(bundle);
            }
        } else {
            this.bundles.add(bundle);
            for (Bundle fragment : this.fragments) {
                if (!fragment.getHostID().equals(bundle.getBundleID())) continue;
                bundle.addFragment(fragment);
            }
        }
        return bundle;
    }

    private Bundle getBundle(String bundleId) {
        for (Bundle bundle : this.bundles) {
            if (!bundle.getBundleFile().equals(bundleId)) continue;
            return bundle;
        }
        return null;
    }

    public List<Bundle> getAllBundles() {
        ArrayList<Bundle> allBundles = new ArrayList<Bundle>(this.bundles);
        for (Bundle fragment : this.fragments) {
            String hostId = fragment.getHostID();
            if (this.getBundle(hostId) != null) continue;
            allBundles.add(fragment);
        }
        return allBundles;
    }

    public void close() {
        for (Bundle bundle : this.bundles) {
            bundle.close();
        }
        this.bundles.clear();
        for (Bundle fragment : this.fragments) {
            fragment.close();
        }
        this.fragments.clear();
    }
}

