/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.build.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.birt.build.framework.Bundle;
import org.eclipse.birt.build.framework.BundleEntry;
import org.eclipse.birt.build.framework.BundleFile;
import org.eclipse.birt.build.framework.ZipBundleEntry;
import org.eclipse.birt.build.framework.ZipDirBundleEntry;

public class ZipBundleFile
extends BundleFile {
    protected ZipFile zipFile;

    public ZipBundleFile(Bundle bundle, File basefile) throws IOException {
        super(bundle, basefile);
        this.zipFile = new ZipFile(basefile);
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    protected ZipEntry getZipEntry(String path) {
        ZipEntry dirEntry;
        ZipEntry entry = this.zipFile.getEntry(path);
        if (entry != null && entry.getSize() == 0L && !entry.isDirectory() && (dirEntry = this.zipFile.getEntry(String.valueOf(path) + '/')) != null) {
            entry = dirEntry;
        }
        return entry;
    }

    @Override
    public synchronized boolean isDirectory(String dir) {
        dir = this.normalizeFolder(dir);
        Enumeration<? extends ZipEntry> zipEntries = this.zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String entryPath = zipEntry.getName();
            if (!entryPath.startsWith(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BundleEntry getEntry(String path) {
        ZipEntry zipEntry = this.getZipEntry(path = this.normalizeFile(path));
        if (zipEntry == null) {
            if (path.charAt(path.length() - 1) == '/' && this.isDirectory(path)) {
                return new ZipDirBundleEntry(this, path);
            }
            return null;
        }
        return new ZipBundleEntry(this, zipEntry);
    }

    @Override
    public List<String> getEntryPaths(String path) {
        if (this.zipFile == null) {
            return null;
        }
        path = this.normalizeFile(path);
        ArrayList<String> entries = new ArrayList<String>();
        Enumeration<? extends ZipEntry> zipEntries = this.zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String entryPath = zipEntry.getName();
            if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
            if (entryPath.lastIndexOf(47) < path.length()) {
                entries.add(entryPath);
                continue;
            }
            entryPath = entryPath.substring(path.length());
            int slash = entryPath.indexOf(47);
            entryPath = String.valueOf(path) + entryPath.substring(0, slash + 1);
            if (entries.contains(entryPath)) continue;
            entries.add(entryPath);
        }
        return entries;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.zipFile != null) {
            this.zipFile.close();
            this.zipFile = null;
        }
    }
}

