/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class TraceLogging {
    private int m_logLevel;
    private String m_logFileNamePrefix;
    private String m_logDirectory;
    private String m_logFormatterClass;
    private static HashMap sm_logLevelLiterals = null;

    TraceLogging(IConfigurationElement traceLogging, String dataSourceElementId) throws OdaException {
        String logLevelString = traceLogging.getAttribute("logLevel");
        this.m_logLevel = TraceLogging.toLogLevelNumber(logLevelString);
        this.m_logFileNamePrefix = traceLogging.getAttribute("logFileNamePrefix");
        this.m_logDirectory = traceLogging.getAttribute("logDirectory");
        this.m_logFormatterClass = traceLogging.getAttribute("logFormatterClass");
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public String getLogFileNamePrefix() {
        return this.m_logFileNamePrefix;
    }

    public String getLogDirectory() {
        return this.m_logDirectory;
    }

    public String getLogFormatterClass() {
        return this.m_logFormatterClass;
    }

    public static int toLogLevelNumber(String logLevelName) {
        int defaultLogLevel = 900;
        if (logLevelName == null || logLevelName.length() == 0) {
            return defaultLogLevel;
        }
        Integer mappedLevel = (Integer)TraceLogging.getLogLevelLiterals().get(logLevelName);
        if (mappedLevel != null) {
            return mappedLevel;
        }
        try {
            int logLevel = Short.parseShort(logLevelName);
            if (logLevel > 1000) {
                logLevel = Integer.MAX_VALUE;
            }
            return logLevel;
        }
        catch (NumberFormatException ex) {
            return defaultLogLevel;
        }
    }

    private static HashMap getLogLevelLiterals() {
        if (sm_logLevelLiterals != null) {
            return sm_logLevelLiterals;
        }
        sm_logLevelLiterals = new HashMap(18, 1.0f);
        sm_logLevelLiterals.put("SEVERE", new Integer(1000));
        sm_logLevelLiterals.put("1000", new Integer(1000));
        sm_logLevelLiterals.put("WARNING", new Integer(900));
        sm_logLevelLiterals.put("900", new Integer(900));
        sm_logLevelLiterals.put("INFO", new Integer(800));
        sm_logLevelLiterals.put("800", new Integer(800));
        sm_logLevelLiterals.put("CONFIG", new Integer(700));
        sm_logLevelLiterals.put("700", new Integer(700));
        sm_logLevelLiterals.put("FINE", new Integer(500));
        sm_logLevelLiterals.put("500", new Integer(500));
        sm_logLevelLiterals.put("FINER", new Integer(400));
        sm_logLevelLiterals.put("400", new Integer(400));
        sm_logLevelLiterals.put("FINEST", new Integer(300));
        sm_logLevelLiterals.put("300", new Integer(300));
        sm_logLevelLiterals.put("ALL", new Integer(Integer.MIN_VALUE));
        sm_logLevelLiterals.put("0", new Integer(Integer.MIN_VALUE));
        sm_logLevelLiterals.put("OFF", new Integer(Integer.MAX_VALUE));
        return sm_logLevelLiterals;
    }
}

