/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.impl.SelectionChoiceComparator;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public class ParameterHelper {
    private static final String VALUE_PREFIX = "__VALUE__";
    private static final String LABEL_PREFIX = "__LABEL__";
    private boolean distinct;
    private Comparator comparator;
    private String labelColumnName;
    private String valueColumnName;
    private String valueType;
    private boolean fixedOrder;

    public ParameterHelper(ScalarParameterHandle parameter, Locale locale) {
        this.distinct = parameter.distinct();
        this.labelColumnName = ParameterHelper.getLabelColumnName(parameter);
        this.valueColumnName = ParameterHelper.getValueColumnName(parameter);
        this.valueType = parameter.getDataType();
        this.fixedOrder = parameter.isFixedOrder();
        if (!this.fixedOrder) {
            boolean sortDirectionValue = "asc".equalsIgnoreCase(parameter.getSortDirection());
            boolean sortByLabel = "label".equalsIgnoreCase(parameter.getSortBy());
            String pattern = parameter.getPattern();
            SelectionChoiceComparator choiceComparator = new SelectionChoiceComparator(sortByLabel, pattern, sortDirectionValue, ULocale.forLocale((Locale)locale));
            this.comparator = new DistinctComparatorDecorator(choiceComparator, this.distinct);
        }
    }

    public GetParameterDefinitionTask.CascadingParameterSelectionChoice createCascadingParameterSelectionChoice(IResultIterator iterator) throws BirtException {
        String label = this.getLabel(iterator);
        Object value = this.getValue(iterator);
        return new GetParameterDefinitionTask.CascadingParameterSelectionChoice(label, value);
    }

    public GetParameterDefinitionTask.CascadingParameterSelectionChoice createCascadingParameterSelectionChoice(IParameterSelectionChoice choice) {
        String label = choice.getLabel();
        Object value = choice.getValue();
        return new GetParameterDefinitionTask.CascadingParameterSelectionChoice(label, value);
    }

    public GetParameterDefinitionTask.CascadingParameterSelectionChoice createCascadingParameterSelectionChoice(String label, Object value) {
        return new GetParameterDefinitionTask.CascadingParameterSelectionChoice(label, value);
    }

    public Collection createSelectionCollection() {
        if (this.fixedOrder) {
            if (!this.distinct) {
                return new ArrayList();
            }
            return new ArrayList(){
                private static final long serialVersionUID = 1L;
                private Set values = new HashSet();

                public boolean add(Object arg0) {
                    if (!this.values.contains(arg0)) {
                        this.values.add(arg0);
                        return super.add(arg0);
                    }
                    return false;
                }
            };
        }
        return new TreeSet(this.comparator);
    }

    public String getLabel(IResultIterator resultIterator) throws BirtException {
        if (this.labelColumnName == null) {
            return null;
        }
        return resultIterator.getString(this.labelColumnName);
    }

    public Object getValue(IResultIterator resultIterator) throws BirtException {
        Object value = resultIterator.getValue(this.valueColumnName);
        return EngineTask.convertParameterType(value, this.valueType);
    }

    public static void addParameterBinding(QueryDefinition queryDefn, ScalarParameterHandle parameter) throws DataException {
        String labelColumnName = ParameterHelper.getLabelColumnName(parameter);
        String valueColumnName = ParameterHelper.getValueColumnName(parameter);
        if (labelColumnName != null) {
            ParameterHelper.addBinding(queryDefn, labelColumnName, parameter.getLabelExpr());
        }
        ParameterHelper.addBinding(queryDefn, valueColumnName, parameter.getValueExpr());
    }

    public static void addBinding(QueryDefinition queryDefinition, String columnName, String expression) throws DataException {
        ScriptExpression labelScriptExpr = new ScriptExpression(expression);
        Binding binding = new Binding(columnName, (IBaseExpression)labelScriptExpr);
        queryDefinition.addBinding((IBinding)binding);
    }

    public static String getValueColumnName(ScalarParameterHandle parameter) {
        return "__VALUE___" + parameter.getName();
    }

    public static String getLabelColumnName(ScalarParameterHandle parameter) {
        if (parameter.getLabelExpr() == null) {
            return null;
        }
        return "__LABEL___" + parameter.getName();
    }

    static class DistinctComparatorDecorator
    implements Comparator {
        private boolean distinct;
        private Comparator comparator;

        public DistinctComparatorDecorator(Comparator comparator, boolean distinct) {
            this.comparator = comparator;
            this.distinct = distinct;
        }

        public int compare(Object obj1, Object obj2) {
            int result = this.comparator.compare(obj1, obj2);
            if (result == 0 && !this.distinct) {
                result = 1;
            }
            return result;
        }
    }
}

