/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.DataExtractionTask;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.impl.RenderTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.RunAndRenderTask;
import org.eclipse.birt.report.engine.api.impl.RunTask;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportEngineHelper {
    private IReportEngine engine;
    protected Logger logger;
    private ExtensionManager extensionMgr;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.ReportEngineHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ReportEngineHelper(IReportEngine engine) {
        this.engine = engine;
        this.logger = engine.getLogger();
        this.extensionMgr = ExtensionManager.getInstance();
    }

    public IReportRunnable openReportDesign(String designName) throws EngineException {
        return this.openReportDesign(designName, (IResourceLocator)null);
    }

    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        File file = new File(designName);
        if (!file.exists()) {
            this.logger.log(Level.SEVERE, "{0} not found!", file.getAbsolutePath());
            throw new EngineException("Error.DesignFileNotFound", designName);
        }
        try {
            FileInputStream in = new FileInputStream(file);
            String systemId = designName;
            try {
                systemId = file.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                systemId = designName;
            }
            return this.openReportDesign(systemId, (InputStream)in, locator);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.log(Level.SEVERE, "{0} not found!", file.getAbsolutePath());
            throw new EngineException("Error.DesignFileNotFound", designName);
        }
    }

    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        return this.openReportDesign("<stream>", designStream);
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream) throws EngineException {
        return this.openReportDesign(designName, designStream, new HashMap());
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream, IResourceLocator locator) throws EngineException {
        HashMap<String, IResourceLocator> options = new HashMap<String, IResourceLocator>();
        if (locator != null) {
            options.put("resourceLocator", locator);
        }
        return this.openReportDesign(designName, designStream, options);
    }

    protected void intializeModuleOptions(Map options) {
        EngineConfig config = this.engine.getConfig();
        if (config != null) {
            String resourcePath;
            IResourceLocator locator;
            if (options.get("resourceLocator") == null && (locator = config.getResourceLocator()) != null) {
                options.put("resourceLocator", locator);
            }
            if (options.get("resourceFolder") == null && (resourcePath = config.getResourcePath()) != null) {
                options.put("resourceFolder", resourcePath);
            }
        }
    }

    public IReportRunnable openReportDesign(String designName, InputStream designStream, Map options) throws EngineException {
        ReportDesignHandle designHandle;
        try {
            if (options == null) {
                options = new HashMap();
            }
            this.intializeModuleOptions(options);
            ReportParser parser = new ReportParser(options);
            designHandle = parser.getDesignHandle(designName, designStream);
        }
        catch (DesignFileException e) {
            this.logger.log(Level.SEVERE, "invalid design file {0}", designName);
            throw new EngineException("Error.InvalidDesignFile", designName, (Throwable)e);
        }
        if (!$assertionsDisabled && designHandle == null) {
            throw new AssertionError();
        }
        ReportRunnable runnable = new ReportRunnable(designHandle);
        runnable.setReportName(designName);
        runnable.setReportEngine(this.engine);
        return runnable;
    }

    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        ReportRunnable ret = new ReportRunnable(designHandle);
        ret.setReportName(designHandle.getFileName());
        ret.setReportEngine(this.engine);
        return ret;
    }

    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        return new RunAndRenderTask(this.engine, reportRunnable);
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IReportRunnable reportRunnable) {
        return new GetParameterDefinitionTask(this.engine, reportRunnable);
    }

    public String[] getSupportedFormats() {
        return this.extensionMgr.getSupportedFormat().toArray(new String[0]);
    }

    public EmitterInfo[] getEmitterInfo() {
        return this.extensionMgr.getEmitterInfo();
    }

    public String getMIMEType(String format) {
        return this.extensionMgr.getMIMEType(format);
    }

    public IReportDocument openReportDocument(String docArchiveName) throws EngineException {
        return this.openReportDocument(null, docArchiveName, new HashMap());
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName) throws EngineException {
        return this.openReportDocument(systemId, docArchiveName, new HashMap());
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName, IResourceLocator locator) throws EngineException {
        HashMap<String, IResourceLocator> options = new HashMap<String, IResourceLocator>();
        if (locator != null) {
            options.put("resourceLocator", locator);
        }
        return this.openReportDocument(systemId, docArchiveName, options);
    }

    public IReportDocument openReportDocument(String systemId, String docArchiveName, Map options) throws EngineException {
        Object reader = null;
        try {
            File file = new File(docArchiveName);
            reader = file.exists() ? (file.isDirectory() ? new FolderArchiveReader(docArchiveName) : new FileArchiveReader(docArchiveName)) : (docArchiveName.endsWith("\\") || docArchiveName.endsWith("/") ? new FolderArchiveReader(docArchiveName) : new FileArchiveReader(docArchiveName));
        }
        catch (IOException e) {
            throw new EngineException(e.getLocalizedMessage());
        }
        return this.openReportDocument(systemId, (IDocArchiveReader)reader, options);
    }

    public IReportDocument openReportDocument(String systemId, IDocArchiveReader archive, IResourceLocator locator) throws EngineException {
        HashMap<String, IResourceLocator> options = new HashMap<String, IResourceLocator>();
        if (locator != null) {
            options.put("resourceLocator", locator);
        }
        return this.openReportDocument(systemId, archive, options);
    }

    public IReportDocument openReportDocument(String systemId, IDocArchiveReader archive, Map options) throws EngineException {
        ReportDocumentReader reader = new ReportDocumentReader(systemId, this.engine, archive);
        if (options == null) {
            options = new HashMap();
        }
        this.intializeModuleOptions(options);
        reader.setModuleOptions(options);
        return reader;
    }

    public IRunTask createRunTask(IReportRunnable runnable) {
        return new RunTask(this.engine, runnable);
    }

    public IRenderTask createRenderTask(IReportDocument reportDoc) {
        IReportRunnable runnable = reportDoc.getReportRunnable();
        return new RenderTask(this.engine, runnable, reportDoc);
    }

    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDoc) {
        try {
            IReportRunnable runnable = reportDoc.getReportRunnable();
            return new DataExtractionTask(this.engine, runnable, reportDoc);
        }
        catch (EngineException ex) {
            this.logger.log(Level.SEVERE, ex.getMessage(), (Throwable)((Object)ex));
            return null;
        }
    }
}

