/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IResultMetaData;

public class ResultMetaData
implements IResultMetaData {
    protected IResultMetaData parentMetaData;
    protected String[] selectedColumns;
    private ArrayList metaEntries = new ArrayList();

    public ResultMetaData(IBaseQueryDefinition query, String[] selectedColumns) {
        this.initializeMetaData(query);
        this.selectedColumns = selectedColumns;
    }

    public ResultMetaData(IBaseQueryDefinition query) {
        this.initializeMetaData(query);
        this.selectedColumns = null;
    }

    public ResultMetaData(IResultMetaData parentMetaData, String[] selectedColumns) {
        this.parentMetaData = parentMetaData;
        this.selectedColumns = selectedColumns;
    }

    protected void initializeMetaData(IBaseQueryDefinition query) {
        this.appendMetaData(query);
    }

    protected void appendMetaData(IBaseQueryDefinition query) {
        Map bindings = query.getBindings();
        Iterator iter = bindings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            IBinding binding = (IBinding)entry.getValue();
            try {
                IBaseExpression expr = binding.getExpression();
                int type = expr.getDataType();
                this.metaEntries.add(new MetaDataEntry(name, type));
            }
            catch (DataException dataException) {}
        }
    }

    public int getColumnCount() {
        if (this.selectedColumns != null) {
            return this.selectedColumns.length;
        }
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnCount();
        }
        return this.metaEntries.size();
    }

    public String getColumnName(int index) throws BirtException {
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnName(index);
        }
        MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
        return entry.name;
    }

    public String getColumnAlias(int index) throws BirtException {
        return this.getColumnName(index);
    }

    public int getColumnType(int index) throws BirtException {
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnType(index);
        }
        MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
        return entry.type;
    }

    public String getColumnTypeName(int index) throws BirtException {
        int type = this.getColumnType(index);
        return DataType.getName((int)type);
    }

    public String getColumnLabel(int index) throws BirtException {
        return this.getColumnName(index);
    }

    private int getColumnIndex(int index) throws BirtException {
        if (this.selectedColumns == null) {
            return index;
        }
        String name = this.selectedColumns[index];
        if (this.parentMetaData != null) {
            int i = 0;
            while (i < this.parentMetaData.getColumnCount()) {
                String columnName = this.parentMetaData.getColumnName(i);
                if (columnName.equals(name)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.metaEntries.size()) {
                MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(i);
                if (entry.name.equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        throw new EngineException("Invalid Column Index");
    }

    private class MetaDataEntry {
        String name;
        int type;

        MetaDataEntry(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

