/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.AutoTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.CellScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.GridScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ImageScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.LabelScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ListScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.RowScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableGroupScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TableScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.TextItemScriptExecutor;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;

class ScriptedDesignVisitor
extends DesignVisitor {
    protected static Logger logger;
    protected ReportDesignHandle handle;
    protected ExecutionContext executionContext;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.ScriptedDesignVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    ScriptedDesignVisitor(ReportDesignHandle handle, ExecutionContext executionContext) {
        this.handle = handle;
        this.executionContext = executionContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOnPrepare(ReportItemHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null) {
                    this.executionContext.evaluate(handle.getOnPrepare());
                }
                Object var5_7 = null;
                if (element == null) return;
                this.executionContext.exitScope();
                return;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (element == null) throw throwable;
                this.executionContext.exitScope();
                throw throwable;
            }
        }
        try {
            if (handle instanceof DataItemHandle) {
                DataItemScriptExecutor.handleOnPrepare((DataItemHandle)handle, this.executionContext);
            } else if (handle instanceof GridHandle) {
                GridScriptExecutor.handleOnPrepare((GridHandle)handle, this.executionContext);
            } else if (handle instanceof ImageHandle) {
                ImageScriptExecutor.handleOnPrepare((ImageHandle)handle, this.executionContext);
            } else if (handle instanceof LabelHandle) {
                LabelScriptExecutor.handleOnPrepare((LabelHandle)handle, this.executionContext);
            } else if (handle instanceof ListHandle) {
                ListScriptExecutor.handleOnPrepare((ListHandle)handle, this.executionContext);
            } else if (handle instanceof TableHandle) {
                TableScriptExecutor.handleOnPrepare((TableHandle)handle, this.executionContext);
            } else if (handle instanceof TextItemHandle) {
                TextItemScriptExecutor.handleOnPrepare((TextItemHandle)handle, this.executionContext);
            } else if (handle instanceof TextDataHandle) {
                DynamicTextScriptExecutor.handleOnPrepare((TextDataHandle)handle, this.executionContext);
            } else if (handle instanceof AutoTextHandle) {
                AutoTextScriptExecutor.handleOnPrepare((AutoTextHandle)handle, this.executionContext);
            } else {
                try {
                    this.executionContext.newScope(handle);
                    this.executionContext.execute(handle.getOnPrepare());
                    Object var4_6 = null;
                    this.executionContext.exitScope();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.executionContext.exitScope();
                    throw throwable;
                }
            }
            Object var6_12 = null;
            this.executionContext.popHandle();
            return;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.executionContext.popHandle();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOnPrepare(CellHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null) {
                    this.executionContext.evaluate(handle.getOnPrepare());
                }
                Object var5_7 = null;
                if (element == null) return;
                this.executionContext.exitScope();
                return;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (element == null) throw throwable;
                this.executionContext.exitScope();
                throw throwable;
            }
        }
        try {
            CellScriptExecutor.handleOnPrepare(handle, this.executionContext);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.executionContext.popHandle();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.executionContext.popHandle();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOnPrepare(GroupHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null) {
                    this.executionContext.evaluate(handle.getOnPrepare());
                }
                Object var5_7 = null;
                if (element == null) return;
                this.executionContext.exitScope();
                return;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (element == null) throw throwable;
                this.executionContext.exitScope();
                throw throwable;
            }
        }
        try {
            if (handle instanceof TableGroupHandle) {
                TableGroupScriptExecutor.handleOnPrepare((TableGroupHandle)handle, this.executionContext);
            }
            if (handle instanceof ListGroupHandle) {
                ListGroupScriptExecutor.handleOnPrepare((ListGroupHandle)handle, this.executionContext);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.executionContext.popHandle();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.executionContext.popHandle();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOnPrepare(RowHandle handle) {
        boolean hasJavaCode;
        boolean hasJavaScript = handle.getOnPrepare() != null && handle.getOnPrepare().length() != 0;
        boolean bl = hasJavaCode = handle.getEventHandlerClass() != null && handle.getEventHandlerClass().length() != 0;
        if (!hasJavaScript && !hasJavaCode) {
            return;
        }
        this.executionContext.pushHandle((DesignElementHandle)handle);
        if (hasJavaScript) {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)handle);
            try {
                if (element != null) {
                    this.executionContext.newScope(element);
                }
                if (handle.getOnPrepare() != null) {
                    this.executionContext.evaluate(handle.getOnPrepare());
                }
                Object var5_7 = null;
                if (element == null) return;
                this.executionContext.exitScope();
                return;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (element == null) throw throwable;
                this.executionContext.exitScope();
                throw throwable;
            }
        }
        try {
            RowScriptExecutor.handleOnPrepare(handle, this.executionContext);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.executionContext.popHandle();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.executionContext.popHandle();
        }
    }

    public void visitReportDesign(ReportDesignHandle handle) {
        SlotHandle pageSlot = handle.getMasterPages();
        int i = 0;
        while (i < pageSlot.getCount()) {
            this.apply(pageSlot.get(i));
            ++i;
        }
        SlotHandle componentsSlot = handle.getComponents();
        int i2 = 0;
        while (i2 < componentsSlot.getCount()) {
            this.apply(componentsSlot.get(i2));
            ++i2;
        }
        SlotHandle bodySlot = handle.getBody();
        int i3 = 0;
        while (i3 < bodySlot.getCount()) {
            this.apply(bodySlot.get(i3));
            ++i3;
        }
        SlotHandle dataSourceSlot = handle.getDataSources();
        int i4 = 0;
        while (i4 < dataSourceSlot.getCount()) {
            this.apply(dataSourceSlot.get(i4));
            ++i4;
        }
        SlotHandle dataSetSlot = handle.getDataSets();
        int i5 = 0;
        while (i5 < dataSetSlot.getCount()) {
            this.apply(dataSetSlot.get(i5));
            ++i5;
        }
        SlotHandle parameterSlot = handle.getParameters();
        int i6 = 0;
        while (i6 < parameterSlot.getCount()) {
            this.apply(parameterSlot.get(i6));
            ++i6;
        }
        SlotHandle scratchSlot = handle.getScratchPad();
        int i7 = 0;
        while (i7 < scratchSlot.getCount()) {
            this.apply(scratchSlot.get(i7));
            ++i7;
        }
        SlotHandle styleSlot = handle.getStyles();
        int i8 = 0;
        while (i8 < styleSlot.getCount()) {
            this.apply(styleSlot.get(i8));
            ++i8;
        }
    }

    public void visitGraphicMasterPage(GraphicMasterPageHandle handle) {
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            ++i;
        }
    }

    public void visitSimpleMasterPage(SimpleMasterPageHandle handle) {
        SlotHandle headerSlot = handle.getPageHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle footerSlot = handle.getPageFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            ++i2;
        }
    }

    public void visitAutoText(AutoTextHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitList(ListHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        int i2 = 0;
        while (i2 < detailSlot.getCount()) {
            this.apply(detailSlot.get(i2));
            ++i2;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i3 = 0;
        while (i3 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i3));
            ++i3;
        }
        SlotHandle groupsSlot = handle.getGroups();
        int i4 = 0;
        while (i4 < groupsSlot.getCount()) {
            this.apply(groupsSlot.get(i4));
            ++i4;
        }
    }

    public void visitFreeForm(FreeFormHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle slot = handle.getReportItems();
        int i = 0;
        while (i < slot.getCount()) {
            this.apply(slot.get(i));
            ++i;
        }
    }

    public void visitTextDataItem(TextDataHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitParameterGroup(ParameterGroupHandle handle) {
        SlotHandle parameters = handle.getParameters();
        int size = parameters.getCount();
        int n = 0;
        while (n < size) {
            this.apply(parameters.get(n));
            ++n;
        }
    }

    public void visitCascadingParameterGroup(CascadingParameterGroupHandle handle) {
        SlotHandle parameters = handle.getParameters();
        int size = parameters.getCount();
        int n = 0;
        while (n < size) {
            this.apply(parameters.get(n));
            ++n;
        }
    }

    public void visitScalarParameter(ScalarParameterHandle handle) {
    }

    public void visitLabel(LabelHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitDataItem(DataItemHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitGrid(GridHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle columnSlot = handle.getColumns();
        int i = 0;
        while (i < columnSlot.getCount()) {
            this.apply(columnSlot.get(i));
            ++i;
        }
        SlotHandle rowSlot = handle.getRows();
        int i2 = 0;
        while (i2 < rowSlot.getCount()) {
            this.apply(rowSlot.get(i2));
            ++i2;
        }
    }

    public void visitImage(ImageHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitTable(TableHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        int i2 = 0;
        while (i2 < detailSlot.getCount()) {
            this.apply(detailSlot.get(i2));
            ++i2;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i3 = 0;
        while (i3 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i3));
            ++i3;
        }
        SlotHandle columnSlot = handle.getColumns();
        int i4 = 0;
        while (i4 < columnSlot.getCount()) {
            this.apply(columnSlot.get(i4));
            ++i4;
        }
        SlotHandle groupSlot = handle.getGroups();
        int i5 = 0;
        while (i5 < groupSlot.getCount()) {
            this.apply(groupSlot.get(i5));
            ++i5;
        }
    }

    public void visitColumn(ColumnHandle handle) {
    }

    public void visitRow(RowHandle handle) {
        this.handleOnPrepare(handle);
        SlotHandle cellSlot = handle.getCells();
        int i = 0;
        while (i < cellSlot.getCount()) {
            this.apply(cellSlot.get(i));
            ++i;
        }
    }

    public void visitCell(CellHandle handle) {
        this.handleOnPrepare(handle);
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            ++i;
        }
    }

    public void visitListGroup(ListGroupHandle handle) {
        this.handleOnPrepare((GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            ++i2;
        }
    }

    public void visitTableGroup(TableGroupHandle handle) {
        this.handleOnPrepare((GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            ++i2;
        }
    }

    public void visitTextItem(TextItemHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    protected void visitExtendedItem(ExtendedItemHandle obj) {
    }
}

