/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;

public class DteMetaInfoIOUtil {
    protected static final String VERSION_1 = "__version__1";

    public static void storeMetaInfo(DataOutputStream dos, String pRsetId, String rowId, String queryId, String rsetId) throws IOException {
        IOUtil.writeString((DataOutputStream)dos, (String)pRsetId);
        IOUtil.writeString((DataOutputStream)dos, (String)rowId);
        IOUtil.writeString((DataOutputStream)dos, (String)queryId);
        IOUtil.writeString((DataOutputStream)dos, (String)rsetId);
    }

    public static void startMetaInfo(DataOutputStream dos) throws IOException {
        IOUtil.writeString((DataOutputStream)dos, (String)VERSION_1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList loadAllDteMetaInfo(IDocArchiveReader archive) throws IOException {
        Object var3_6;
        RAInputStream in;
        ArrayList result = new ArrayList();
        if (archive.exists("/Data/hierarchy")) {
            in = archive.getStream("/Data/hierarchy");
            try {
                DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream((InputStream)in));
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                in.close();
                throw throwable;
            }
            {
                var3_6 = null;
            }
            in.close();
        }
        if (!archive.exists("/Data/snap_hierarchy")) return result;
        in = archive.getStream("/Data/snap_hierarchy");
        try {
            DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream((InputStream)in));
        }
        catch (Throwable throwable) {
            var3_6 = null;
            in.close();
            throw throwable;
        }
        {
            var3_6 = null;
        }
        in.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList loadDteMetaInfo(IDocArchiveReader archive) throws IOException {
        ArrayList result = new ArrayList();
        if (archive.exists("/Data/snap_hierarchy")) {
            RAInputStream in = archive.getStream("/Data/snap_hierarchy");
            try {
                DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream((InputStream)in));
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                in.close();
                throw throwable;
            }
            {
                Object var3_7 = null;
                in.close();
                return result;
            }
        }
        if (!archive.exists("/Data/hierarchy")) return result;
        RAInputStream in = archive.getStream("/Data/hierarchy");
        try {
            DteMetaInfoIOUtil.loadDteMetaInfo(result, new DataInputStream((InputStream)in));
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            in.close();
            throw throwable;
        }
        {
            Object var3_9 = null;
        }
        in.close();
        return result;
    }

    public static void loadDteMetaInfo(ArrayList result, DataInputStream dis) throws IOException {
        try {
            String rowId;
            String pRsetId;
            String version = IOUtil.readString((DataInputStream)dis);
            boolean version1 = VERSION_1.equals(version);
            if (version1) {
                pRsetId = IOUtil.readString((DataInputStream)dis);
                rowId = IOUtil.readString((DataInputStream)dis);
            } else {
                pRsetId = version;
                rowId = String.valueOf(IOUtil.readLong((DataInputStream)dis));
            }
            String queryId = IOUtil.readString((DataInputStream)dis);
            String rsetId = IOUtil.readString((DataInputStream)dis);
            result.add(new String[]{pRsetId, rowId, queryId, rsetId});
            while (true) {
                pRsetId = IOUtil.readString((DataInputStream)dis);
                rowId = version1 ? IOUtil.readString((DataInputStream)dis) : String.valueOf(IOUtil.readLong((DataInputStream)dis));
                queryId = IOUtil.readString((DataInputStream)dis);
                rsetId = IOUtil.readString((DataInputStream)dis);
                result.add(new String[]{pRsetId, rowId, queryId, rsetId});
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }
}

