/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class CellExecutor
extends QueryItemExecutor {
    int cellId;
    private int currentItem = 0;

    protected CellExecutor(ExecutorManager manager) {
        super(manager, 14);
    }

    public IContent execute() {
        CellDesign cellDesign = (CellDesign)this.getDesign();
        ICellContent cellContent = this.report.createCellContent();
        this.setContent(cellContent);
        this.executeQuery();
        this.initializeContent(cellDesign, cellContent);
        this.processAction(cellDesign, cellContent);
        this.processBookmark(cellDesign, cellContent);
        this.processStyle(cellDesign, cellContent);
        this.processVisibility(cellDesign, cellContent);
        if (this.context.isInFactory()) {
            this.handleOnCreate(cellContent);
        }
        this.startTOCEntry(cellContent);
        this.currentItem = 0;
        return this.content;
    }

    public void close() {
        this.finishTOCEntry();
        this.closeQuery();
        this.cellId = 0;
        super.close();
    }

    public boolean hasNextChild() {
        CellDesign cellDesign = (CellDesign)this.getDesign();
        return this.currentItem < cellDesign.getContentCount();
    }

    public IReportItemExecutor getNextChild() {
        CellDesign cellDesign = (CellDesign)this.getDesign();
        if (this.currentItem < cellDesign.getContentCount()) {
            ReportItemDesign itemDesign = cellDesign.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(this, itemDesign);
            return executor;
        }
        return null;
    }
}

