/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class QueryItemExecutor
extends StyledItemExecutor {
    protected boolean rsetEmpty;

    protected QueryItemExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected void closeQuery() {
        if (this.rset != null) {
            this.rset.close();
            this.rset = null;
            this.context.setResultSets(this.parentRsets);
        }
    }

    protected void executeQuery() {
        this.rset = null;
        boolean useCache = this.design.useCachedResult();
        IDataQueryDefinition query = this.design.getQuery();
        IBaseResultSet parentRset = this.getParentResultSet();
        this.context.setResultSet(parentRset);
        if (query != null) {
            try {
                this.rset = (IQueryResultSet)this.context.executeQuery(parentRset, query, useCache);
                this.context.setResultSet(this.rset);
                if (this.rset != null) {
                    this.rsetEmpty = !this.rset.next();
                    return;
                }
            }
            catch (BirtException ex) {
                this.rsetEmpty = true;
                this.context.addException(ex);
            }
        }
    }

    protected void accessQuery(ReportItemDesign design, IContentEmitter emitter) {
    }

    public void close() {
        this.rset = null;
        this.rsetEmpty = false;
        super.close();
    }
}

