/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.util.HTMLUtil;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;

public class RowExecutor
extends QueryItemExecutor {
    int rowId;
    int currentCell;

    protected RowExecutor(ExecutorManager manager) {
        super(manager, 13);
    }

    void setRowId(int rowId) {
        this.rowId = rowId;
    }

    int getRowId() {
        return this.rowId;
    }

    public IContent execute() {
        RowDesign rowDesign = (RowDesign)this.getDesign();
        IRowContent rowContent = this.report.createRowContent();
        this.setContent(rowContent);
        this.executeQuery();
        this.initializeContent(rowDesign, rowContent);
        this.processAction(rowDesign, rowContent);
        this.processBookmark(rowDesign, rowContent);
        this.processStyle(rowDesign, rowContent);
        this.processVisibility(rowDesign, rowContent);
        rowContent.setRowID(this.rowId);
        this.setGroupId(rowContent);
        if (this.context.isInFactory()) {
            this.handleOnCreate(rowContent);
        }
        this.startTOCEntry(rowContent);
        this.currentCell = 0;
        return rowContent;
    }

    private void setGroupId(IRowContent rowContent) {
        int groupLevel = HTMLUtil.getGroupLevel(rowContent);
        IBaseResultSet resultSet = this.getParentResultSet();
        if (groupLevel >= 0 && resultSet != null && resultSet.getType() == 0) {
            rowContent.setGroupId(((IQueryResultSet)resultSet).getGroupId(groupLevel));
        }
    }

    public void close() {
        this.finishTOCEntry();
        this.closeQuery();
        this.rowId = 0;
        super.close();
    }

    public boolean hasNextChild() {
        RowDesign rowDesign = (RowDesign)this.design;
        return this.currentCell < rowDesign.getCellCount();
    }

    public IReportItemExecutor getNextChild() {
        RowDesign rowDesign = (RowDesign)this.design;
        if (this.currentCell < rowDesign.getCellCount()) {
            CellDesign cellDesign = rowDesign.getCell(this.currentCell++);
            ReportItemExecutor executor = this.manager.createExecutor(this, cellDesign);
            return executor;
        }
        return null;
    }
}

