/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;

public class AutoTextItemExecutor
extends ReportItemExecutor {
    public AutoTextItemExecutor(ExecutorManager manager) {
        super(manager, 10);
    }

    protected IContent doCreateContent() {
        return this.report.createAutoTextContent();
    }

    public void doExecute() throws Exception {
        AutoTextItemDesign textDesign = (AutoTextItemDesign)this.design;
        IAutoTextContent textContent = (IAutoTextContent)this.content;
        String type = textDesign.getType();
        if ("page-number".equalsIgnoreCase(type)) {
            textContent.setType(1);
            textContent.setText(String.valueOf(this.context.getPageNumber()));
        } else if ("total-page".equalsIgnoreCase(type)) {
            textContent.setType(0);
            long totalPage = this.context.getTotalPage();
            if (totalPage <= 0L) {
                textContent.setText("---");
            } else {
                textContent.setText(String.valueOf(this.context.getTotalPage()));
            }
        }
    }
}

