/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ListingElementExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.TableBandExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;

public class TableItemExecutor
extends ListingElementExecutor {
    private int rowId = 0;

    protected TableItemExecutor(ExecutorManager manager) {
        super(manager, 4);
    }

    int getRowId() {
        return this.rowId;
    }

    void setRowId(int rowId) {
        this.rowId = rowId;
    }

    protected IContent doCreateContent() {
        return this.report.createTableContent();
    }

    protected void doExecute() throws Exception {
        TableItemDesign tableDesign = (TableItemDesign)this.design;
        ITableContent tableContent = (ITableContent)this.content;
        this.executeQuery();
        if (tableContent.getColumnCount() == 0) {
            int i = 0;
            while (i < tableDesign.getColumnCount()) {
                ColumnDesign columnDesign = tableDesign.getColumn(i);
                Column column = new Column(this.report);
                column.setGenerateBy(columnDesign);
                InstanceID iid = new InstanceID(null, columnDesign.getID(), null);
                column.setInstanceID(iid);
                tableContent.addColumn(column);
                ++i;
            }
        } else {
            int columnCount = tableContent.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                Column column = (Column)tableContent.getColumn(i);
                InstanceID iid = column.getInstanceID();
                if (iid != null) {
                    long componentId = iid.getComponentID();
                    ReportElementDesign element = this.report.getDesign().getReportItemByID(componentId);
                    column.setGenerateBy(element);
                }
                ++i;
            }
        }
    }

    public void close() {
        this.closeQuery();
        super.close();
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        ReportItemExecutor executor = super.doCreateExecutor(offset);
        if (executor instanceof TableBandExecutor) {
            TableBandExecutor bandExecutor = (TableBandExecutor)executor;
            bandExecutor.setTableExecutor(this);
        }
        return executor;
    }
}

