/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import com.lowagie.text.Image;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.layout.TextStyle;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.css.CSSValue;

public abstract class PageDeviceRender
implements IAreaVisitor {
    public static final String IMAGE_FOLDER = "image";
    public static final int H_TEXT_SPACE = 30;
    public static final int V_TEXT_SPACE = 100;
    protected float scale;
    int pageHeight;
    int pageWidth;
    protected IReportRunnable reportRunnable;
    protected ReportDesignHandle reportDesign;
    protected IReportContext context;
    protected IEmitterServices services;
    protected int currentX;
    protected int currentY;
    protected Logger logger;
    protected IPageDevice pageDevice;
    protected IPage pageGraphic;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PageDeviceRender() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger(clazz.getName());
    }

    public abstract String getOutputFormat();

    public abstract IPageDevice createPageDevice(String var1, IReportContext var2, IReportContent var3) throws Exception;

    public void start(IReportContent rc) {
        ReportDesignHandle designHandle = rc.getDesign().getReportDesign();
        String title = designHandle.getStringProperty("title");
        try {
            this.pageDevice = this.createPageDevice(title, this.context, rc);
        }
        catch (Exception e) {
            this.log(e, Level.SEVERE);
        }
    }

    protected void log(Throwable t, Level level) {
        this.logger.log(level, t.getMessage(), t);
    }

    public void end(IReportContent rc) {
        try {
            this.pageDevice.close();
        }
        catch (Exception e) {
            this.log(e, Level.WARNING);
        }
    }

    public void setTotalPage(ITextArea totalPage) {
    }

    public void visitText(ITextArea textArea) {
        int x = this.currentX + this.getX(textArea);
        int y = this.currentY + this.getY(textArea);
        this.drawTextAt(textArea, x, y);
    }

    public void visitImage(IImageArea imageArea) {
        this.drawImage(imageArea);
    }

    public void visitAutoText(ITemplateArea templateArea) {
    }

    public void visitContainer(IContainerArea container) {
        this.startContainer(container);
        Iterator iter = container.getChildren();
        while (iter.hasNext()) {
            IArea child = (IArea)iter.next();
            child.accept(this);
        }
        this.endContainer(container);
    }

    protected void startContainer(IContainerArea container) {
        if (container instanceof PageArea) {
            this.scale = container.getScale();
            this.newPage(container);
            this.currentX = 0;
            this.currentY = 0;
        } else {
            if (container.needClip()) {
                this.pageGraphic.clipSave();
                this.clip(container);
            }
            this.drawContainer(container);
            this.currentX += this.getX(container);
            this.currentY += this.getY(container);
        }
    }

    private void clip(IContainerArea container) {
        int startX = this.currentX + this.getX(container);
        int startY = this.currentY + this.getY(container);
        int width = this.getWidth(container);
        int height = this.getHeight(container);
        this.pageGraphic.clip(startX, startY, width, height);
    }

    protected void endContainer(IContainerArea container) {
        if (container instanceof PageArea) {
            this.pageGraphic.dispose();
        } else if (container.needClip()) {
            this.pageGraphic.clipRestore();
        }
        this.currentX -= this.getX(container);
        this.currentY -= this.getY(container);
    }

    protected void newPage(IContainerArea page) {
        this.pageHeight = this.getHeight(page);
        this.pageWidth = this.getWidth(page);
        Color backgroundColor = PropertyUtil.getColor(page.getStyle().getProperty(20));
        this.pageGraphic = this.pageDevice.newPage(this.pageWidth, this.pageHeight, backgroundColor);
        this.drawBackgroundImage(page.getStyle(), 0, 0, this.pageWidth, this.pageHeight);
    }

    private void drawBackgroundImage(IStyle containerStyle, int startX, int startY, int width, int height) {
        boolean yMode;
        float positionY;
        boolean xMode;
        float positionX;
        URL url;
        String imageUri = PropertyUtil.getBackgroundImage(containerStyle.getProperty(9));
        if (imageUri == null) {
            return;
        }
        String imageUrl = imageUri;
        if (this.reportDesign != null && (url = this.reportDesign.findResource(imageUri, 1)) != null) {
            imageUrl = url.toExternalForm();
        }
        if (imageUrl == null || "".equals(imageUrl)) {
            return;
        }
        FloatValue positionValX = (FloatValue)containerStyle.getProperty(45);
        FloatValue positionValY = (FloatValue)containerStyle.getProperty(35);
        if (positionValX == null || positionValY == null) {
            return;
        }
        if (positionValX.getPrimitiveType() == 2) {
            positionX = PropertyUtil.getPercentageValue(positionValX);
            xMode = true;
        } else {
            positionX = this.getScaledValue(positionValX);
            xMode = false;
        }
        if (positionValY.getPrimitiveType() == 2) {
            positionY = PropertyUtil.getPercentageValue(positionValY);
            yMode = true;
        } else {
            positionY = this.getScaledValue(positionValY);
            yMode = false;
        }
        this.drawBackgroundImage(imageUrl, startX, startY, width, height, positionX, positionY, containerStyle.getBackgroundRepeat(), xMode, yMode);
    }

    protected void drawContainer(IContainerArea container) {
        IStyle style = container.getStyle();
        if (style == null) {
            return;
        }
        if (container.getContent() != null) {
            int layoutX = this.currentX + this.getX(container);
            int layoutY = this.currentY + this.getY(container);
            int startX = layoutX;
            int startY = layoutY;
            int width = this.getWidth(container);
            int height = this.getHeight(container);
            Color bc = PropertyUtil.getColor(style.getProperty(20));
            this.pageGraphic.drawBackgroundColor(bc, startX, startY, width, height);
            this.drawBackgroundImage(style, startX, startY, width, height);
            int borderTopWidth = this.getScaledValue(style.getProperty(15));
            int borderLeftWidth = this.getScaledValue(style.getProperty(17));
            int borderBottomWidth = this.getScaledValue(style.getProperty(19));
            int borderRightWidth = this.getScaledValue(style.getProperty(18));
            if (borderTopWidth > 0 || borderLeftWidth > 0 || borderBottomWidth > 0 || borderRightWidth > 0) {
                Color borderTopColor = PropertyUtil.getColor(style.getProperty(21));
                Color borderRightColor = PropertyUtil.getColor(style.getProperty(23));
                Color borderBottomColor = PropertyUtil.getColor(style.getProperty(24));
                Color borderLeftColor = PropertyUtil.getColor(style.getProperty(22));
                BorderInfo[] borders = new BorderInfo[]{new BorderInfo(layoutX + borderLeftWidth / 2, layoutY + borderTopWidth / 2, layoutX + this.getWidth(container) - borderRightWidth / 2, layoutY + borderTopWidth / 2, borderTopWidth, borderTopColor, style.getProperty(10), 0), new BorderInfo(layoutX + this.getWidth(container) - borderRightWidth / 2, layoutY + borderTopWidth / 2, layoutX + this.getWidth(container) - borderRightWidth / 2, layoutY + this.getHeight(container) - borderBottomWidth / 2, borderRightWidth, borderRightColor, style.getProperty(12), 1), new BorderInfo(layoutX + borderLeftWidth / 2, layoutY + this.getHeight(container) - borderBottomWidth / 2, layoutX + this.getWidth(container) - borderRightWidth / 2, layoutY + this.getHeight(container) - borderBottomWidth / 2, borderBottomWidth, borderBottomColor, style.getProperty(13), 2), new BorderInfo(layoutX + borderLeftWidth / 2, layoutY + borderTopWidth / 2, layoutX + borderLeftWidth / 2, layoutY + this.getHeight(container) - borderBottomWidth / 2, borderLeftWidth, borderLeftColor, style.getProperty(11), 3)};
                this.drawBorder(borders);
            }
        }
    }

    protected void drawTextAt(ITextArea text, int textX, int textY) {
        IStyle style = text.getStyle();
        if (!$assertionsDisabled && style == null) {
            throw new AssertionError();
        }
        float fontSize = text.getFontInfo().getFontSize();
        int x = textX + this.getScaledValue((int)(fontSize * 30.0f));
        int y = textY + this.getScaledValue((int)(fontSize * 100.0f));
        FontInfo fontInfo = new FontInfo(text.getFontInfo());
        fontInfo.setFontSize(fontInfo.getFontSize() * this.scale);
        int characterSpacing = this.getScaledValue(PropertyUtil.getDimensionValue(style.getProperty(25)));
        int wordSpacing = this.getScaledValue(PropertyUtil.getDimensionValue(style.getProperty(44)));
        Color color = PropertyUtil.getColor(style.getProperty(14));
        CSSValue align = style.getProperty(26);
        boolean linethrough = IStyle.LINE_THROUGH_VALUE.equals(style.getProperty(16));
        boolean overline = IStyle.OVERLINE_VALUE.equals(style.getProperty(7));
        boolean underline = IStyle.UNDERLINE_VALUE.equals(style.getProperty(8));
        int width = this.getScaledValue(text.getWidth());
        int height = this.getScaledValue(text.getHeight());
        this.pageGraphic.clipSave();
        int clipWidth = width;
        if (fontInfo.getSimulation() && 2 == fontInfo.getFontStyle()) {
            clipWidth = (int)((float)width + (float)height * EmitterUtil.getItalicHorizontalCoefficient());
        }
        this.pageGraphic.clip(textX, textY, clipWidth, height);
        TextStyle textStyle = new TextStyle(fontInfo, characterSpacing, wordSpacing, color, linethrough, overline, underline, align);
        this.drawTextAt(text, x, y, width, height, textStyle);
        this.pageGraphic.clipRestore();
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getText(), x, y, width, height, textStyle);
    }

    /*
     * Exception decompiling
     */
    protected void drawImage(IImageArea image) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 405->409)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] transSvgToArray(String uri) throws IOException {
        InputStream in = null;
        in = new URL(uri).openStream();
        return this.transSvgToArray(in);
    }

    private byte[] transSvgToArray(InputStream inputStream) throws IOException {
        JPEGTranscoder transcoder = new JPEGTranscoder();
        transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        TranscoderInput input = new TranscoderInput(inputStream);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        try {
            transcoder.transcode(input, output);
        }
        catch (TranscoderException transcoderException) {}
        ostream.flush();
        return ostream.toByteArray();
    }

    private void drawBorder(BorderInfo[] borders) {
        BorderInfo bi;
        ArrayList<BorderInfo> dbl = null;
        ArrayList<BorderInfo> solid = null;
        ArrayList<BorderInfo> dashed = null;
        ArrayList<BorderInfo> dotted = null;
        int i = 0;
        while (i < borders.length) {
            if (IStyle.DOUBLE_VALUE.equals(borders[i].borderStyle)) {
                if (dbl == null) {
                    dbl = new ArrayList<BorderInfo>();
                }
                dbl.add(borders[i]);
            } else if (IStyle.DASHED_VALUE.equals(borders[i].borderStyle)) {
                if (dashed == null) {
                    dashed = new ArrayList<BorderInfo>();
                }
                dashed.add(borders[i]);
            } else if (IStyle.DOTTED_VALUE.equals(borders[i].borderStyle)) {
                if (dotted == null) {
                    dotted = new ArrayList<BorderInfo>();
                }
                dotted.add(borders[i]);
            } else {
                if (solid == null) {
                    solid = new ArrayList<BorderInfo>();
                }
                solid.add(borders[i]);
            }
            ++i;
        }
        if (dotted != null) {
            Iterator it = dotted.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                this.pageGraphic.drawLine(bi.startX, bi.startY, bi.endX, bi.endY, bi.borderWidth, bi.borderColor, "dotted");
            }
        }
        if (dashed != null) {
            Iterator it = dashed.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                this.pageGraphic.drawLine(bi.startX, bi.startY, bi.endX, bi.endY, bi.borderWidth, bi.borderColor, "dashed");
            }
        }
        if (solid != null) {
            Iterator it = solid.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                this.pageGraphic.drawLine(bi.startX, bi.startY, bi.endX, bi.endY, bi.borderWidth, bi.borderColor, "solid");
            }
        }
        if (dbl != null) {
            Iterator it = dbl.iterator();
            while (it.hasNext()) {
                bi = (BorderInfo)it.next();
                int borderWidth = bi.borderWidth;
                int outerBorderWidth = borderWidth / 4;
                int innerBorderWidth = borderWidth / 4;
                int startX = bi.startX;
                int startY = bi.startY;
                int endX = bi.endX;
                int endY = bi.endY;
                Color borderColor = bi.borderColor;
                switch (bi.borderType) {
                    case 0: {
                        this.pageGraphic.drawLine(startX - borderWidth / 2 + outerBorderWidth / 2, startY - borderWidth / 2 + outerBorderWidth / 2, endX + borderWidth / 2 - outerBorderWidth / 2, endY - borderWidth / 2 + outerBorderWidth / 2, outerBorderWidth, borderColor, "solid");
                        this.pageGraphic.drawLine(startX - borderWidth / 2 + outerBorderWidth / 2, startY + borderWidth / 2 - innerBorderWidth / 2, endX + borderWidth / 2 - outerBorderWidth / 2, endY + borderWidth / 2 - innerBorderWidth / 2, innerBorderWidth, borderColor, "solid");
                        break;
                    }
                    case 1: {
                        this.pageGraphic.drawLine(startX + borderWidth / 2 - outerBorderWidth / 2, startY - borderWidth / 2 + outerBorderWidth / 2, endX + borderWidth / 2 - outerBorderWidth / 2, endY + borderWidth / 2 - outerBorderWidth / 2, outerBorderWidth, borderColor, "solid");
                        this.pageGraphic.drawLine(startX - borderWidth / 2 + innerBorderWidth / 2, startY - borderWidth / 2 + outerBorderWidth / 2, endX - borderWidth / 2 + innerBorderWidth / 2, endY + borderWidth / 2 - outerBorderWidth / 2, innerBorderWidth, borderColor, "solid");
                        break;
                    }
                    case 2: {
                        this.pageGraphic.drawLine(startX - borderWidth / 2 + outerBorderWidth / 2, startY + borderWidth / 2 - outerBorderWidth / 2, endX + borderWidth / 2 - outerBorderWidth / 2, endY + borderWidth / 2 - outerBorderWidth / 2, outerBorderWidth, borderColor, "solid");
                        this.pageGraphic.drawLine(startX - borderWidth / 2 + outerBorderWidth / 2, startY - borderWidth / 2 + innerBorderWidth / 2, endX + borderWidth / 2 - outerBorderWidth / 2, endY - borderWidth / 2 + innerBorderWidth / 2, innerBorderWidth, borderColor, "solid");
                        break;
                    }
                    case 3: {
                        this.pageGraphic.drawLine(startX - borderWidth / 2 + outerBorderWidth / 2, startY - borderWidth / 2 + outerBorderWidth / 2, endX - borderWidth / 2 + outerBorderWidth / 2, endY + borderWidth / 2 - outerBorderWidth / 2, outerBorderWidth, borderColor, "solid");
                        this.pageGraphic.drawLine(startX + borderWidth / 2 - innerBorderWidth / 2, startY - borderWidth / 2 + outerBorderWidth / 2, endX + borderWidth / 2 - innerBorderWidth / 2, endY + borderWidth / 2 - outerBorderWidth / 2, innerBorderWidth, borderColor, "solid");
                    }
                }
            }
        }
    }

    private void drawBackgroundImage(String imageURI, int x, int y, int width, int height, float positionX, float positionY, String repeat, boolean xMode, boolean yMode) {
        if (imageURI == null) {
            return;
        }
        String imageUrl = this.getImageUrl(imageURI);
        if (imageUrl == null || "".equals(imageUrl)) {
            return;
        }
        if (repeat == null) {
            repeat = "repeat";
        }
        Image img = null;
        try {
            img = Image.getInstance((String)imageUrl);
            int absPosX = xMode ? (int)(((float)width - img.scaledWidth() * 1000.0f) * positionX) : (int)positionX;
            int absPosY = yMode ? (int)(((float)height - img.scaledHeight() * 1000.0f) * positionY) : (int)positionY;
            this.pageGraphic.drawBackgroundImage(x, y, width, height, repeat, imageUrl, absPosX, absPosY);
        }
        catch (Exception e) {
            this.log(e, Level.WARNING);
        }
    }

    private String getImageUrl(String imageUri) {
        URL url;
        String imageUrl = imageUri;
        if (this.reportDesign != null && (url = this.reportDesign.findResource(imageUri, 1)) != null) {
            imageUrl = url.toExternalForm();
        }
        return imageUrl;
    }

    protected int getX(IArea area) {
        return this.getScaledValue(area.getX());
    }

    protected int getY(IArea area) {
        return this.getScaledValue(area.getY());
    }

    protected int getWidth(IArea area) {
        return this.getScaledValue(area.getWidth());
    }

    protected int getHeight(IArea area) {
        return this.getScaledValue(area.getHeight());
    }

    protected int getScaledValue(int value) {
        return (int)((float)value * this.scale);
    }

    private int getScaledValue(CSSValue cssValue) {
        return this.getScaledValue(PropertyUtil.getDimensionValue(cssValue));
    }

    private class BorderInfo {
        public static final int TOP_BORDER = 0;
        public static final int RIGHT_BORDER = 1;
        public static final int BOTTOM_BORDER = 2;
        public static final int LEFT_BORDER = 3;
        public int startX;
        public int startY;
        public int endX;
        public int endY;
        public int borderWidth;
        public Color borderColor;
        public CSSValue borderStyle;
        public int borderType;

        public BorderInfo(int startX, int startY, int endX, int endY, int borderWidth, Color borderColor, CSSValue borderStyle, int borderType) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
            this.borderWidth = borderWidth;
            this.borderColor = borderColor;
            this.borderStyle = borderStyle;
            this.borderType = borderType;
        }
    }
}

