/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.html.buffer.IContainerNode;
import org.eclipse.birt.report.engine.layout.html.buffer.INode;
import org.eclipse.birt.report.engine.layout.html.buffer.PageHintGenerator;

public abstract class AbstractNode
implements INode {
    protected IContent content;
    protected IContentEmitter emitter;
    boolean isFirst = true;
    protected boolean finished = true;
    protected IContainerNode parent;
    protected boolean isStarted = false;
    protected PageHintGenerator generator;
    protected boolean isVisible;

    AbstractNode(IContent content, IContentEmitter emitter, PageHintGenerator generator, boolean isVisible) {
        this.content = content;
        this.emitter = emitter;
        this.generator = generator;
        this.isVisible = isVisible;
    }

    public void setFirst(boolean isFirst) {
        this.isFirst = isFirst;
    }

    public void setStarted(boolean isStarted) {
        this.isStarted = isStarted;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void end() {
        if (this.isVisible) {
            ContentEmitterUtil.endContent(this.content, this.emitter);
        }
        this.generator.end(this.content, this.finished);
    }

    public void setParent(IContainerNode parent) {
        this.parent = parent;
    }

    public IContainerNode getParent() {
        return this.parent;
    }

    public void start() {
        if (this.isStarted) {
            return;
        }
        if (this.parent != null && !this.parent.isStarted()) {
            this.parent.start();
        }
        if (this.isVisible) {
            ContentEmitterUtil.startContent(this.content, this.emitter);
        }
        this.generator.start(this.content, this.isFirst);
        this.isStarted = true;
    }
}

