/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.hyphen;

import java.util.HashSet;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;

public class DefaultWordRecognizer
implements IWordRecognizer {
    static final HashSet excludedSplitChars = new HashSet();
    static final HashSet includedSplitChars = new HashSet();
    protected int start;
    protected String text;
    protected char splitChar;
    protected Word lastWord = null;
    protected Word currentWord = null;

    static {
        excludedSplitChars.add(new Character(' '));
        includedSplitChars.add(new Character('\n'));
    }

    public DefaultWordRecognizer(String text) {
        this.text = text;
    }

    public int getLastWordEnd() {
        return this.lastWord == null ? 0 : this.lastWord.getEnd();
    }

    public Word getNextWord() {
        this.lastWord = this.currentWord;
        if (this.start > this.text.length() - 1) {
            return null;
        }
        int i = this.start;
        while (i < this.text.length()) {
            Character c = new Character(this.text.charAt(i));
            if (excludedSplitChars.contains(c)) {
                this.currentWord = new Word(this.text, this.start, i + 1);
                this.start = i + 1;
                return this.currentWord;
            }
            if (includedSplitChars.contains(c)) {
                if (i == this.start) {
                    this.currentWord = new Word(this.text, this.start, i + 1);
                    this.start = i + 1;
                    return this.currentWord;
                }
                this.currentWord = new Word(this.text, this.start, i);
                this.start = i;
                return this.currentWord;
            }
            ++i;
        }
        this.currentWord = new Word(this.text, this.start, this.text.length());
        this.start = this.text.length();
        return this.currentWord;
    }
}

