/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.ICellEventHandler;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Cell;
import org.eclipse.birt.report.engine.script.internal.instance.CellInstance;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class CellScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(CellHandle cellHandle, ExecutionContext context) {
        try {
            Cell cell = new Cell(cellHandle);
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellHandle, context);
            if (eh != null) {
                eh.onPrepare(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ICellContent content, ExecutionContext context, boolean fromGrid) {
        try {
            Object generateBy = content.getGenerateBy();
            if (generateBy == null) {
                return;
            }
            ReportItemDesign cellDesign = (ReportItemDesign)generateBy;
            if (!CellScriptExecutor.needOnCreate(cellDesign)) {
                return;
            }
            CellInstance cell = new CellInstance(content, context, fromGrid);
            if (CellScriptExecutor.handleJS(cell, cellDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellDesign, context);
            if (eh != null) {
                eh.onCreate(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(ICellContent content, ExecutionContext context) {
        try {
            Object generateBy = content.getGenerateBy();
            if (generateBy == null) {
                return;
            }
            ReportItemDesign cellDesign = (ReportItemDesign)generateBy;
            if (!CellScriptExecutor.needOnRender(cellDesign)) {
                return;
            }
            CellInstance cell = new CellInstance(content, context, false);
            if (CellScriptExecutor.handleJS(cell, cellDesign.getOnRender(), context).didRun()) {
                return;
            }
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellDesign, context);
            if (eh != null) {
                eh.onRender(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(ICellContent content, ExecutionContext context) {
        try {
            Object generateBy = content.getGenerateBy();
            if (generateBy == null) {
                return;
            }
            ReportItemDesign cellDesign = (ReportItemDesign)generateBy;
            if (!CellScriptExecutor.needOnPageBreak(cellDesign)) {
                return;
            }
            CellInstance cell = new CellInstance(content, context, false);
            if (CellScriptExecutor.handleJS(cell, cellDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellDesign, context);
            if (eh != null) {
                eh.onPageBreak(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e);
        }
    }

    private static ICellEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (ICellEventHandler)CellScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            String string = design.getJavaClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.ICellEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CellScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }

    private static ICellEventHandler getEventHandler(CellHandle handle, ExecutionContext context) {
        try {
            return (ICellEventHandler)CellScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.ICellEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CellScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }
}

