/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.script.eventhandler.IImageEventHandler;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Image;
import org.eclipse.birt.report.engine.script.internal.instance.ImageInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;

public class ImageScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(ImageHandle imageHandle, ExecutionContext context) {
        try {
            Image image = new Image(imageHandle);
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageHandle, context);
            if (eh != null) {
                eh.onPrepare(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static void handleOnCreate(IImageContent content, ExecutionContext context) {
        try {
            ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
            if (!ImageScriptExecutor.needOnCreate(imageDesign)) {
                return;
            }
            ImageInstance image = new ImageInstance(content, context);
            if (ImageScriptExecutor.handleJS(image, imageDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onCreate(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IImageContent content, ExecutionContext context) {
        try {
            ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
            if (!ImageScriptExecutor.needOnRender(imageDesign)) {
                return;
            }
            ImageInstance image = new ImageInstance(content, context);
            if (ImageScriptExecutor.handleJS(image, imageDesign.getOnRender(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onRender(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IImageContent content, ExecutionContext context) {
        try {
            ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
            if (!ImageScriptExecutor.needOnPageBreak(imageDesign)) {
                return;
            }
            ImageInstance image = new ImageInstance(content, context);
            if (ImageScriptExecutor.handleJS(image, imageDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onPageBreak(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e);
        }
    }

    private static IImageEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IImageEventHandler)ImageScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            String string = design.getJavaClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IImageEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ImageScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }

    private static IImageEventHandler getEventHandler(ImageHandle handle, ExecutionContext context) {
        try {
            return (IImageEventHandler)ImageScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IImageEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ImageScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }
}

