/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnBandInsertAction;
import org.eclipse.birt.report.model.api.ColumnBandInsertPasteAction;
import org.eclipse.birt.report.model.api.ColumnBandPasteAction;
import org.eclipse.birt.report.model.api.ColumnBandShiftAction;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowBandCopyAction;
import org.eclipse.birt.report.model.api.RowBandInsertAction;
import org.eclipse.birt.report.model.api.RowBandInsertAndPasteAction;
import org.eclipse.birt.report.model.api.RowBandPasteAction;
import org.eclipse.birt.report.model.api.RowBandShiftAction;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableColumnBandAdapter;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableRowBandAdapter;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.table.LayoutTableModel;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.interfaces.ITableItemModel;

public class TableHandle
extends ListingHandle
implements ITableItemModel {
    public TableHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public SlotHandle getColumns() {
        return this.getSlot(4);
    }

    public int getColumnCount() {
        return ((TableItem)this.getElement()).getColumnCount(this.module);
    }

    public String getCaption() {
        return this.getStringProperty("caption");
    }

    public void setCaption(String caption) throws SemanticException {
        this.setStringProperty("caption", caption);
    }

    public String getCaptionKey() {
        return this.getStringProperty("captionID");
    }

    public void setCaptionKey(String captionKey) throws SemanticException {
        this.setStringProperty("captionID", captionKey);
    }

    public boolean canCopyColumn(int columnIndex) {
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        try {
            pasteAction.copyColumnBand(columnIndex);
        }
        catch (SemanticException semanticException) {
            return false;
        }
        return true;
    }

    public boolean canPasteColumn(ColumnBandData data, int columnIndex, boolean inForce) {
        if (data == null) {
            throw new IllegalArgumentException("empty column to check.");
        }
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        return pasteAction.canPaste(columnIndex, inForce, data);
    }

    public boolean canCopyRow(RowOperationParameters parameters) {
        if (parameters == null) {
            return false;
        }
        RowBandCopyAction action = new RowBandCopyAction(new TableRowBandAdapter(this));
        return action.canCopy(parameters);
    }

    public boolean canPasteRow(IDesignElement copiedRow, RowOperationParameters parameters) {
        if (copiedRow == null || parameters == null || !(copiedRow instanceof TableRow)) {
            return false;
        }
        RowBandPasteAction pasteAction = new RowBandPasteAction(new TableRowBandAdapter(this));
        return pasteAction.canPaste((TableRow)copiedRow, parameters);
    }

    public boolean canInsertRow(RowOperationParameters parameters) {
        if (parameters == null) {
            return false;
        }
        RowBandInsertAction pasteAction = new RowBandInsertAction(new TableRowBandAdapter(this));
        return pasteAction.canInsert(parameters);
    }

    public boolean canInsertAndPasteRow(IDesignElement copiedRow, RowOperationParameters parameters) {
        if (copiedRow == null || parameters == null || !(copiedRow instanceof TableRow)) {
            return false;
        }
        RowBandInsertAndPasteAction action = new RowBandInsertAndPasteAction(new TableRowBandAdapter(this));
        return action.canInsertAndPaste((TableRow)copiedRow, parameters);
    }

    public boolean canShiftRow(RowOperationParameters parameters) {
        if (parameters == null) {
            return false;
        }
        RowBandShiftAction action = new RowBandShiftAction(new TableRowBandAdapter(this));
        return action.canShift(parameters);
    }

    public ColumnBandData copyColumn(int columnIndex) throws SemanticException {
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        return pasteAction.copyColumnBand(columnIndex);
    }

    public void pasteColumn(ColumnBandData data, int columnNumber, boolean inForce) throws SemanticException {
        if (data == null) {
            throw new IllegalArgumentException("empty column to paste.");
        }
        ColumnBandPasteAction pasteAction = new ColumnBandPasteAction(new TableColumnBandAdapter(this));
        pasteAction.pasteColumnBand(columnNumber, inForce, data);
    }

    public IDesignElement copyRow(RowOperationParameters parameters) throws SemanticException {
        if (parameters == null) {
            throw new IllegalArgumentException("empty row to copy.");
        }
        RowBandCopyAction action = new RowBandCopyAction(new TableRowBandAdapter(this));
        return action.doCopy(parameters);
    }

    public void pasteRow(IDesignElement copiedRow, RowOperationParameters parameters) throws SemanticException {
        if (copiedRow == null || parameters == null || !(copiedRow instanceof TableRow)) {
            throw new IllegalArgumentException("empty row to paste.");
        }
        RowBandPasteAction pasteAction = new RowBandPasteAction(new TableRowBandAdapter(this));
        pasteAction.doPaste((TableRow)copiedRow, parameters);
    }

    public void insertRow(RowOperationParameters parameters) throws SemanticException {
        if (parameters == null) {
            throw new IllegalArgumentException("empty row to insert.");
        }
        RowBandInsertAction action = new RowBandInsertAction(new TableRowBandAdapter(this));
        action.doInsert(parameters);
    }

    public void insertAndPasteRow(IDesignElement copiedRow, RowOperationParameters parameters) throws SemanticException {
        if (copiedRow == null || parameters == null || !(copiedRow instanceof TableRow)) {
            throw new IllegalArgumentException("empty row to insert and paste.");
        }
        RowBandInsertAndPasteAction action = new RowBandInsertAndPasteAction(new TableRowBandAdapter(this));
        action.doInsertAndPaste((TableRow)copiedRow, parameters);
    }

    public void shiftRow(RowOperationParameters parameters) throws SemanticException {
        if (parameters == null) {
            throw new IllegalArgumentException("empty row to shift.");
        }
        RowBandShiftAction action = new RowBandShiftAction(new TableRowBandAdapter(this));
        action.doShift(parameters);
    }

    public void insertAndPasteColumn(ColumnBandData data, int columnNumber) throws SemanticException {
        if (data == null) {
            throw new IllegalArgumentException("empty column to paste.");
        }
        ColumnBandInsertPasteAction insertAction = new ColumnBandInsertPasteAction(new TableColumnBandAdapter(this));
        insertAction.insertAndPasteColumnBand(columnNumber, data);
    }

    public boolean canInsertAndPasteColumn(ColumnBandData data, int columnIndex) {
        if (data == null) {
            throw new IllegalArgumentException("empty column to check.");
        }
        ColumnBandInsertPasteAction insertAction = new ColumnBandInsertPasteAction(new TableColumnBandAdapter(this));
        return insertAction.canInsertAndPaste(columnIndex, data);
    }

    public void shiftColumn(int sourceColumn, int destColumn) throws SemanticException {
        ColumnBandShiftAction shiftAction = new ColumnBandShiftAction(new TableColumnBandAdapter(this));
        shiftAction.shiftColumnBand(sourceColumn, destColumn);
    }

    public boolean canShiftColumn(int sourceColumn, int destColumn) {
        ColumnBandShiftAction shiftAction = new ColumnBandShiftAction(new TableColumnBandAdapter(this));
        try {
            shiftAction.getShiftData(sourceColumn);
        }
        catch (SemanticException semanticException) {
            return false;
        }
        return shiftAction.checkTargetColumn(sourceColumn, destColumn);
    }

    public LayoutTableModel getLayoutModel() {
        return new LayoutTableModel(this);
    }

    public void insertColumn(int columnNumber, int positionFlag) throws SemanticException {
        ColumnBandInsertAction insertAction = new ColumnBandInsertAction(new TableColumnBandAdapter(this));
        insertAction.insertColumnBand(columnNumber, positionFlag);
    }

    protected CellHandle getCell(int row, int column) {
        return this.getLayoutModel().getCell(row, column);
    }

    public CellHandle getCell(int slotId, int groupLevel, int row, int column) {
        if (groupLevel <= 0) {
            return this.getLayoutModel().getCell(slotId, row, column);
        }
        return this.getLayoutModel().getCell(groupLevel, slotId, row, column);
    }

    public ColumnHandle findColumn(int columnNum) {
        TableColumn targetColumn = ColumnHelper.findColumn(this.module, this.getColumns().getSlot(), columnNum);
        return (ColumnHandle)targetColumn.getHandle(this.module);
    }

    public List getFilters(int colIndex) {
        if (colIndex < 0 || colIndex >= this.getColumnCount()) {
            return Collections.EMPTY_LIST;
        }
        String expr = this.getResultSetColumn(colIndex);
        if (expr == null) {
            return null;
        }
        ArrayList retValue = new ArrayList();
        Iterator iter = this.filtersIterator();
        List tempList = this.checkFilters(iter, expr);
        if (tempList != null) {
            retValue.addAll(tempList);
        }
        SlotHandle groupSlot = this.getGroups();
        int i = 0;
        while (i < groupSlot.getCount()) {
            TableGroupHandle tableGroup = (TableGroupHandle)groupSlot.get(i);
            iter = tableGroup.filtersIterator();
            tempList = this.checkFilters(iter, expr);
            if (tempList != null) {
                retValue.addAll(tempList);
            }
            ++i;
        }
        return retValue;
    }

    private List checkFilters(Iterator iter, String expr) {
        ArrayList<FilterConditionHandle> retValue = new ArrayList<FilterConditionHandle>();
        block2: while (iter.hasNext()) {
            FilterConditionHandle condition = (FilterConditionHandle)iter.next();
            String curExpr = condition.getExpr();
            List cols = null;
            try {
                cols = ExpressionUtil.extractColumnExpressions((String)curExpr, (boolean)true);
            }
            catch (BirtException birtException) {
                continue;
            }
            if (cols == null) continue;
            int i = 0;
            while (i < cols.size()) {
                String tmpExpr = ((IColumnBinding)cols.get(i)).getResultSetColumnName();
                if (expr.equals(tmpExpr)) {
                    retValue.add(condition);
                    continue block2;
                }
                ++i;
            }
        }
        return retValue;
    }

    private String getResultSetColumn(int columnIndex) {
        SlotHandle detail = this.getDetail();
        int i = 0;
        while (i < detail.getCount()) {
            CellHandle detailcell = this.getCell(2, -1, i + 1, columnIndex + 1);
            if (detailcell != null) {
                Iterator it = detailcell.getContent().iterator();
                while (it.hasNext()) {
                    ReportItemHandle rptItem = (ReportItemHandle)it.next();
                    if (!(rptItem instanceof DataItemHandle)) continue;
                    return ((DataItemHandle)rptItem).getResultSetColumn();
                }
            }
            ++i;
        }
        return null;
    }
}

