/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.Serializable;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.Span;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.Rule;

public class Data
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -316995334044186083L;
    private static int ID = 0;
    public static final String DATE = "DATE";
    public static final String NUMBER = "NUMBER";
    public static final String STRING = "STRING";
    public static final String CALENDAR = "CALENDAR";
    public static final String CDATETIME = "CDATETIME";
    Object txt;
    int styleId;
    int id;
    String datatype = "STRING";
    StyleEntry style;
    Span span;
    Rule rule;
    HyperlinkDef url;
    boolean isTxtData = true;

    public Data(Object txt, String datatype) {
        this(txt, null, datatype);
    }

    public Data(Object txt, StyleEntry s, String datatype) {
        this.txt = txt;
        this.style = s;
        this.datatype = datatype;
        this.id = ID++;
    }

    protected void setNotTxtData() {
        this.isTxtData = false;
    }

    public String getText() {
        if (this.txt == null) {
            return " ";
        }
        if (this.datatype.equals(DATE)) {
            return ExcelUtil.formatDate(this.txt);
        }
        if (this.datatype.equals(NUMBER)) {
            if (this.txt.toString().length() > 31) {
                return ExcelUtil.formatNumber(this.txt);
            }
            return this.txt.toString();
        }
        return this.txt.toString();
    }

    public int hashCode() {
        return this.id;
    }

    public void setDatatype(String type) {
        this.datatype = type;
    }

    public String getDatatype() {
        return this.datatype;
    }

    protected Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        Data data = (Data)o;
        return data.id == this.id;
    }

    public void setStyleId(int id) {
        this.styleId = id;
    }

    public int getStyleId() {
        return this.styleId;
    }

    public void setStyleEntry(StyleEntry entry) {
        this.style = entry;
    }

    public StyleEntry getStyleEntry() {
        return this.style;
    }

    public HyperlinkDef getHyperlinkDef() {
        return this.url;
    }

    public void setHyperlinkDef(HyperlinkDef def) {
        this.url = def;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setSpan(Span span) {
        this.span = span;
    }

    public Span getSpan() {
        return this.span;
    }
}

