/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.sql.Time;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.engine.emitter.excel.GroupInfo;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class ExcelUtil {
    private static final int max_formula_length = 512;
    private static final String reg1 = "Total.(count|ave|sum|max|min)\\(";
    private static final String reg2 = "\\)";
    private static final String reg3 = "\\[";
    private static final String reg4 = "\\]";

    public static String ridQuote(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static String formatDate(Object data) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return dateFormat.format((Date)data);
    }

    public static String formatNumber(Object data) {
        DecimalFormat numberFormat = new DecimalFormat("0.00E00");
        return numberFormat.format((Object)((Number)data));
    }

    public static String getType(Object val) {
        if (val instanceof Number) {
            return "NUMBER";
        }
        if (val instanceof Date) {
            return "DATE";
        }
        if (val instanceof Calendar) {
            return "CALENDAR";
        }
        if (val instanceof CDateTime) {
            return "CDATETIME";
        }
        return "STRING";
    }

    public static String getPattern(Object data, String val) {
        if (val != null && data instanceof Date) {
            if (val.indexOf("kk:mm") >= 0) {
                return "Short Time";
            }
            if (val.startsWith("ahh")) {
                return "Long Time";
            }
            if (!val.startsWith("ahh") && val.indexOf("ahh") >= 0) {
                return "General Date";
            }
            return new DateFormatter(val).getPattern();
        }
        if (val == null && data instanceof Time) {
            return "Long Time";
        }
        if (val == null && data instanceof java.sql.Date) {
            return "yyyy-M-d";
        }
        if (val == null && data instanceof Date) {
            return "yyyy-M-d HH:ss:mm AM/PM";
        }
        if (val != null && data instanceof Number) {
            if (val.indexOf("E") >= 0) {
                return "Scientific";
            }
            return new NumberFormatter(val).getPattern();
        }
        if (val != null && data instanceof String) {
            return new StringFormatter(val).getPattern();
        }
        return null;
    }

    public static String getValue(String val) {
        if (val == null) {
            return "NULL";
        }
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static int convertToPt(String size) {
        try {
            int s = Integer.valueOf(size.substring(0, size.length() - 2));
            if (size.endsWith("in")) {
                return s * 72;
            }
            if (size.endsWith("cm")) {
                return (int)((double)s / 2.54 * 72.0);
            }
            if (size.endsWith("mm")) {
                return (int)((double)(s * 10) / 2.54 * 72.0);
            }
            if (size.endsWith("pc")) {
                return s;
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getColumnOfExp(String exp) {
        return exp.substring(exp.indexOf("dataSetRow["), exp.lastIndexOf("]") + 1);
    }

    public static String createFormula(String txt, String exp, List positions) {
        exp = ExcelUtil.getFormulaName(exp);
        StringBuffer sb = new StringBuffer(String.valueOf(exp) + "(");
        int i = 0;
        while (i < positions.size()) {
            GroupInfo.Position p = (GroupInfo.Position)positions.get(i);
            sb.append("R" + p.row + "C" + p.column + ",");
            ++i;
        }
        sb.setCharAt(sb.length() - 1, ')');
        if (sb.length() > 512 || positions.size() == 0) {
            return txt;
        }
        return sb.toString();
    }

    private static String getFormulaName(String expression) {
        if (expression.startsWith("Total.sum")) {
            return "=SUM";
        }
        if (expression.startsWith("Total.ave")) {
            return "=AVERAGE";
        }
        if (expression.startsWith("Total.max")) {
            return "=MAX";
        }
        if (expression.startsWith("Total.min")) {
            return "=MIN";
        }
        if (expression.startsWith("Total.count")) {
            return "=COUNT";
        }
        throw new RuntimeException("Cannot parse the expression" + expression);
    }

    public static boolean isNumber(String val) {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            nf.parse(val);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isValidExp(String exp, String[] columnNames) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < columnNames.length) {
            sb.append(String.valueOf(columnNames[i]) + "|");
            ++i;
        }
        String columnRegExp = "(" + sb.substring(0, sb.length() - 1) + ")";
        columnRegExp = columnRegExp.replaceAll(reg3, "Z");
        columnRegExp = columnRegExp.replaceAll(reg4, "Z");
        String aggregateRegExp = reg1 + columnRegExp + reg2;
        exp = exp.replaceAll(reg3, "Z");
        exp = exp.replaceAll(reg4, "Z");
        Pattern p = Pattern.compile(aggregateRegExp);
        Matcher m = p.matcher(exp);
        boolean agg = m.matches();
        p = Pattern.compile(columnRegExp);
        m = p.matcher(exp);
        return agg || m.matches();
    }

    public static String expression(String val, String target, String[] res, boolean casesenstive) {
        boolean flag = casesenstive ? target.equals(val) : target.equalsIgnoreCase(val);
        return flag ? res[1] : res[0];
    }

    public static int covertDimensionType(DimensionType value, int parent) {
        if ("%".equals(value.getUnits())) {
            return (int)(value.getMeasure() / 100.0 * (double)parent);
        }
        return (int)value.convertTo("pt");
    }
}

