/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.engine.emitter.excel.layout.Rule;

public class AxisProcessor {
    private List naxis = new ArrayList();

    public AxisProcessor() {
        this.addCoordinate(0);
    }

    public void addCoordinates(int[] values) {
        int i = 0;
        while (i < values.length) {
            this.addCoordinate(values[i]);
            ++i;
        }
    }

    public void addCoordinate(int value) {
        Integer index = new Integer(value);
        if (!this.naxis.contains(index)) {
            this.naxis.add(index);
            Collections.sort(this.naxis);
        }
    }

    public int[] getRange(int start, int end) {
        int sp = this.getCoordinate(start);
        int ep = this.getCoordinate(end);
        List list = this.naxis.subList(sp, ep + 1);
        Integer[] values = new Integer[list.size()];
        values = list.toArray(values);
        int[] pos = new int[values.length];
        int i = 0;
        while (i < pos.length) {
            pos[i] = values[i];
            ++i;
        }
        return pos;
    }

    public int getCoordinate(int value) {
        return this.naxis.indexOf(new Integer(value));
    }

    public Rule getRule(int value) {
        int start = (Integer)this.naxis.get(value);
        int end = (Integer)this.naxis.get(value + 1);
        return new Rule(start, end - start);
    }

    public int[] getCoordinates() {
        Integer[] columns = new Integer[this.naxis.size()];
        this.naxis.toArray(columns);
        int[] scale = new int[columns.length - 1];
        int i = 0;
        while (i < columns.length - 2) {
            scale[i] = columns[i + 1] - columns[i];
            ++i;
        }
        return scale;
    }
}

