/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.DataCache;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.Span;
import org.eclipse.birt.report.engine.emitter.excel.StyleEngine;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.AxisProcessor;
import org.eclipse.birt.report.engine.emitter.excel.layout.PageDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.Rule;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsTable;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class ExcelLayoutEngine {
    public static final String EMPTY = "";
    public static final int MAX_ROW = 65525;
    public static final int MAX_COLUMN = 255;
    public static final Object waste = new Object();
    private DataCache cache;
    private AxisProcessor axis;
    private StyleEngine engine;
    private int detal;
    private int left;
    private Stack containers = new Stack();
    private Stack tables = new Stack();
    private Hashtable links = new Hashtable();

    public ExcelLayoutEngine(PageDef page) {
        int[] init;
        this.axis = new AxisProcessor();
        init = new int[]{page.leftmargin, page.contentwidth + init[0], page.rightmargin + init[1]};
        this.axis.addCoordinates(init);
        Rule rule = new Rule(init[0], init[1] - init[0]);
        this.cache = new DataCache(65525, 255);
        this.engine = new StyleEngine(this);
        this.detal = init[0] == 0 ? 0 : 1;
        this.left = init[0];
        this.containers.push(this.createContainer(rule, page.style));
    }

    public XlsContainer getCurrentContainer() {
        return (XlsContainer)this.containers.peek();
    }

    public Stack getContainers() {
        return this.containers;
    }

    public void addTable(TableInfo table, IStyle style) {
        Rule rule = this.getCurrentContainer().getRule();
        int start = rule.getStart();
        int[] npos = new int[table.getColumnCount()];
        npos[0] = start;
        int i = 1;
        while (i < table.getColumnCount()) {
            npos[i] = npos[i - 1] + table.getColumnWidth(i - 1);
            ++i;
        }
        int[] scale = this.axis.getRange(start, rule.getEnd());
        int i2 = 0;
        while (i2 < scale.length - 1) {
            int sp = scale[i2];
            int se = scale[i2 + 1];
            int[] range = this.inRange(sp, se, npos);
            if (range.length > 0) {
                int pos = this.axis.getCoordinate(sp) - this.detal;
                this.cache.insertColumns(pos, range.length);
                int j = 0;
                while (j < range.length) {
                    this.axis.addCoordinate(range[j]);
                    ++j;
                }
            }
            ++i2;
        }
        XlsContainer container = this.createContainer(rule, style);
        XlsTable tcontainer = new XlsTable(table, container);
        this.addContainer(tcontainer);
        this.tables.push(tcontainer);
    }

    private int[] inRange(int start, int end, int[] data) {
        int[] range = new int[data.length];
        int count = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > start && data[i] < end) {
                range[++count] = data[i];
            }
            ++i;
        }
        int[] result = new int[count];
        int j = 0;
        int i2 = 0;
        while (i2 < range.length) {
            if (range[i2] != 0) {
                result[j] = range[i2];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public void addCell(int col, int span, IStyle style) {
        XlsTable table = (XlsTable)this.tables.peek();
        Rule rule = table.getColumnRule(col, span);
        this.addContainer(this.createContainer(rule, style));
    }

    public void endCell() {
        this.endContainer();
    }

    public void addRow(IStyle style) {
        XlsTable table = (XlsTable)this.containers.peek();
        XlsContainer container = this.createContainer(table.getRule(), style);
        container.setEmpty(false);
        this.addContainer(container);
    }

    public void endRow() {
        this.synchronous();
        this.endContainer();
    }

    private void synchronous() {
        Rule rule = this.getCurrentContainer().getRule();
        int start = rule.getStart();
        int end = rule.getEnd();
        int startcol = this.axis.getCoordinate(start);
        int endcol = this.axis.getCoordinate(end);
        int max = 0;
        int[] len = new int[endcol - startcol];
        int i = startcol;
        while (i < endcol) {
            int columnsize;
            len[i - startcol] = columnsize = this.cache.getColumnSize(i - this.detal);
            max = max > columnsize ? max : columnsize;
            ++i;
        }
        i = startcol;
        while (i < endcol) {
            int times = max - len[i - startcol];
            while (times-- > 0) {
                Rule colrule = this.axis.getRule(i);
                Data data = new Data(EMPTY, this.engine.createHorizionStyle(colrule), "STRING");
                data.setRule(colrule);
                this.cache.addData(i - this.detal, data);
            }
            ++i;
        }
    }

    public void endTable() {
        if (!this.tables.isEmpty()) {
            this.tables.pop();
            this.endContainer();
        }
    }

    public void addContainer(IStyle style, HyperlinkDef link) {
        Rule rule = this.getCurrentContainer().getRule();
        StyleEntry entry = this.engine.createEntry(rule, style);
        this.addContainer(new XlsContainer(entry, rule));
    }

    public void addContainer(XlsContainer container) {
        this.getCurrentContainer().setEmpty(false);
        int col = this.axis.getCoordinate(container.getRule().getStart());
        int pos = this.cache.getColumnSize(col - this.detal);
        container.setStart(pos);
        this.containers.push(container);
    }

    public void endContainer() {
        XlsContainer container = this.getCurrentContainer();
        if (container.isEmpty()) {
            Data data = new Data(EMPTY, container.getStyle(), "STRING");
            data.setRule(container.getRule());
            this.addData(data);
        }
        this.engine.removeContainerStyle();
        this.containers.pop();
    }

    public void addData(Object txt, IStyle style, HyperlinkDef link) {
        Rule rule = this.getCurrentContainer().getRule();
        StyleEntry entry = this.engine.getStyle(style, rule);
        Data data = this.createData(txt, entry);
        data.setHyperlinkDef(link);
        data.setRule(rule);
        this.addData(data);
    }

    public Data createData(Object txt, StyleEntry entry) {
        if (txt instanceof IDataContent) {
            String format;
            ReportItemDesign genDesign;
            IDataContent dataContent = (IDataContent)txt;
            Object value = dataContent.getValue();
            String text = dataContent.getText();
            Object genBy = dataContent.getGenerateBy();
            if (genBy instanceof ReportItemDesign && (genDesign = (ReportItemDesign)genBy).getMap() != null && genDesign.getMap().getRuleCount() > 0) {
                entry.setProperty(25, "STRING");
                return new Data(text.trim(), entry, "STRING");
            }
            if (ExcelUtil.getType(value).equals("NUMBER")) {
                format = ExcelUtil.getPattern(value, entry.getProperty(23));
                entry.setProperty(23, format);
                entry.setProperty(25, "NUMBER");
                return new Data(value, entry, "NUMBER");
            }
            if (ExcelUtil.getType(value).equals("DATE")) {
                format = ExcelUtil.getPattern(value, entry.getProperty(22));
                entry.setProperty(22, format);
                entry.setProperty(25, "DATE");
                return new Data(value, entry, "DATE");
            }
            entry.setProperty(25, "STRING");
            return new Data(text.trim(), entry, "STRING");
        }
        entry.setProperty(25, "STRING");
        return new Data(txt, entry, "STRING");
    }

    private void addData(Data data) {
        this.getCurrentContainer().setEmpty(false);
        int col = this.axis.getCoordinate(data.getRule().getStart());
        int span = this.axis.getCoordinate(data.getRule().getEnd()) - col;
        this.addDatatoCache(col, data);
        int i = col + 1;
        while (i < col + span) {
            this.addDatatoCache(i, waste);
            ++i;
        }
    }

    public XlsContainer createContainer(Rule rule, IStyle style) {
        return new XlsContainer(this.engine.createEntry(rule, style), rule);
    }

    public Map getStyleMap() {
        return this.engine.getStyleIDMap();
    }

    public int[] getCoordinates() {
        return this.axis.getCoordinates();
    }

    public int getRowCount() {
        int realcount = this.cache.getRowCount();
        return Math.min(realcount, 65524);
    }

    public AxisProcessor getAxis() {
        return this.axis;
    }

    public int getColumnSize(int column) {
        return this.cache.getColumnSize(column - this.detal);
    }

    public Data getData(int col, int row) {
        Object object = this.cache.getData(col - this.detal, row);
        return object == waste ? null : (Data)object;
    }

    public Data[] getRow(int rownum) {
        Object[] row = this.cache.getRowData(rownum);
        ArrayList<Object> data = new ArrayList<Object>();
        int width = Math.min(row.length, 254);
        int i = 0;
        while (i < width) {
            if (waste != row[i]) {
                Data d = (Data)row[i];
                HyperlinkDef def = d.getHyperlinkDef();
                if (def != null && def.getType() == 2) {
                    def.setUrl((String)this.links.get(def.getUrl()));
                }
                data.add(row[i]);
            }
            ++i;
        }
        return data.toArray(new Data[0]);
    }

    private void addDatatoCache(int col, Object value) {
        this.cache.addData(col - this.detal, value);
    }

    public void complete() {
        int rowcount = this.cache.getRowCount();
        int i = 0;
        while (i < rowcount) {
            Object[] row = this.cache.getRowData(i);
            int j = 0;
            while (j < row.length) {
                if (row[j] != waste) {
                    Data d = (Data)row[j];
                    int styleid = this.engine.getStyleID(d.getStyleEntry());
                    d.setStyleId(styleid);
                    Rule rule = d.getRule();
                    int start = this.axis.getCoordinate(rule.getStart());
                    int end = this.axis.getCoordinate(rule.getEnd());
                    Span span = new Span(start + 1, end - start - 1);
                    HyperlinkDef link = d.getHyperlinkDef();
                    if (link != null && link.getBookmark() != null) {
                        this.links.put(link.getBookmark(), this.getCellName(i + 1, start + 1));
                    }
                    d.setSpan(span);
                }
                ++j;
            }
            ++i;
        }
    }

    private String getCellName(int row, int col) {
        char base = (char)(col + 64);
        Character chr = new Character(base);
        return String.valueOf(chr.toString()) + row;
    }
}

