/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

public class Finance {
    private Finance() {
    }

    public static double ddb(double cost, double salvage, double life, int period) throws IllegalArgumentException {
        double prior = 0.0;
        double depr = 0.0;
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0 || period <= 0 || life == Double.NaN || salvage == Double.NaN || cost == Double.NaN || (double)period == Double.NaN) {
            throw new IllegalArgumentException("There exists illegal parameter in the function DDB");
        }
        double rate = 1.0 / life * 2.0;
        int x = 0;
        while (x < period) {
            double basis = cost - prior;
            depr = Math.min(basis - salvage, basis * rate);
            prior += depr;
            ++x;
        }
        return depr;
    }

    public static double sln(double cost, double salvage, double life) throws IllegalArgumentException {
        return (cost - salvage) / life;
    }

    public static double syd(double cost, double salvage, double life, int period) throws IllegalArgumentException {
        return (cost - salvage) * (life - (double)period + 1.0) * 2.0 / (life * (life + 1.0));
    }

    public static double fv(double rate, int nPer, double pmt, double pv, int due) throws IllegalArgumentException {
        double fv = 0.0;
        int start = 0;
        int end = 0;
        if (rate < 0.0 || nPer < 0 || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function FV");
        }
        switch (due) {
            case 1: {
                start = 1;
                end = nPer;
                break;
            }
            case 0: {
                start = 0;
                end = nPer - 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("There exists illegal parameter" + due);
            }
        }
        int i = start;
        while (i <= end) {
            fv += Math.pow(1.0 + rate, i);
            ++i;
        }
        fv *= pmt;
        if (pv != 0.0) {
            fv += pv * Math.pow(1.0 + rate, new Integer(nPer).doubleValue());
        }
        return 0.0 - fv;
    }

    public static double pmt(double rate, int nper, double pv, double fv, int due) throws IllegalArgumentException {
        double curr;
        int start_pv = 0;
        int end_pv = 0;
        int start_fv = 0;
        int end_fv = 0;
        double pmt = 0.0;
        double df_pv = 0.0;
        double df_fv = 0.0;
        if (nper <= 0) {
            throw new IllegalArgumentException("There exists illegal parameter  nper=" + nper);
        }
        switch (due) {
            case 0: {
                start_pv = 1;
                end_pv = nper;
                start_fv = 0;
                end_fv = nper - 1;
                break;
            }
            case 1: {
                start_pv = 0;
                end_pv = nper - 1;
                start_fv = 1;
                end_fv = nper;
                break;
            }
            default: {
                throw new IllegalArgumentException("There exists illegal parameter" + due);
            }
        }
        int t = start_pv;
        while (t <= end_pv) {
            curr = Math.pow(1.0 + rate, new Integer(t).doubleValue());
            df_pv += 1.0 / curr;
            ++t;
        }
        t = start_fv;
        while (t <= end_fv) {
            curr = Math.pow(1.0 + rate, new Integer(t).doubleValue());
            df_fv += curr;
            ++t;
        }
        pmt = pv / df_pv + fv / df_fv;
        return -pmt;
    }

    public static double ipmt(double rate, int per, int nPer, double pv, double fv, int due) throws IllegalArgumentException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function IPMT");
        }
        double pmt = Math.abs(Finance.pmt(rate, nPer, pv, fv, due));
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            if (curper != 1 || due == 0) {
                ipmt = rate * principal;
            }
            ppmt = pmt - ipmt;
            principal -= ppmt;
            ++curper;
        }
        if (pv > 0.0 || pv == 0.0 && fv > 0.0) {
            ipmt *= -1.0;
        }
        return ipmt;
    }

    public static double ppmt(double rate, int per, int nPer, double pv, double fv, int due) throws IllegalArgumentException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function PPMT");
        }
        double pmt = Math.abs(Finance.pmt(rate, nPer, pv, fv, due));
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            if (curper != 1 || due == 0) {
                ipmt = rate * principal;
            }
            ppmt = pmt - ipmt;
            principal -= ppmt;
            ++curper;
        }
        if (pv > 0.0 || pv == 0.0 && fv > 0.0) {
            ppmt *= -1.0;
        }
        return ppmt;
    }

    public static double nper(double rate, double pmt, double pv, double fv, int due) throws IllegalArgumentException {
        double retval = 0.0;
        if (rate == 0.0) {
            retval = -1.0 * (fv + pv) / pmt;
        } else {
            double r1 = rate + 1.0;
            double ryr = (due == 1 ? r1 : 1.0) * pmt / rate;
            double a1 = ryr - fv < 0.0 ? Math.log(fv - ryr) : Math.log(ryr - fv);
            double a2 = ryr - fv < 0.0 ? Math.log(-pv - ryr) : Math.log(pv + ryr);
            double a3 = Math.log(r1);
            retval = (a1 - a2) / a3;
        }
        return retval;
    }

    public static double nPer(double rate, double pmt, double pv, double fv, int due) throws IllegalArgumentException {
        return Finance.nper(rate, pmt, pv, fv, due);
    }

    public static double pv(double rate, int nPer, double pmt, double fv, int due) throws IllegalArgumentException {
        double pv = 0.0;
        if (nPer < 0 || due != 1 && due != 0) {
            throw new IllegalArgumentException("There exists illegal parameter in the function PV");
        }
        if (rate < 0.0) {
            pv = -fv - pmt * (double)nPer;
        } else {
            double denom = Math.pow(1.0 + rate, nPer);
            double num = -fv - pmt * (1.0 + rate * (double)due) * (denom - 1.0) / rate;
            pv = num / denom;
        }
        return pv;
    }

    private static double solvePmt(int nPer, double true_pmt, double loanamt, double fv, int due, double rate, double incr, int attempt, boolean found) {
        double tolerance = 1.0E-7;
        if (attempt > 1000) {
            found = false;
            return -1.0;
        }
        double diff1 = true_pmt - Finance.pmt(rate + incr, nPer, loanamt, fv, due);
        if (Math.abs(diff1) <= tolerance) {
            found = true;
            return rate + incr;
        }
        double diff2 = true_pmt - Finance.pmt(rate, nPer, loanamt, fv, due);
        if (Math.abs(diff2) <= tolerance) {
            found = true;
            return rate;
        }
        if (diff1 * diff2 < 0.0) {
            incr /= 10.0;
        } else {
            rate += incr;
        }
        return Finance.solvePmt(nPer, true_pmt, loanamt, fv, due, rate, incr, ++attempt, found);
    }

    public static double rate(int nPer, double pmt, double pv, double fv, int due, double guess) throws IllegalArgumentException {
        double tmp;
        double incr = 0.1;
        boolean found = true;
        double result = 0.0;
        if (nPer <= 0 || due != 1 && due != 0) {
            if (nPer <= 0) {
                throw new IllegalArgumentException("There exists illegal parameter:" + nPer);
            }
            throw new IllegalArgumentException("There exists illegal parameter:" + due);
        }
        int i = 5;
        double curr_guess = guess;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = 0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess /= 2.0;
            --i;
        }
        i = 4;
        curr_guess = guess * 2.0;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = 0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess *= 2.0;
            --i;
        }
        i = 5;
        curr_guess = guess;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = -0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess /= 2.0;
            --i;
        }
        i = 4;
        curr_guess = guess * 2.0;
        --i;
        while (i > 0) {
            tmp = curr_guess;
            incr = -0.1;
            result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
            if (result != -1.0) {
                return result;
            }
            curr_guess *= 2.0;
            --i;
        }
        throw new IllegalArgumentException("User should reset a new rate guess");
    }

    public static double percent(double denom, double num, double valueIfZero) {
        if (num == 0.0) {
            return valueIfZero;
        }
        if (denom == 0.0) {
            throw new IllegalArgumentException("There exists illegal parameter:" + denom);
        }
        return num / denom * 100.0;
    }

    public static double npv(double rate, double[] arptr) throws IllegalArgumentException {
        double r1;
        if (arptr == null) {
            throw new IllegalArgumentException("There exists illegal parameter:" + arptr);
        }
        double npv = 0.0;
        double trate = r1 = 1.0 + rate;
        int i = 0;
        while (i < arptr.length) {
            npv += arptr[i] / trate;
            trate *= r1;
            ++i;
        }
        return npv;
    }

    private static double calcIrr(double[] cash, double intrate, double inc, int attempt) {
        double tolerance = 1.0E-7;
        if (attempt > 1000) {
            return -1.0;
        }
        double npv1 = Finance.npv(intrate + inc, cash);
        if (Math.abs(npv1) <= tolerance) {
            return intrate + inc;
        }
        double npv2 = Finance.npv(intrate, cash);
        if (npv2 * npv1 < 0.0) {
            inc /= 10.0;
        } else {
            intrate += inc;
        }
        return Finance.calcIrr(cash, intrate, inc, ++attempt);
    }

    public static double irr(double[] cash, double intrate) throws IllegalArgumentException {
        double result;
        double incr;
        double tmp;
        boolean arg1Positive = true;
        long arsize = 0L;
        if (cash != null) {
            arsize = cash.length;
        }
        if ((tmp = cash[0]) < 0.0) {
            arg1Positive = false;
        } else if (tmp > 0.0) {
            arg1Positive = true;
        } else {
            throw new IllegalArgumentException("BADSIGNSINARRAY");
        }
        boolean found = false;
        int i = 1;
        while ((long)i <= arsize) {
            tmp = cash[i - 1];
            if (arg1Positive && tmp < 0.0 || !arg1Positive && tmp > 0.0) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new IllegalArgumentException("BADSIGNSINARRAY");
        }
        i = 10;
        double curr_rate = intrate;
        --i;
        while (i > 0) {
            double d;
            incr = 0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d < 0.0) {
                return result;
            }
            curr_rate /= 2.0;
            --i;
        }
        i = 4;
        curr_rate = intrate * 2.0;
        --i;
        while (i > 0) {
            double d;
            incr = 0.1;
            tmp = curr_rate;
            result = Finance.calcIrr(cash, tmp, incr, 0);
            if (d >= 0.0) {
                return result;
            }
            curr_rate *= 2.0;
            --i;
        }
        throw new IllegalArgumentException("NOSOLUTIONFOUND");
    }

    private static double neg_npv(double rate, double[] arptr) {
        double r1;
        double npv = 0.0;
        double trate = r1 = 1.0 + rate;
        int i = 0;
        while (i < arptr.length) {
            if (arptr[i] < 0.0) {
                npv += arptr[i] / trate;
            }
            trate *= r1;
            ++i;
        }
        return npv;
    }

    private static double pos_npv(double rate, double[] arptr) {
        double r1;
        double npv = 0.0;
        double trate = r1 = 1.0 + rate;
        int i = 0;
        while (i < arptr.length) {
            if (arptr[i] >= 0.0) {
                npv += arptr[i] / trate;
            }
            trate *= r1;
            ++i;
        }
        return npv;
    }

    public static double mirr(double[] arptr, double frate, double rrate) throws IllegalArgumentException {
        if (arptr == null) {
            throw new IllegalArgumentException("ARRAYREFERR");
        }
        int negCount = 0;
        int posCount = 0;
        int i = 0;
        while (i < arptr.length) {
            if (arptr[i] >= 0.0) {
                ++posCount;
            } else {
                ++negCount;
            }
            ++i;
        }
        if (negCount == 0 || posCount == 0) {
            throw new IllegalArgumentException("ARRAYREFERR");
        }
        double posNpv = Finance.pos_npv(rrate, arptr);
        double negNpv = Finance.neg_npv(frate, arptr);
        double tmp = -posNpv * Math.pow(1.0 + rrate, arptr.length) / (negNpv * (1.0 + frate));
        return Math.pow(tmp, 1.0 / (double)(arptr.length - 1)) - 1.0;
    }
}

