/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation.rank;

import org.eclipse.birt.data.engine.aggregation.rank.PercentileAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalQuartile
implements IAggregation {
    public String getName() {
        return "QUARTILE";
    }

    public int getType() {
        return 0;
    }

    public boolean[] getParameterDefn() {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        return blArray;
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends PercentileAccumulator {
        private MyAccumulator() {
        }

        protected double getPctValue(Double d) throws DataException {
            this.validatePctValue(d);
            int quar = d.intValue();
            double result = 0.0;
            if (quar == 0) {
                result = 0.0;
            } else if (quar == 1) {
                result = 0.25;
            } else if (quar == 2) {
                result = 0.5;
            } else if (quar == 3) {
                result = 0.75;
            } else if (quar == 4) {
                result = 1.0;
            }
            return result;
        }

        private void validatePctValue(Double d) throws DataException {
            if (d == null || d.isNaN() || d < 0.0 || d > 4.0) {
                throw new DataException("data.engine.InvalidQuartileArgument");
            }
        }
    }
}

