/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IJoinCondition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;

public class DataSourceAndDataSet {
    private IBaseDataSourceDesign dataSourceDesign;
    private IBaseDataSetDesign dataSetDesign;
    private Collection paramterHints;
    private static final int B_FALSE = 0;
    private static final int B_UNKNOWN = 1;
    private static final int B_TRUE = 2;

    public static DataSourceAndDataSet newInstance(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign dataSetDesign, Collection paramterHints) {
        DataSourceAndDataSet dataSourceAndSet = new DataSourceAndDataSet();
        dataSourceAndSet.dataSourceDesign = dataSourceDesign;
        dataSourceAndSet.dataSetDesign = dataSetDesign;
        dataSourceAndSet.paramterHints = paramterHints;
        return dataSourceAndSet;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.dataSourceDesign != null) {
            hashCode += this.dataSourceDesign.getName().hashCode();
        }
        if (this.dataSetDesign != null) {
            hashCode += this.dataSetDesign.getName().hashCode();
        }
        return hashCode;
    }

    public boolean isDataSourceDataSetEqual(DataSourceAndDataSet obj, boolean considerParam) {
        IBaseDataSourceDesign dataSourceDesign2 = obj.dataSourceDesign;
        IBaseDataSetDesign dataSetDesign2 = obj.dataSetDesign;
        Collection paramterHints2 = obj.paramterHints;
        if (this.dataSourceDesign == dataSourceDesign2) {
            if (this.dataSetDesign == dataSetDesign2) {
                if (!considerParam) {
                    return true;
                }
                if (this.isEqualParamterHints(this.paramterHints, paramterHints2)) {
                    return true;
                }
            } else if (this.dataSetDesign == null || dataSetDesign2 == null) {
                return false;
            }
        } else {
            if (this.dataSourceDesign == null || dataSourceDesign2 == null) {
                return false;
            }
            if (this.dataSetDesign != dataSetDesign2 && (this.dataSetDesign == null || dataSetDesign2 == null)) {
                return false;
            }
        }
        if (!this.isEqualDataSourceDesign(this.dataSourceDesign, dataSourceDesign2)) {
            return false;
        }
        if (!this.isEqualDataSetDesign(this.dataSetDesign, dataSetDesign2)) {
            return false;
        }
        if (!considerParam) {
            return true;
        }
        return this.isEqualParamterHints(this.paramterHints, paramterHints2);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DataSourceAndDataSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.isDataSourceDataSetEqual((DataSourceAndDataSet)obj, true);
    }

    private boolean isEqualObject(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return true;
        }
        if (ob1 == null || ob2 == null) {
            return false;
        }
        return ob1.equals(ob2);
    }

    private boolean isEqualString(String str1, String str2) {
        return this.isEqualObject(str1, str2);
    }

    private boolean isEqualProps(Map map1, Map map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 == null || map2 == null) {
            if (map1 == null) {
                return map2.size() == 0;
            }
            return map1.size() == 0;
        }
        if (map1.keySet().size() != map2.keySet().size()) {
            return false;
        }
        Set set = map1.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object value2;
            Object ob = it.next();
            Object value1 = map1.get(ob);
            if (this.isEqualObject(value1, value2 = map1.get(ob))) continue;
            return false;
        }
        return true;
    }

    private int isEqualBasicCol(Collection col1, Collection col2) {
        if (col1 == col2) {
            return 2;
        }
        if (col1 == null || col2 == null) {
            if (col1 == null) {
                if (col2.size() == 0) {
                    return 2;
                }
                return 0;
            }
            if (col1.size() == 0) {
                return 2;
            }
            return 0;
        }
        if (col1.size() == col2.size()) {
            return 1;
        }
        return 0;
    }

    private boolean isEqualFilters(List filter1, List filter2) {
        return true;
    }

    private boolean isEqualExpression(IBaseExpression be, IBaseExpression be2) {
        if (be == be2) {
            return true;
        }
        if (be == null || be2 == null) {
            return false;
        }
        if (be instanceof IScriptExpression && be2 instanceof IScriptExpression) {
            IScriptExpression se = (IScriptExpression)be;
            IScriptExpression se2 = (IScriptExpression)be2;
            return this.isEqualExpression2(se, se2);
        }
        if (be instanceof IConditionalExpression && be2 instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)be;
            IConditionalExpression ce2 = (IConditionalExpression)be2;
            return ce.getDataType() == ce2.getDataType() && ce.getOperator() == ce2.getOperator() && this.isEqualExpression2(ce.getExpression(), ce2.getExpression()) && this.isEqualExpression(ce.getOperand1(), ce2.getOperand1()) && this.isEqualExpression(ce.getOperand2(), ce2.getOperand2());
        }
        if (be instanceof IExpressionCollection && be2 instanceof IExpressionCollection) {
            return be.getDataType() == be2.getDataType() && this.isEqualExpressionArray(((IExpressionCollection)be).getExpressions(), ((IExpressionCollection)be2).getExpressions());
        }
        return false;
    }

    private boolean isEqualExpression2(IScriptExpression se, IBaseExpression se2) {
        if (se == se2) {
            return true;
        }
        if (se == null || se2 == null) {
            return false;
        }
        return se.getDataType() == se2.getDataType() && this.isEqualString(se.getText(), ((IScriptExpression)se2).getText());
    }

    private boolean isEqualExpressionArray(Collection op1, Collection op2) {
        Object[] operands2;
        if (op1 == op2) {
            return true;
        }
        Object[] operands1 = op1.toArray();
        if (operands1.length != (operands2 = op2.toArray()).length) {
            return false;
        }
        int i = 0;
        while (i < operands1.length) {
            if (!this.isEqualExpression((IBaseExpression)operands1[i], (IBaseExpression)operands2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEqualDataSourceDesign(IBaseDataSourceDesign dataSourceDesign, IBaseDataSourceDesign dataSourceDesign2) {
        if (dataSourceDesign == dataSourceDesign2) {
            return true;
        }
        if (dataSourceDesign == null || dataSourceDesign2 == null) {
            return false;
        }
        if (!this.isEqualString(dataSourceDesign.getName(), dataSourceDesign2.getName())) {
            return false;
        }
        if (!(this.isEqualString(dataSourceDesign.getBeforeOpenScript(), dataSourceDesign2.getBeforeOpenScript()) && this.isEqualString(dataSourceDesign.getAfterOpenScript(), dataSourceDesign2.getAfterOpenScript()) && this.isEqualString(dataSourceDesign.getBeforeCloseScript(), dataSourceDesign2.getBeforeCloseScript()) && this.isEqualString(dataSourceDesign.getAfterCloseScript(), dataSourceDesign2.getAfterCloseScript()))) {
            return false;
        }
        if (dataSourceDesign instanceof IOdaDataSourceDesign && dataSourceDesign2 instanceof IOdaDataSourceDesign) {
            IOdaDataSourceDesign dataSource = (IOdaDataSourceDesign)dataSourceDesign;
            IOdaDataSourceDesign dataSource2 = (IOdaDataSourceDesign)dataSourceDesign2;
            if (!this.isEqualString(dataSource.getExtensionID(), dataSource2.getExtensionID())) {
                return false;
            }
            if (!this.isEqualProps(dataSource.getPublicProperties(), dataSource2.getPublicProperties()) || !this.isEqualProps(dataSource.getPrivateProperties(), dataSource2.getPrivateProperties())) {
                return false;
            }
        } else if (dataSourceDesign instanceof IScriptDataSourceDesign && dataSourceDesign2 instanceof IScriptDataSourceDesign) {
            IScriptDataSourceDesign dataSource = (IScriptDataSourceDesign)dataSourceDesign;
            IScriptDataSourceDesign dataSource2 = (IScriptDataSourceDesign)dataSourceDesign2;
            if (!this.isEqualString(dataSource.getOpenScript(), dataSource2.getOpenScript()) || !this.isEqualString(dataSource.getCloseScript(), dataSource2.getCloseScript())) {
                return false;
            }
        }
        return true;
    }

    private boolean isEqualDataSetDesign(IBaseDataSetDesign dataSetDesign, IBaseDataSetDesign dataSetDesign2) {
        if (dataSetDesign == dataSetDesign2) {
            return true;
        }
        if (dataSetDesign == null || dataSetDesign2 == null) {
            return false;
        }
        if (!this.isEqualString(dataSetDesign.getName(), dataSetDesign2.getName())) {
            return false;
        }
        if (dataSetDesign.getRowFetchLimit() != dataSetDesign2.getRowFetchLimit()) {
            return false;
        }
        if (!(this.isEqualString(dataSetDesign.getBeforeOpenScript(), dataSetDesign2.getBeforeOpenScript()) && this.isEqualString(dataSetDesign.getAfterOpenScript(), dataSetDesign2.getAfterOpenScript()) && this.isEqualString(dataSetDesign.getBeforeCloseScript(), dataSetDesign2.getBeforeCloseScript()) && this.isEqualString(dataSetDesign.getAfterCloseScript(), dataSetDesign2.getAfterCloseScript()))) {
            return false;
        }
        if (!(this.isEqualComputedColumns(dataSetDesign.getComputedColumns(), dataSetDesign2.getComputedColumns()) && this.isEqualFilters(dataSetDesign.getFilters(), dataSetDesign2.getFilters()) && this.isEqualParameters(dataSetDesign.getParameters(), dataSetDesign2.getParameters()) && this.isEqualResultHints(dataSetDesign.getResultSetHints(), dataSetDesign2.getResultSetHints()))) {
            return false;
        }
        if (dataSetDesign.getCacheRowCount() != dataSetDesign2.getCacheRowCount()) {
            return false;
        }
        if (dataSetDesign instanceof IOdaDataSetDesign && dataSetDesign2 instanceof IOdaDataSetDesign) {
            IOdaDataSetDesign dataSet = (IOdaDataSetDesign)dataSetDesign;
            IOdaDataSetDesign dataSet2 = (IOdaDataSetDesign)dataSetDesign2;
            if (!(this.isEqualString(dataSet.getQueryText(), dataSet2.getQueryText()) && this.isEqualString(dataSet.getExtensionID(), dataSet2.getExtensionID()) && this.isEqualString(dataSet.getPrimaryResultSetName(), dataSet2.getPrimaryResultSetName()) && this.isEqualProps(dataSet.getPublicProperties(), dataSet2.getPublicProperties()) && this.isEqualProps(dataSet.getPrivateProperties(), dataSet2.getPrivateProperties()))) {
                return false;
            }
        } else if (dataSetDesign instanceof IScriptDataSetDesign && dataSetDesign2 instanceof IScriptDataSetDesign) {
            IScriptDataSetDesign dataSet = (IScriptDataSetDesign)dataSetDesign;
            IScriptDataSetDesign dataSet2 = (IScriptDataSetDesign)dataSetDesign2;
            if (!(this.isEqualString(dataSet.getOpenScript(), dataSet2.getOpenScript()) && this.isEqualString(dataSet.getFetchScript(), dataSet2.getFetchScript()) && this.isEqualString(dataSet.getCloseScript(), dataSet2.getCloseScript()) && this.isEqualString(dataSet.getDescribeScript(), dataSet2.getDescribeScript()))) {
                return false;
            }
        } else if (dataSetDesign instanceof IJointDataSetDesign && dataSetDesign2 instanceof IJointDataSetDesign) {
            IJointDataSetDesign design1 = (IJointDataSetDesign)dataSetDesign;
            IJointDataSetDesign design2 = (IJointDataSetDesign)dataSetDesign2;
            if (!(this.isEqualString(design1.getLeftDataSetDesignName(), design2.getLeftDataSetDesignName()) && this.isEqualString(design1.getRightDataSetDesignName(), design2.getRightDataSetDesignName()) && design1.getJoinType() == design2.getJoinType() && this.isEqualJointCondition(design1.getJoinConditions(), design2.getJoinConditions()))) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isEqualComputedColumns(List computedCol1, List computedCol2) {
        List newComputedCol2;
        if (computedCol1 == computedCol2) {
            return true;
        }
        List newComputedCol1 = this.getRealComputedColumn(computedCol1);
        int basicCol = this.isEqualBasicCol(newComputedCol1, newComputedCol2 = this.getRealComputedColumn(computedCol2));
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = newComputedCol1.iterator();
        Iterator it2 = newComputedCol2.iterator();
        while (it.hasNext()) {
            IComputedColumn cc2;
            IComputedColumn cc = (IComputedColumn)it.next();
            if (this.isEqualComputedCol(cc, cc2 = (IComputedColumn)it2.next())) continue;
            return false;
        }
        return true;
    }

    private List getRealComputedColumn(List computedCols) {
        if (computedCols == null) {
            return null;
        }
        ArrayList<IComputedColumn> list = new ArrayList<IComputedColumn>();
        int i = 0;
        while (i < computedCols.size()) {
            IComputedColumn cc = (IComputedColumn)computedCols.get(i);
            if (!(cc.getName().matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || cc.getName().matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || cc.getName().matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E"))) {
                list.add(cc);
            }
            ++i;
        }
        return list;
    }

    private boolean isEqualComputedCol(IComputedColumn cc, IComputedColumn cc2) {
        return cc.getDataType() == cc2.getDataType() && this.isEqualString(cc.getName(), cc2.getName()) && this.isEqualExpression(cc.getExpression(), cc2.getExpression());
    }

    private boolean isEqualParameters(List params1, List params2) {
        if (params1 == params2) {
            return true;
        }
        int basicCol = this.isEqualBasicCol(params1, params2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = params1.iterator();
        Iterator it2 = params2.iterator();
        while (it.hasNext()) {
            IParameterDefinition pd2;
            IParameterDefinition pd = (IParameterDefinition)it.next();
            if (this.isEqualParameter(pd, pd2 = (IParameterDefinition)it2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualParameter(IParameterDefinition pd, IParameterDefinition pd2) {
        return pd.getPosition() == pd2.getPosition() && pd.getType() == pd2.getType() && pd.getNativeType() == pd2.getNativeType() && pd.isInputMode() == pd2.isInputMode() && pd.isInputOptional() == pd2.isInputOptional() && pd.isNullable() == pd2.isNullable() && pd.isOutputMode() == pd2.isOutputMode() && this.isEqualString(pd.getDefaultInputValue(), pd2.getDefaultInputValue());
    }

    private boolean isEqualParamterHints(Collection paramsBinding1, Collection paramsBinding2) {
        if (paramsBinding1 == paramsBinding2) {
            return true;
        }
        int basicCol = this.isEqualBasicCol(paramsBinding1, paramsBinding2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = paramsBinding1.iterator();
        Iterator it2 = paramsBinding2.iterator();
        while (it.hasNext()) {
            ParameterHint pb2;
            ParameterHint pb = (ParameterHint)it.next();
            if (this.isEqualParameterHint(pb, pb2 = (ParameterHint)it2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualParameterHint(ParameterHint pb, ParameterHint pb2) {
        return pb.getPosition() == pb2.getPosition() && this.isEqualString(pb.getName(), pb2.getName()) && this.isEqualString(pb.getDefaultInputValue(), pb2.getDefaultInputValue()) && this.isEqualString(pb.getDataType().toString(), pb2.getDataType().toString()) && pb.getNativeDataType() == pb2.getNativeDataType();
    }

    private boolean isEqualResultHints(List resultHints1, List resultHints2) {
        if (resultHints1 == resultHints2) {
            return true;
        }
        int basicCol = this.isEqualBasicCol(resultHints1, resultHints2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = resultHints1.iterator();
        Iterator it2 = resultHints2.iterator();
        while (it.hasNext()) {
            IColumnDefinition cd2;
            IColumnDefinition cd = (IColumnDefinition)it.next();
            if (this.isEqualColumnDefn(cd, cd2 = (IColumnDefinition)it2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualColumnDefn(IColumnDefinition cd, IColumnDefinition cd2) {
        if (cd == cd2) {
            return true;
        }
        if (cd == null || cd2 == null) {
            return false;
        }
        return cd.getColumnPosition() == cd2.getColumnPosition() && cd.getDataType() == cd2.getDataType() && cd.getNativeDataType() == cd2.getNativeDataType() && cd.getExportHint() == cd2.getExportHint() && cd.getSearchHint() == cd2.getSearchHint() && this.isEqualString(cd.getAlias(), cd2.getAlias()) && this.isEqualString(cd.getColumnName(), cd2.getColumnName());
    }

    private boolean isEqualJointCondition(List joinConditions1, List joinConditions2) {
        if (joinConditions1 == joinConditions2) {
            return true;
        }
        int basicCol = this.isEqualBasicCol(joinConditions1, joinConditions2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = joinConditions1.iterator();
        Iterator it2 = joinConditions2.iterator();
        while (it.hasNext() || it2.hasNext()) {
            IJoinCondition cc2;
            IJoinCondition cc = (IJoinCondition)it.next();
            if (this.isEqualJointConditionItem(cc, cc2 = (IJoinCondition)it2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualJointConditionItem(IJoinCondition cc1, IJoinCondition cc2) {
        if (cc1 == cc2) {
            return true;
        }
        if (cc1 == null || cc2 == null) {
            return false;
        }
        return this.isEqualExpression2(cc1.getLeftExpression(), cc2.getLeftExpression()) && this.isEqualExpression2(cc1.getRightExpression(), cc2.getRightExpression()) && cc1.getOperator() == cc2.getOperator();
    }
}

