/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odi.IResultClass;

class ResultClassHelper {
    private IResultClass resultClass;
    private boolean hasClobOrBlob = false;
    private int[] clobIndex = null;
    private int[] blobIndex = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.ResultClassHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    ResultClassHelper(IResultClass resultClass) throws DataException {
        this.resultClass = resultClass;
        this.initIndex();
    }

    private void initIndex() throws DataException {
        ArrayList<Integer> clobIndexList = new ArrayList<Integer>();
        ArrayList<Integer> blobIndexList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.resultClass.getFieldCount()) {
            Class valueClass = this.resultClass.getFieldValueClass(i + 1);
            if (!$assertionsDisabled && valueClass == null) {
                throw new AssertionError();
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (valueClass.isAssignableFrom(clazz)) {
                clobIndexList.add(new Integer(i));
            } else {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (valueClass.isAssignableFrom(clazz2)) {
                    blobIndexList.add(new Integer(i));
                }
            }
            ++i;
        }
        this.clobIndex = this.toIntArray(clobIndexList);
        this.blobIndex = this.toIntArray(blobIndexList);
        this.hasClobOrBlob = this.clobIndex.length > 0 || this.blobIndex.length > 0;
    }

    private int[] toIntArray(List integerList) {
        int[] reArray = new int[integerList.size()];
        int i = 0;
        while (i < reArray.length) {
            reArray[i] = (Integer)integerList.get(i);
            ++i;
        }
        return reArray;
    }

    boolean hasClobOrBlob() {
        return this.hasClobOrBlob;
    }

    int[] getClobIndexArray() {
        return this.clobIndex;
    }

    int[] getBlobIndexArray() {
        return this.blobIndex;
    }
}

