/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DiskDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IncreDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.MemoryDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.dscache.ILoadUtil;
import org.eclipse.birt.data.engine.executor.dscache.ISaveUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class CacheUtilFactory {
    static /* synthetic */ Class class$0;

    CacheUtilFactory() {
    }

    public static ISaveUtil createSaveUtil(IDataSetCacheObject cacheObject, IResultClass rs) {
        if (cacheObject instanceof DiskDataSetCacheObject) {
            return new DiskSaveUtil((DiskDataSetCacheObject)cacheObject, rs);
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return new MemorySaveUtil((MemoryDataSetCacheObject)cacheObject, rs);
        }
        if (cacheObject instanceof IncreDataSetCacheObject) {
            return new IncreCacheSaveUtil((IncreDataSetCacheObject)cacheObject, rs);
        }
        return null;
    }

    public static ILoadUtil createLoadUtil(IDataSetCacheObject cacheObject, DataEngineSession session) throws DataException {
        if (cacheObject instanceof DiskDataSetCacheObject) {
            return new DiskLoadUtil((DiskDataSetCacheObject)cacheObject, session);
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return new MemoryLoadUtil((MemoryDataSetCacheObject)cacheObject);
        }
        if (cacheObject instanceof IncreDataSetCacheObject) {
            return new IncreCacheLoadUtil((IncreDataSetCacheObject)cacheObject);
        }
        return null;
    }

    private static class DiskLoadUtil
    implements ILoadUtil {
        private static final String END = "$end$";
        private static final String BEGIN = "$begin$";
        private File file;
        private File metaFile;
        private FileInputStream fis;
        private BufferedInputStream bis;
        private ResultObjectUtil roUtil;
        private IResultClass rsClass;
        private DiskDataSetCacheObject cacheObject;
        private int rowCount;
        private int currIndex;
        private DataEngineSession session;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public DiskLoadUtil(DiskDataSetCacheObject cacheObject, DataEngineSession session) throws DataException {
            if (!$assertionsDisabled && cacheObject == null) {
                throw new AssertionError();
            }
            this.cacheObject = cacheObject;
            this.file = cacheObject.getDataFile();
            this.metaFile = cacheObject.getMetaFile();
            this.session = session;
            this.rowCount = 0;
            this.currIndex = -1;
            if (this.session.getDataSetCacheManager().getCacheOption() == 3) {
                this.mergeDelta();
            }
        }

        public IResultObject loadObject() throws DataException {
            block4: {
                if (this.roUtil == null) {
                    this.init();
                }
                try {
                    if (this.currIndex != this.rowCount - 1) break block4;
                    return null;
                }
                catch (IOException e) {
                    throw new DataException("data.engine.datasetcache.load.error", e);
                }
            }
            ++this.currIndex;
            return this.roUtil.readData(this.bis, 1)[0];
        }

        public IResultClass loadResultClass() throws DataException {
            if (this.roUtil == null) {
                this.init();
            }
            return this.rsClass;
        }

        private void init() throws DataException {
            try {
                FileInputStream fis1 = new FileInputStream(this.metaFile);
                BufferedInputStream bis1 = new BufferedInputStream(fis1);
                this.rowCount = IOUtil.readInt((InputStream)bis1);
                this.rsClass = new ResultClass(bis1);
                bis1.close();
                fis1.close();
                if (this.rowCount > 0) {
                    this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                    this.fis = new FileInputStream(this.file);
                    this.bis = new BufferedInputStream(this.fis);
                }
            }
            catch (FileNotFoundException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }

        public void close() throws DataException {
            if (this.bis != null) {
                try {
                    this.bis.close();
                    this.fis.close();
                }
                catch (IOException iOException) {}
            }
        }

        private void mergeDelta() throws DataException {
            try {
                File dataFile;
                String configFile = this.getCacheConfig(this.session.getDataSetCacheManager().getCurrentAppContext());
                if (configFile != null && !configFile.equals("") && (dataFile = this.file).exists()) {
                    File config = new File(configFile);
                    FileReader fileReader = null;
                    if (config.exists()) {
                        fileReader = new FileReader(config);
                    }
                    BufferedReader reader = new BufferedReader(fileReader);
                    ArrayList list = this.readConfigFile(configFile, reader);
                    File metaFile = this.metaFile;
                    this.mergeDeltaToFile(dataFile, list, metaFile);
                    CacheUtil.saveCurrentTime(this.cacheObject.getTempDir());
                }
            }
            catch (Exception e) {
                throw new DataException(e.getLocalizedMessage());
            }
        }

        private String getCacheConfig(Map context) {
            if (context == null) {
                return null;
            }
            return context.get(DataEngine.DATA_SET_CACHE_DELTA_FILE) == null ? null : String.valueOf(context.get(DataEngine.DATA_SET_CACHE_DELTA_FILE));
        }

        private void mergeDeltaToFile(File dataFile, ArrayList list, File metaFile) throws DataException, IOException, BirtException, ClassNotFoundException {
            MergeUtil merge = new MergeUtil(dataFile, metaFile);
            IResultIterator iterator = this.getResultIterator(list);
            if (iterator != null) {
                while (iterator.next()) {
                    ResultObject ro = (ResultObject)((ResultIterator)iterator).getOdiResult().getCurrentResult();
                    merge.saveObject(ro);
                }
            }
            merge.close();
        }

        private ArrayList readConfigFile(String file, BufferedReader reader) throws IOException {
            String line;
            ArrayList<ArrayList> list = new ArrayList<ArrayList>();
            StringBuffer block = new StringBuffer("");
            boolean begin = false;
            while ((line = reader.readLine()) != null) {
                line.trim();
                if (line.startsWith(BEGIN) && !begin) {
                    begin = true;
                    line = line.substring(7);
                }
                if (line.endsWith(END) && begin) {
                    line = line.substring(0, line.length() - 5);
                    block.append(line);
                    list.add(this.parseQueryItem(block.toString()));
                    block = new StringBuffer("");
                    begin = false;
                    continue;
                }
                if (!begin) continue;
                block.append(line);
            }
            return list;
        }

        private ArrayList parseQueryItem(String item) {
            ArrayList<Object> info = new ArrayList<Object>();
            String[] split = item.split(";");
            int i = 0;
            while (i < 3) {
                String[] temp = split[i].split("\"");
                info.add(temp[1]);
                ++i;
            }
            Hashtable<String, String> table = new Hashtable<String, String>();
            int j = 3;
            while (j < split.length) {
                String paraName = split[j].split("=")[0];
                String paraValue = split[j].split("\"")[1];
                table.put(paraName, paraValue);
                ++j;
            }
            info.add(table);
            return info;
        }

        private IResultIterator getResultIterator(ArrayList list) throws IOException, BirtException, ClassNotFoundException {
            String sql = null;
            int i = 0;
            while (i < list.size()) {
                if ((sql = this.getQualifiedSql(list, i, sql)) != null) break;
                ++i;
            }
            if (sql == null) {
                return null;
            }
            if (!(this.session.getDataSetCacheManager().getCurrentDataSetDesign() instanceof OdaDataSetDesign)) {
                return null;
            }
            if ((sql = this.resetQueryText(sql)) == null || "".equals(sql)) {
                return null;
            }
            QueryDefinition qd = new QueryDefinition();
            qd.setDataSetName(this.session.getDataSetCacheManager().getCurrentDataSetDesign().getName());
            String queryBack = ((OdaDataSetDesign)this.session.getDataSetCacheManager().getCurrentDataSetDesign()).getQueryText();
            int savedCacheOption = this.session.getDataSetCacheManager().suspendCache();
            qd.setAutoBinding(true);
            IResultIterator iterator = this.session.getEngine().prepare(qd, new HashMap()).execute(null).getResultIterator();
            ((OdaDataSetDesign)this.session.getDataSetCacheManager().getCurrentDataSetDesign()).setQueryText(queryBack);
            this.session.getDataSetCacheManager().setCacheOption(savedCacheOption);
            return iterator;
        }

        private String getQualifiedSql(ArrayList list, int index, String sql) {
            ArrayList item = (ArrayList)list.get(index);
            if (item == null || item.size() == 0) {
                sql = null;
            }
            int count = 0;
            if (((String)item.get(0)).equalsIgnoreCase(this.session.getDataSetCacheManager().getCurrentDataSourceDesign().getName()) && ((String)item.get(1)).equalsIgnoreCase(this.session.getDataSetCacheManager().getCurrentDataSetDesign().getName())) {
                Object[] para = this.session.getDataSetCacheManager().getCurrentParameterHints().toArray();
                Hashtable table = (Hashtable)item.get(3);
                int i = 0;
                while (i < para.length) {
                    ParameterHint ph = (ParameterHint)para[i];
                    if (ph.isInputMode()) {
                        String paraName = ph.getName();
                        if (table.containsKey(paraName) && ((String)table.get(paraName)).equalsIgnoreCase(ph.getDefaultInputValue())) {
                            ++count;
                        } else {
                            count = -1;
                            sql = null;
                        }
                    }
                    ++i;
                }
                sql = count == table.size() ? (String)item.get(2) : null;
            }
            return sql;
        }

        private String resetQueryText(String text) throws IOException, DataException, ClassNotFoundException {
            String timestamp = CacheUtil.getLastTime(this.cacheObject.getTempDir());
            if (timestamp == null || timestamp.length() != 14) {
                return null;
            }
            return text.replaceAll("\\Q${DATE}$\\E", timestamp);
        }
    }

    private static class DiskSaveUtil
    implements ISaveUtil {
        private File file;
        private File metaFile;
        private FileOutputStream fos;
        private BufferedOutputStream bos;
        private IResultClass rsClass;
        private ResultObjectUtil roUtil;
        private int rowCount;
        private String tempFolder;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public DiskSaveUtil(DiskDataSetCacheObject cacheObject, IResultClass rsClass) {
            if (!$assertionsDisabled && rsClass == null) {
                throw new AssertionError();
            }
            this.file = cacheObject.getDataFile();
            this.file.deleteOnExit();
            this.metaFile = cacheObject.getMetaFile();
            this.metaFile.deleteOnExit();
            this.rsClass = rsClass;
            this.rowCount = 0;
            this.tempFolder = cacheObject.getTempDir();
        }

        public void saveObject(IResultObject resultObject) throws DataException {
            if (!$assertionsDisabled && resultObject == null) {
                throw new AssertionError();
            }
            if (this.roUtil == null) {
                this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                try {
                    this.fos = new FileOutputStream(this.file);
                    this.bos = new BufferedOutputStream(this.fos);
                }
                catch (FileNotFoundException e) {
                    throw new DataException("data.engine.datasetcache.save.error", e);
                }
            }
            try {
                ++this.rowCount;
                this.roUtil.writeData(this.bos, resultObject);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        public void close() throws DataException {
            try {
                if (this.bos != null) {
                    this.bos.close();
                    this.fos.close();
                }
                FileOutputStream fos1 = new FileOutputStream(this.metaFile);
                BufferedOutputStream bos1 = new BufferedOutputStream(fos1);
                IOUtil.writeInt((OutputStream)bos1, (int)this.rowCount);
                HashMap metaMap = new HashMap();
                this.populateDataSetRowMapping(metaMap);
                ((ResultClass)this.rsClass).doSave(bos1, metaMap);
                bos1.close();
                fos1.close();
                CacheUtil.saveCurrentTime(this.tempFolder);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        private void populateDataSetRowMapping(Map metaMap) throws DataException {
            int i = 0;
            while (i < this.rsClass.getFieldCount()) {
                Binding binding = new Binding(this.rsClass.getFieldName(i + 1));
                binding.setExpression(new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.rsClass.getFieldName(i + 1))));
                metaMap.put(this.rsClass.getFieldName(i + 1), binding);
                ++i;
            }
        }
    }

    private static class IncreCacheLoadUtil
    implements ILoadUtil {
        private File file;
        private File metaFile;
        private FileInputStream fis;
        private BufferedInputStream bis;
        private ResultObjectUtil roUtil;
        private IResultClass rsClass;
        private int rowCount;
        private int currIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public IncreCacheLoadUtil(IncreDataSetCacheObject cacheObject) {
            if (!$assertionsDisabled && cacheObject == null) {
                throw new AssertionError();
            }
            this.file = cacheObject.getDataFile();
            this.metaFile = cacheObject.getMetaFile();
            this.rowCount = 0;
            this.currIndex = -1;
        }

        public IResultObject loadObject() throws DataException {
            block4: {
                if (this.roUtil == null) {
                    this.init();
                }
                try {
                    if (this.currIndex != this.rowCount - 1) break block4;
                    return null;
                }
                catch (IOException e) {
                    throw new DataException("data.engine.datasetcache.load.error", e);
                }
            }
            ++this.currIndex;
            return this.roUtil.readData(this.bis, 1)[0];
        }

        public IResultClass loadResultClass() throws DataException {
            if (this.roUtil == null) {
                this.init();
            }
            return this.rsClass;
        }

        private void init() throws DataException {
            try {
                FileInputStream fis1 = new FileInputStream(this.metaFile);
                BufferedInputStream bis1 = new BufferedInputStream(fis1);
                this.rowCount = IOUtil.readInt((InputStream)bis1);
                this.rsClass = new ResultClass(bis1);
                bis1.close();
                fis1.close();
                if (this.rowCount > 0) {
                    this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                    this.fis = new FileInputStream(this.file);
                    this.bis = new BufferedInputStream(this.fis);
                }
            }
            catch (FileNotFoundException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }

        public void close() throws DataException {
            if (this.bis != null) {
                try {
                    this.bis.close();
                    this.fis.close();
                }
                catch (IOException e) {
                    throw new DataException("", e);
                }
            }
        }
    }

    private static class IncreCacheSaveUtil
    implements ISaveUtil {
        private File file;
        private File metaFile;
        private BufferedOutputStream bos;
        private IResultClass rsMeta;
        private ResultObjectUtil roUtil;
        private int rowCount;
        private String tempDir;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public IncreCacheSaveUtil(IncreDataSetCacheObject cacheObject, IResultClass rs) {
            this.file = cacheObject.getDataFile();
            this.metaFile = cacheObject.getMetaFile();
            this.rsMeta = rs;
            this.rowCount = 0;
            this.tempDir = cacheObject.getCacheDir();
        }

        public void saveObject(IResultObject resultObject) throws DataException {
            if (!$assertionsDisabled && resultObject == null) {
                throw new AssertionError();
            }
            if (this.roUtil == null) {
                this.roUtil = ResultObjectUtil.newInstance(this.rsMeta);
                try {
                    this.bos = new BufferedOutputStream(new FileOutputStream(this.file, true));
                }
                catch (Exception e) {
                    throw new DataException("data.engine.datasetcache.save.error", e);
                }
            }
            try {
                ++this.rowCount;
                this.roUtil.writeData(this.bos, resultObject);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        public void close() throws DataException {
            try {
                if (this.bos != null) {
                    this.bos.close();
                }
                if (this.metaFile.exists()) {
                    FileInputStream fis1 = new FileInputStream(this.metaFile);
                    BufferedInputStream bis1 = new BufferedInputStream(fis1);
                    int oldCount = IOUtil.readInt((InputStream)bis1);
                    this.rowCount += oldCount;
                    bis1.close();
                    fis1.close();
                }
                FileOutputStream fos1 = new FileOutputStream(this.metaFile);
                BufferedOutputStream bos1 = new BufferedOutputStream(fos1);
                IOUtil.writeInt((OutputStream)bos1, (int)this.rowCount);
                HashMap metaMap = new HashMap();
                this.populateDataSetRowMapping(metaMap);
                ((ResultClass)this.rsMeta).doSave(bos1, metaMap);
                bos1.close();
                fos1.close();
                CacheUtil.saveCurrentTimestamp(this.tempDir);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        private void populateDataSetRowMapping(Map metaMap) throws DataException {
            int i = 0;
            while (i < this.rsMeta.getFieldCount()) {
                Binding binding = new Binding(this.rsMeta.getFieldName(i + 1));
                binding.setExpression(new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.rsMeta.getFieldName(i + 1))));
                metaMap.put(this.rsMeta.getFieldName(i + 1), binding);
                ++i;
            }
        }
    }

    private static class MemoryLoadUtil
    implements ILoadUtil {
        private int currIndex;
        private MemoryDataSetCacheObject cacheObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public MemoryLoadUtil(MemoryDataSetCacheObject cacheObject) {
            if (!$assertionsDisabled && cacheObject == null) {
                throw new AssertionError();
            }
            this.cacheObject = cacheObject;
            this.currIndex = -1;
        }

        public IResultObject loadObject() throws DataException {
            ++this.currIndex;
            if (this.currIndex >= this.cacheObject.getSize()) {
                return null;
            }
            return this.cacheObject.getResultObject(this.currIndex);
        }

        public IResultClass loadResultClass() throws DataException {
            return this.cacheObject.getResultClass();
        }

        public void close() throws DataException {
        }
    }

    private static class MemorySaveUtil
    implements ISaveUtil {
        private MemoryDataSetCacheObject cacheObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public MemorySaveUtil(MemoryDataSetCacheObject cacheObject, IResultClass rs) {
            if (!$assertionsDisabled && cacheObject == null) {
                throw new AssertionError();
            }
            this.cacheObject = cacheObject;
            this.cacheObject.setResultClass(rs);
        }

        public void saveObject(IResultObject resultObject) throws DataException {
            if (!$assertionsDisabled && resultObject == null) {
                throw new AssertionError();
            }
            this.cacheObject.populateResult(resultObject);
        }

        public void close() throws DataException {
        }
    }

    private static class MergeUtil {
        private File dataFile;
        private IResultClass rsClass;
        private File metaFile;
        private FileOutputStream fos;
        private BufferedOutputStream bos;
        private ResultObjectUtil roUtil;
        private int rowCount;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private MergeUtil(File dataFile, File metaFile) throws DataException {
            if (!$assertionsDisabled && dataFile == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && metaFile == null) {
                throw new AssertionError();
            }
            this.dataFile = dataFile;
            this.metaFile = metaFile;
            this.init();
        }

        private void init() throws DataException {
            try {
                FileInputStream fis = new FileInputStream(this.metaFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                this.rowCount = IOUtil.readInt((InputStream)bis);
                this.rsClass = new ResultClass(bis);
                bis.close();
                fis.close();
            }
            catch (FileNotFoundException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }

        private void saveObject(IResultObject resultObject) throws DataException {
            if (!$assertionsDisabled && resultObject == null) {
                throw new AssertionError();
            }
            if (this.roUtil == null) {
                this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                try {
                    this.fos = new FileOutputStream(this.dataFile, true);
                    this.bos = new BufferedOutputStream(this.fos);
                }
                catch (FileNotFoundException e) {
                    throw new DataException("data.engine.datasetcache.save.error", e);
                }
            }
            try {
                ++this.rowCount;
                this.roUtil.writeData(this.bos, resultObject);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        private void close() throws DataException {
            try {
                if (this.bos != null) {
                    this.bos.close();
                    this.fos.close();
                }
                FileOutputStream fos1 = new FileOutputStream(this.metaFile);
                BufferedOutputStream bos1 = new BufferedOutputStream(fos1);
                IOUtil.writeInt((OutputStream)bos1, (int)this.rowCount);
                HashMap metaMap = new HashMap();
                this.populateDataSetRowMapping(metaMap);
                ((ResultClass)this.rsClass).doSave(bos1, metaMap);
                bos1.close();
                fos1.close();
                FileInputStream fis = new FileInputStream(this.metaFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                this.rowCount = IOUtil.readInt((InputStream)bis);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        private void populateDataSetRowMapping(Map metaMap) throws DataException {
            int i = 0;
            while (i < this.rsClass.getFieldCount()) {
                metaMap.put(this.rsClass.getFieldName(i + 1), new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.rsClass.getFieldName(i + 1))));
                ++i;
            }
        }
    }
}

