/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;

class PassUtil {
    private static final String RESULT_SET_COMPUTED_COLUMN_NAME_PATTERN = "\\Q_{$TEMP\\E.*\\d*\\Q$}_\\E";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.executor.transform.pass.PassUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private PassUtil() {
    }

    public static void pass(ResultSetPopulator populator, OdiResultSetWrapper resultSource, boolean doGroup, DataEngineSession session) throws DataException {
        PassUtil.populateOdiResultSet(populator, resultSource, doGroup ? populator.getGroupProcessorManager().getGroupCalculationUtil().getSortSpec() : null, session);
        if (doGroup) {
            populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().doGrouping();
        }
        populator.getCache().next();
        populator.getExpressionProcessor().setResultIterator(populator.getResultIterator());
    }

    private static void populateOdiResultSet(ResultSetPopulator populator, OdiResultSetWrapper rsWrapper, SortSpec sortSpec, DataEngineSession session) throws DataException {
        Object resultSource = rsWrapper.getWrappedOdiResultSet();
        if (!$assertionsDisabled && resultSource == null) {
            throw new AssertionError();
        }
        SmartCache smartCache = null;
        BaseQuery query = populator.getQuery();
        IResultClass rsMeta = populator.getResultSetMetadata();
        if (resultSource instanceof ResultSet) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, populator.getEventHandler(), query.getDistinctValueFlag()), (ResultSet)resultSource, rsMeta, session);
        } else if (resultSource instanceof ICustomDataSet) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, populator.getEventHandler(), query.getDistinctValueFlag()), new OdiAdapter((ICustomDataSet)resultSource), rsMeta, session);
        } else if (resultSource instanceof IDataSetPopulator) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, populator.getEventHandler(), query.getDistinctValueFlag()), new OdiAdapter((IDataSetPopulator)resultSource), rsMeta, session);
        } else if (resultSource instanceof DataSetResultCache) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, populator.getEventHandler(), false), new OdiAdapter((DataSetResultCache)resultSource), rsMeta, session);
        } else if (resultSource instanceof IResultIterator) {
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, populator.getEventHandler(), false), new OdiAdapter((IResultIterator)resultSource), rsMeta, session);
        } else if (resultSource instanceof Object[]) {
            Object[] obs = (Object[])resultSource;
            smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), sortSpec, populator.getEventHandler(), false), (ResultSetCache)obs[0], ((int[])obs[1])[0], ((int[])obs[1])[1], rsMeta, session);
        }
        populator.getGroupProcessorManager().getGroupCalculationUtil().setResultSetCache(smartCache);
        populator.setCache(smartCache);
    }

    public static boolean isTemporaryResultSetComputedColumn(String name) {
        return name.matches(RESULT_SET_COMPUTED_COLUMN_NAME_PATTERN);
    }
}

