/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

class BindingColumnsEvalUtil {
    private IResultIterator odiResult;
    private Scriptable scope;
    private ResultIterator.RDSaveHelper saveHelper;
    private List allManualBindingExprs;
    private List allAutoBindingExprs;
    private boolean isBasedOnRD;
    private EvalHelper evalHelper;
    private static final int MANUAL_BINDING = 1;
    private static final int AUTO_BINDING = 2;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.BindingColumnsEvalUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    BindingColumnsEvalUtil(IResultIterator ri, Scriptable scope, ResultIterator.RDSaveHelper saveUtil, List manualBindingExprs, Map autoBindingExprs) throws DataException {
        Object[] params = new Object[]{ri, scope, saveUtil, manualBindingExprs, autoBindingExprs};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.BindingColumnsEvalUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "BindingColumnsEvalUtil", params);
        this.odiResult = ri;
        this.scope = scope;
        this.saveHelper = saveUtil;
        try {
            this.isBasedOnRD = ExprMetaUtil.isBasedOnRD(ri.getResultClass());
            if (this.isBasedOnRD) {
                this.evalHelper = new EvalHelper(ri);
            }
        }
        catch (DataException dataException) {}
        this.initBindingColumns(manualBindingExprs, autoBindingExprs);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.BindingColumnsEvalUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "BindingColumnsEvalUtil");
    }

    private void initBindingColumns(List manualBindingExprs, Map autoBindingExprs) throws DataException {
        int size = manualBindingExprs.size();
        GroupBindingColumn[] groupBindingColumns = new GroupBindingColumn[size];
        Iterator<Object> itr = manualBindingExprs.iterator();
        while (itr.hasNext()) {
            GroupBindingColumn temp;
            groupBindingColumns[temp.getGroupLevel()] = temp = (GroupBindingColumn)itr.next();
        }
        this.allManualBindingExprs = new ArrayList();
        int i = 0;
        while (i < size) {
            ArrayList<BindingColumn> groupBindingExprs = new ArrayList<BindingColumn>();
            itr = groupBindingColumns[i].getColumnNames().iterator();
            while (itr.hasNext()) {
                String exprName = (String)itr.next();
                IBaseExpression baseExpr = groupBindingColumns[i].getExpression(exprName);
                groupBindingExprs.add(new BindingColumn(exprName, baseExpr, groupBindingColumns[i].getBinding(exprName).getAggrFunction() != null, groupBindingColumns[i].getBinding(exprName).getDataType()));
            }
            this.allManualBindingExprs.add(groupBindingExprs);
            ++i;
        }
        this.allAutoBindingExprs = new ArrayList();
        itr = autoBindingExprs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String exprName = (String)entry.getKey();
            IBaseExpression baseExpr = (IBaseExpression)entry.getValue();
            this.allAutoBindingExprs.add(new BindingColumn(exprName, baseExpr, false, baseExpr.getDataType()));
        }
    }

    void getColumnsValue(Map valueMap) throws DataException {
        Iterator itr = this.allAutoBindingExprs.iterator();
        while (itr.hasNext()) {
            BindingColumn bindingColumn = (BindingColumn)itr.next();
            if (valueMap.containsKey(bindingColumn.columnName)) continue;
            Object exprValue = this.evaluateValue(bindingColumn, 2);
            if (valueMap.get(bindingColumn.columnName) != null) continue;
            valueMap.put(bindingColumn.columnName, exprValue);
        }
        int i = 0;
        while (i < this.allManualBindingExprs.size()) {
            List list = (List)this.allManualBindingExprs.get(i);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                BindingColumn bindingColumn = (BindingColumn)it.next();
                if (valueMap.containsKey(bindingColumn.columnName)) continue;
                Object exprValue = this.evaluateValue(bindingColumn, 1);
                valueMap.put(bindingColumn.columnName, exprValue);
            }
            ++i;
        }
        this.saveHelper.doSaveExpr(valueMap);
    }

    private Object evaluateValue(BindingColumn bindingColumn, int exprType) throws DataException {
        Object exprValue = null;
        try {
            String columnName;
            boolean getValue = false;
            if (this.isBasedOnRD && this.evalHelper.contains(columnName = bindingColumn.columnName)) {
                getValue = true;
                exprValue = this.evalHelper.getValue(columnName);
            }
            if (!getValue) {
                exprValue = exprType == 1 ? (bindingColumn.isAggregation ? this.odiResult.getAggrValue(bindingColumn.columnName) : ExprEvaluateUtil.evaluateExpression(bindingColumn.baseExpr, this.odiResult, this.scope)) : ExprEvaluateUtil.evaluateRawExpression(bindingColumn.baseExpr, this.scope);
                if (exprValue != null) {
                    exprValue = DataTypeUtil.convert((Object)JavascriptEvalUtil.convertJavascriptValue((Object)exprValue), (int)bindingColumn.type);
                }
            }
        }
        catch (BirtException e) {
            exprValue = e;
        }
        return exprValue;
    }

    Object evaluateValue(String bindingName) throws DataException {
        return this.evaluateValue(this.getBindingFromManualBinding(bindingName), 1);
    }

    private BindingColumn getBindingFromManualBinding(String name) throws DataException {
        int i = 0;
        while (i < this.allManualBindingExprs.size()) {
            List list = (List)this.allManualBindingExprs.get(i);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                BindingColumn bindingColumn = (BindingColumn)it.next();
                if (!bindingColumn.columnName.equals(name)) continue;
                return bindingColumn;
            }
            ++i;
        }
        throw new DataException("data.engine.InvalidBoundColumnName", name);
    }

    private class BindingColumn {
        private String columnName;
        private IBaseExpression baseExpr;
        private boolean isAggregation;
        private int type;

        private BindingColumn(String columnName, IBaseExpression baseExpr, boolean isAggregation, int type) {
            this.columnName = columnName;
            this.baseExpr = baseExpr;
            this.isAggregation = isAggregation;
            this.type = type;
            if (this.baseExpr instanceof ScriptExpression) {
                ((ScriptExpression)this.baseExpr).setDataType(type);
            }
        }
    }

    private class EvalHelper {
        private IResultIterator ri;
        private Set columnNameSet;

        private EvalHelper(IResultIterator ri) {
            this.ri = ri;
            try {
                IResultClass resultClass = ri.getResultClass();
                this.columnNameSet = new HashSet();
                int i = 0;
                while (i < resultClass.getFieldCount()) {
                    this.columnNameSet.add(resultClass.getFieldName(i + 1));
                    ++i;
                }
            }
            catch (DataException dataException) {}
        }

        private boolean contains(String columnName) {
            return this.columnNameSet.contains(columnName);
        }

        private Object getValue(String columnName) throws DataException {
            if (this.ri.getCurrentResult() == null) {
                return null;
            }
            return this.ri.getCurrentResult().getFieldValue(columnName);
        }
    }
}

