/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.ResultSetCacheUtil;
import org.mozilla.javascript.Scriptable;

public class CacheResultIterator
implements IResultIterator {
    private DataEngineContext context = null;
    private InputStream metaInputStream = null;
    private DataInputStream rowInputStream = null;
    private ResultClass resultClass = null;
    private int rowCount;
    private int rowIndex;
    private int startingGroupLevel = -1;
    private int endingGroupLevel = -1;
    private List columnList = null;
    private Map columnValueMap = null;
    private IQueryResults queryResults;
    private int currRowIndex;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.CacheResultIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public CacheResultIterator(DataEngineContext context, IQueryResults queryResults) throws DataException {
        Object[] params = new Object[]{context, queryResults.getID()};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.CacheResultIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "CacheResultIterator", params);
        this.context = context;
        this.columnValueMap = new HashMap();
        this.currRowIndex = -1;
        this.queryResults = queryResults;
        try {
            this.createCacheInputStream();
            this.resultClass = new ResultClass(this.metaInputStream);
            this.rowCount = IOUtil.readInt((InputStream)this.rowInputStream);
            int columnSize = IOUtil.readInt((InputStream)this.rowInputStream);
            this.columnList = new ArrayList();
            int i = 0;
            while (i < columnSize) {
                this.columnList.add(IOUtil.readObject((DataInputStream)this.rowInputStream));
                ++i;
            }
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.CacheResultIterator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.exiting(clazz2.getName(), "CacheResultIterator");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DataException("data.engine.OpenCacheTempError");
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.ReadCacheTempError");
        }
    }

    private void createCacheInputStream() throws FileNotFoundException {
        this.metaInputStream = new BufferedInputStream(new FileInputStream(ResultSetCacheUtil.getMetaFile(this.context.getTmpdir(), this.queryResults.getID())), 1024);
        this.rowInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(ResultSetCacheUtil.getDataFile(this.context.getTmpdir(), this.queryResults.getID())), 1024));
    }

    public void close() throws BirtException {
        this.closeCacheIntputStream();
    }

    private void closeCacheIntputStream() throws DataException {
        try {
            if (this.metaInputStream != null) {
                this.metaInputStream.close();
                this.metaInputStream = null;
            }
            if (this.rowInputStream != null) {
                this.rowInputStream.close();
                this.rowInputStream = null;
            }
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.CloseCacheTempError");
        }
    }

    public boolean findGroup(Object[] groupKeyValues) throws BirtException {
        throw new UnsupportedOperationException();
    }

    public Boolean getBoolean(String name) throws BirtException {
        return DataTypeUtil.toBoolean((Object)this.getValue(name));
    }

    public Integer getInteger(String name) throws BirtException {
        return DataTypeUtil.toInteger((Object)this.getValue(name));
    }

    public Double getDouble(String name) throws BirtException {
        return DataTypeUtil.toDouble((Object)this.getValue(name));
    }

    public String getString(String name) throws BirtException {
        return DataTypeUtil.toString((Object)this.getValue(name));
    }

    public BigDecimal getBigDecimal(String name) throws BirtException {
        return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
    }

    public Date getDate(String name) throws BirtException {
        return DataTypeUtil.toDate((Object)this.getValue(name));
    }

    public Blob getBlob(String name) throws BirtException {
        return DataTypeUtil.toBlob((Object)this.getValue(name));
    }

    public byte[] getBytes(String name) throws BirtException {
        return DataTypeUtil.toBytes((Object)this.getValue(name));
    }

    public int getEndingGroupLevel() throws BirtException {
        return this.endingGroupLevel;
    }

    public IQueryResults getQueryResults() {
        return this.queryResults;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return new ResultMetaData(this.resultClass);
    }

    public int getRowId() throws BirtException {
        return this.rowIndex;
    }

    public int getRowIndex() throws BirtException {
        return this.rowIndex;
    }

    public Scriptable getScope() {
        return null;
    }

    public IResultIterator getSecondaryIterator(String subQueryName, Scriptable scope) throws BirtException {
        throw new UnsupportedOperationException();
    }

    public int getStartingGroupLevel() throws BirtException {
        return this.startingGroupLevel;
    }

    public Object getValue(String name) throws BirtException {
        return this.columnValueMap.get(name);
    }

    public boolean isEmpty() throws BirtException {
        return this.rowCount == 0;
    }

    public void moveTo(int rowIndex) throws BirtException {
        if (rowIndex < 0 || rowIndex >= this.rowCount) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
        }
        if (rowIndex < this.currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (rowIndex == this.currRowIndex) {
            return;
        }
        int gapRows = rowIndex - this.currRowIndex;
        int i = 0;
        while (i < gapRows) {
            this.next();
            ++i;
        }
    }

    public boolean next() throws BirtException {
        this.checkStarted();
        ++this.currRowIndex;
        if (this.currRowIndex < this.rowCount) {
            this.readCurrentRow();
            return true;
        }
        return false;
    }

    private void readCurrentRow() throws DataException {
        try {
            this.rowIndex = IOUtil.readInt((InputStream)this.rowInputStream);
            this.startingGroupLevel = IOUtil.readInt((InputStream)this.rowInputStream);
            this.endingGroupLevel = IOUtil.readInt((InputStream)this.rowInputStream);
            this.columnValueMap.clear();
            int i = 0;
            while (i < this.columnList.size()) {
                this.columnValueMap.put(this.columnList.get(i), IOUtil.readObject((DataInputStream)this.rowInputStream));
                ++i;
            }
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.ReadCacheTempError");
        }
    }

    public void skipToEnd(int groupLevel) throws BirtException {
        while (this.getEndingGroupLevel() != groupLevel) {
            if (this.next()) continue;
            return;
        }
    }

    private void checkStarted() throws DataException {
        if (this.rowInputStream == null) {
            DataException e = new DataException("data.engine.ResultClosed");
            throw e;
        }
    }
}

