/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.CachedQueryResults;
import org.eclipse.birt.data.engine.impl.ConfigFileParser;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.impl.IncreCacheDataSetAdapter;
import org.eclipse.birt.data.engine.impl.JointDataSetAdapter;
import org.eclipse.birt.data.engine.impl.OdaDataSetAdapter;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVQuery;
import org.eclipse.birt.data.engine.impl.PreparedIncreCacheDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery;
import org.eclipse.birt.data.engine.impl.ScriptDataSetAdapter;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.GroupDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.mozilla.javascript.Scriptable;

class PreparedQueryUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedQueryUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    PreparedQueryUtil() {
    }

    static IPreparedQuery newInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        PreparedDataSourceQuery preparedQuery;
        if (!$assertionsDisabled && dataEngine == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryDefn == null) {
            throw new AssertionError();
        }
        if (queryDefn.getQueryResultsID() != null) {
            if (dataEngine.getContext().getMode() == 1 || dataEngine.getContext().getMode() == 3) {
                return new DummyPreparedQuery(queryDefn, dataEngine.getContext());
            }
            return PreparedQueryUtil.newIVInstance(dataEngine, queryDefn);
        }
        IBaseDataSetDesign dset = PreparedQueryUtil.cloneDataSetDesign(dataEngine.getDataSetDesign(queryDefn.getDataSetName()), appContext);
        if (dset == null && queryDefn.getQueryResultsID() == null) {
            return new PreparedDummyQuery(dataEngine.getContext(), queryDefn, dataEngine.getSession().getSharedScope());
        }
        if (dset instanceof IScriptDataSetDesign) {
            preparedQuery = new PreparedScriptDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IOdaDataSetDesign) {
            preparedQuery = dset instanceof IIncreCacheDataSetDesign ? new PreparedIncreCacheDSQuery(dataEngine, queryDefn, dset, appContext) : new PreparedOdaDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IJointDataSetDesign) {
            preparedQuery = new PreparedJointDataSourceQuery(dataEngine, queryDefn, dset, appContext);
        } else {
            throw new DataException("data.engine.UnsupportedDataSetType", dset.getName());
        }
        return preparedQuery;
    }

    private static IBaseDataSetDesign cloneDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        if (dataSetDesign instanceof IScriptDataSetDesign) {
            return new ScriptDataSetAdapter(dataSetDesign);
        }
        if (dataSetDesign instanceof IOdaDataSetDesign) {
            return PreparedQueryUtil.adaptOdaDataSetDesign(dataSetDesign, appContext);
        }
        if (dataSetDesign instanceof IJointDataSetDesign) {
            return new JointDataSetAdapter(dataSetDesign);
        }
        if (dataSetDesign == null) {
            return null;
        }
        throw new DataException("data.engine.UnsupportedDataSetType", dataSetDesign.getName());
    }

    private static IBaseDataSetDesign adaptOdaDataSetDesign(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        OdaDataSetAdapter adaptedDesign = null;
        URL configFileUrl = DataSetCacheUtil.getCacheConfig(appContext);
        if (configFileUrl != null) {
            try {
                InputStream is = configFileUrl.openStream();
                ConfigFileParser parser = new ConfigFileParser(is);
                String id = dataSetDesign.getName();
                if (parser.containDataSet(id)) {
                    String mode = parser.getModeByID(id);
                    if ("incremental".equalsIgnoreCase(mode)) {
                        String queryTemplate = parser.getQueryTextByID(id);
                        String timestampColumn = parser.getTimeStampColumnByID(id);
                        String formatPattern = parser.getTSFormatByID(id);
                        IncreCacheDataSetAdapter pscDataSet = new IncreCacheDataSetAdapter(dataSetDesign);
                        pscDataSet.setCacheMode(1);
                        pscDataSet.setConfigFileUrl(configFileUrl);
                        pscDataSet.setQueryTemplate(queryTemplate);
                        pscDataSet.setTimestampColumn(timestampColumn);
                        pscDataSet.setFormatPattern(formatPattern);
                        adaptedDesign = pscDataSet;
                    } else {
                        String message = MessageFormat.format("data.cache.UnsupportedIncrementalCacheMode", mode);
                        throw new UnsupportedOperationException(message);
                    }
                }
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (adaptedDesign == null) {
            adaptedDesign = new OdaDataSetAdapter(dataSetDesign);
        }
        return adaptedDesign;
    }

    private static IPreparedQuery newIVInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        if (PreparedQueryUtil.runQueryOnRS(dataEngine, queryDefn)) {
            return new PreparedIVQuery(dataEngine, queryDefn);
        }
        return new PreparedIVDataSourceQuery(dataEngine, queryDefn);
    }

    private static boolean runQueryOnRS(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        if (!queryDefn.usesDetails()) {
            queryDefn.getSorts().clear();
        }
        String queryResultID = queryDefn.getQueryResultsID();
        String rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultID);
        String parentQueryResultID = null;
        if (rootQueryResultID != null) {
            parentQueryResultID = QueryResultIDUtil.get2PartID(queryResultID);
        } else {
            rootQueryResultID = queryResultID;
        }
        QueryResultInfo queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1);
        RDLoad rdLoad = RDUtil.newLoad(dataEngine.getContext(), queryResultInfo);
        boolean runningOnRS = GroupDefnUtil.isEqualGroups(queryDefn.getGroups(), rdLoad.loadGroupDefn(0, 0));
        if (!runningOnRS) {
            return false;
        }
        boolean bl = runningOnRS = !PreparedQueryUtil.hasAggregationInFilter(queryDefn.getFilters());
        if (!runningOnRS) {
            return false;
        }
        runningOnRS = PreparedQueryUtil.isCompatibleRSMap(rdLoad.loadQueryDefn(0, 0).getBindings(), queryDefn.getBindings());
        if (!runningOnRS) {
            return false;
        }
        runningOnRS = PreparedQueryUtil.isCompatibleSubQuery(rdLoad.loadQueryDefn(0, 0), queryDefn);
        if (!runningOnRS) {
            return false;
        }
        IBaseQueryDefinition qd = rdLoad.loadQueryDefn(0, 0);
        List filters = qd.getFilters();
        if (FilterDefnUtil.isConflictFilter(filters, queryDefn.getFilters())) {
            runningOnRS = false;
            FilterDefnUtil.getRealFilterList(rdLoad.loadOriginalQueryDefn(0, 0).getFilters(), queryDefn.getFilters());
        }
        if (!runningOnRS) {
            return false;
        }
        if (!PreparedQueryUtil.isBindingReferenceSort(queryDefn.getSorts())) {
            return false;
        }
        if (PreparedQueryUtil.hasSubquery(queryDefn)) {
            if (PreparedQueryUtil.hasSubQueryInDetail(queryDefn.getSubqueries())) {
                return false;
            }
            if (!QueryDefnUtil.isEqualSorts(queryDefn.getSorts(), qd.getSorts())) {
                runningOnRS = false;
            }
            Collection subqueries = queryDefn.getSubqueries();
            List gps = queryDefn.getGroups();
            if (gps != null && gps.size() > 0) {
                int i = 0;
                while (i < gps.size()) {
                    subqueries.addAll(((IGroupDefinition)gps.get(i)).getSubqueries());
                    ++i;
                }
            }
            Iterator it = subqueries.iterator();
            while (it.hasNext()) {
                IBaseQueryDefinition query = (IBaseQueryDefinition)it.next();
                if (!query.usesDetails()) {
                    query.getSorts().clear();
                }
                if (query.getFilters() != null && query.getFilters().size() > 0) {
                    runningOnRS = false;
                    break;
                }
                List groups = query.getGroups();
                if (groups != null && !groups.isEmpty()) {
                    runningOnRS = false;
                }
                if (!runningOnRS) break;
            }
        }
        if (!runningOnRS) {
            return false;
        }
        if (queryDefn.getFilters() != null && queryDefn.getFilters().size() > 0 && !PreparedQueryUtil.isFiltersEquals(filters, queryDefn.getFilters())) {
            runningOnRS = queryDefn.getBindings().values() == null || !PreparedQueryUtil.hasAggregationOnRowObjects(queryDefn.getBindings().values().iterator());
        }
        return runningOnRS;
    }

    private static boolean isBindingReferenceSort(List sorts) {
        if (sorts == null || sorts.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < sorts.size()) {
            ISortDefinition sort = (ISortDefinition)sorts.get(i);
            if (sort.getExpression() != null) {
                try {
                    if (ExpressionUtil.getColumnBindingName((String)sort.getExpression().getText()) == null) {
                        return false;
                    }
                }
                catch (BirtException birtException) {}
            }
            ++i;
        }
        return true;
    }

    private static boolean hasSubQueryInDetail(Collection col) {
        if (col == null || col.size() == 0) {
            return false;
        }
        Iterator it = col.iterator();
        while (it.hasNext()) {
            ISubqueryDefinition sub = (ISubqueryDefinition)it.next();
            if (!sub.applyOnGroup()) {
                return true;
            }
            if (!PreparedQueryUtil.hasSubQueryInDetail(sub.getSubqueries())) continue;
            return true;
        }
        return false;
    }

    private static boolean isFiltersEquals(List oldFilter, List newFilter) {
        if (oldFilter.size() != newFilter.size()) {
            return false;
        }
        int i = 0;
        while (i < oldFilter.size()) {
            if (!FilterDefnUtil.isEqualFilter((IFilterDefinition)oldFilter.get(i), (IFilterDefinition)newFilter.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean hasAggregationInFilter(List filters) {
        if (filters == null || filters.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < filters.size()) {
            IBaseExpression o = ((IFilterDefinition)filters.get(i)).getExpression();
            if (o instanceof IConditionalExpression) {
                int type = ((IConditionalExpression)o).getOperator();
                if (type == 14 || type == 15 || type == 16 || type == 17) {
                    return true;
                }
                if (ExpressionCompilerUtil.hasAggregationInExpr(o)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean isCompatibleRSMap(Map oldMap, Map newMap) throws DataException {
        if (oldMap == null) {
            return newMap.size() == 0;
        }
        if (newMap == null) {
            return oldMap.size() == 0;
        }
        if (newMap.size() > oldMap.size()) {
            return false;
        }
        Iterator it = newMap.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object oldObj = oldMap.get(key);
            Object newObj = newMap.get(key);
            if (oldObj != null) {
                if (PreparedQueryUtil.isTwoBindingEqual((IBinding)newObj, (IBinding)oldObj)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isTwoBindingEqual(IBinding b1, IBinding b2) throws DataException {
        if (!PreparedQueryUtil.isTwoExpressionEqual(b1.getExpression(), b2.getExpression())) {
            return false;
        }
        if (!PreparedQueryUtil.isTwoStringEqual(b1.getAggrFunction(), b2.getAggrFunction())) {
            return false;
        }
        if (b1.getDataType() != b2.getDataType()) {
            return false;
        }
        if (!PreparedQueryUtil.isTwoExpressionEqual(b1.getFilter(), b2.getFilter())) {
            return false;
        }
        if (b1.getAggregatOns().size() != b2.getAggregatOns().size()) {
            return false;
        }
        int i = 0;
        while (i < b1.getAggregatOns().size()) {
            if (!PreparedQueryUtil.isTwoStringEqual(b1.getAggregatOns().get(i).toString(), b2.getAggregatOns().get(i).toString())) {
                return false;
            }
            ++i;
        }
        if (b1.getArguments().size() != b2.getArguments().size()) {
            return false;
        }
        i = 0;
        while (i < b1.getArguments().size()) {
            if (!PreparedQueryUtil.isTwoExpressionEqual((IBaseExpression)b1.getArguments().get(i), (IBaseExpression)b2.getArguments().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isTwoStringEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null && s2 == null) {
            return false;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    private static boolean isTwoExpressionEqual(IBaseExpression obj1, IBaseExpression obj2) {
        if (obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 != null && obj2 == null) {
            return false;
        }
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        if (obj1 instanceof IScriptExpression) {
            return PreparedQueryUtil.isTwoExpressionEqual((IScriptExpression)obj1, (IScriptExpression)obj2);
        }
        if (obj1 instanceof IConditionalExpression) {
            return PreparedQueryUtil.isTwoExpressionEqual((IConditionalExpression)obj1, (IConditionalExpression)obj2);
        }
        return false;
    }

    private static boolean isTwoExpressionEqual(IScriptExpression obj1, IScriptExpression obj2) {
        if (obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 != null && obj2 == null) {
            return false;
        }
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return PreparedQueryUtil.isTwoStringEqual(obj1.getText(), obj2.getText()) && PreparedQueryUtil.isTwoStringEqual(obj1.getGroupName(), obj2.getGroupName()) && PreparedQueryUtil.isTwoStringEqual(obj1.getText(), obj2.getText()) && obj1.getDataType() == obj2.getDataType();
    }

    private static boolean isTwoExpressionEqual(IConditionalExpression obj1, IConditionalExpression obj2) {
        if (obj1.getOperator() != obj2.getOperator()) {
            return false;
        }
        return PreparedQueryUtil.isTwoStringEqual(obj1.getGroupName(), obj2.getGroupName()) && PreparedQueryUtil.isTwoExpressionEqual(obj1.getExpression(), obj2.getExpression()) && PreparedQueryUtil.isTwoExpressionEqual(obj1.getOperand1(), obj2.getOperand1()) && PreparedQueryUtil.isTwoExpressionEqual(obj1.getOperand2(), obj2.getOperand2());
    }

    private static boolean isCompatibleSubQuery(IBaseQueryDefinition oldDefn, IBaseQueryDefinition newDefn) {
        boolean isComp = QueryDefnUtil.isCompatibleSQs(oldDefn.getSubqueries(), newDefn.getSubqueries());
        if (!isComp) {
            return false;
        }
        Iterator oldIt = oldDefn.getGroups().iterator();
        Iterator newIt = newDefn.getGroups().iterator();
        while (newIt.hasNext()) {
            IGroupDefinition oldGroupDefn = (IGroupDefinition)oldIt.next();
            IGroupDefinition newGroupDefn = (IGroupDefinition)newIt.next();
            isComp = QueryDefnUtil.isCompatibleSQs(oldGroupDefn.getSubqueries(), newGroupDefn.getSubqueries());
            if (isComp) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAggregationOnRowObjects(Iterator it) throws DataException {
        while (it.hasNext()) {
            IBinding binding = (IBinding)it.next();
            if (ExpressionCompilerUtil.hasAggregationInExpr(binding.getExpression())) {
                return true;
            }
            if (binding.getAggrFunction() == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSubquery(IQueryDefinition qd) {
        if (!$assertionsDisabled && qd == null) {
            throw new AssertionError();
        }
        if (qd.getSubqueries() != null && qd.getSubqueries().size() > 0) {
            return true;
        }
        if (qd.getGroups() != null) {
            int i = 0;
            while (i < qd.getGroups().size()) {
                IGroupDefinition gd = (IGroupDefinition)qd.getGroups().get(i);
                if (gd.getSubqueries() != null && gd.getSubqueries().size() > 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static class DummyPreparedQuery
    implements IPreparedQuery {
        private IQueryDefinition queryDefn;
        private DataEngineContext context;

        public DummyPreparedQuery(IQueryDefinition queryDefn, DataEngineContext context) {
            this.queryDefn = queryDefn;
            this.context = context;
        }

        public IQueryResults execute(Scriptable queryScope) throws BirtException {
            return new CachedQueryResults(this.context, this.queryDefn.getQueryResultsID());
        }

        public IQueryResults execute(IQueryResults outerResults, Scriptable queryScope) throws BirtException {
            throw new UnsupportedOperationException();
        }

        public Collection getParameterMetaData() throws BirtException {
            return null;
        }

        public IQueryDefinition getReportQueryDefn() {
            return this.queryDefn;
        }
    }
}

