/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.JointDataSetQuery;
import org.eclipse.birt.data.engine.executor.dscache.CandidateQuery;
import org.eclipse.birt.data.engine.executor.dscache.DataSourceQuery;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.expression.ExpressionProcessor;
import org.eclipse.birt.data.engine.impl.ColumnInfo;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.ExecutorHelper;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.impl.GroupComputedColumn;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.ParameterUtil;
import org.eclipse.birt.data.engine.impl.QueryExecutorUtil;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.group.GroupCalculatorFactory;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;
import org.eclipse.birt.data.engine.script.OnFetchScriptHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public abstract class QueryExecutor
implements IQueryExecutor {
    private IBaseQueryDefinition baseQueryDefn;
    private AggregateTable aggrTable;
    private Scriptable sharedScope;
    private Scriptable parentScope;
    private Scriptable queryScope;
    private boolean isPrepared = false;
    private boolean isExecuted = false;
    private Map queryAppContext;
    private int nestedLevel = 1;
    protected DataSourceRuntime dataSource;
    protected DataSetRuntime dataSet;
    protected IDataSource odiDataSource;
    protected IQuery odiQuery;
    protected IQueryService outerResults;
    private IResultIterator odiResult;
    private IExecutorHelper parentHelper;
    private DataEngineSession session;
    private List temporaryComputedColumns = new ArrayList();
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    QueryExecutor(Scriptable sharedScope, IBaseQueryDefinition baseQueryDefn, AggregateTable aggrTable, DataEngineSession session) {
        Object[] params = new Object[]{sharedScope, baseQueryDefn, aggrTable, session};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "QueryExecutor", params);
        this.sharedScope = sharedScope;
        this.baseQueryDefn = baseQueryDefn;
        this.aggrTable = aggrTable;
        this.session = session;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "QueryExecutor");
    }

    protected abstract DataSourceRuntime findDataSource() throws DataException;

    protected abstract DataSetRuntime newDataSetRuntime() throws DataException;

    protected abstract IDataSource createOdiDataSource() throws DataException;

    protected abstract IQuery createOdiQuery() throws DataException;

    protected void prepareOdiQuery() throws DataException {
    }

    protected abstract IResultIterator executeOdiQuery(IEventHandler var1) throws DataException;

    void setAppContext(Map context) {
        this.queryAppContext = context;
    }

    void prepareExecution(IQueryResults outerRts, Scriptable targetScope) throws DataException {
        if (this.isPrepared) {
            return;
        }
        this.parentScope = targetScope;
        this.dataSource = this.findDataSource();
        if (outerRts != null && outerRts instanceof IQueryService) {
            this.outerResults = (IQueryService)((Object)outerRts);
            if (this.outerResults.isClosed()) {
                throw new DataException("data.engine.ResultClosed");
            }
            this.nestedLevel = this.outerResults.getNestedLevel();
            IExecutorHelper helper = this.outerResults.getExecutorHelper();
            this.setParentExecutorHelper(helper);
        }
        this.dataSet = this.newDataSetRuntime();
        if (!$assertionsDisabled && this.dataSet == null) {
            throw new AssertionError();
        }
        this.openDataSource();
        this.dataSet.beforeOpen();
        this.odiQuery = this.createOdiQuery();
        this.odiQuery.setDistinctValueFlag(this.dataSet.needDistinctValue());
        this.odiQuery.setExprProcessor(new ExpressionProcessor(this.dataSet));
        if (this.dataSet.getDesign() != null) {
            this.odiQuery.setRowFetchLimit(this.dataSet.getDesign().getRowFetchLimit());
        }
        this.populateOdiQuery();
        this.prepareOdiQuery();
        this.isPrepared = true;
    }

    protected void openDataSource() throws DataException {
        if (!$assertionsDisabled && this.odiDataSource != null) {
            throw new AssertionError();
        }
        if (this.dataSource != null) {
            if (!this.dataSource.isOpen() || this.session.getDataSetCacheManager().doesLikeToCache()) {
                this.dataSource.beforeOpen();
                this.odiDataSource = this.createOdiDataSource();
                this.odiDataSource.setAppContext(this.queryAppContext);
                this.dataSource.openOdiDataSource(this.odiDataSource);
                this.dataSource.afterOpen();
            } else {
                this.odiDataSource = this.dataSource.getOdiDataSource();
                this.odiDataSource.setAppContext(this.queryAppContext);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateOdiQuery() throws DataException {
        if (!$assertionsDisabled && this.odiQuery == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.baseQueryDefn == null) {
            throw new AssertionError();
        }
        Context cx = Context.enter();
        try {
            this.populateGrouping(cx);
            this.populateSorting();
            this.populateFetchEvent(cx);
            this.odiQuery.setMaxRows(this.baseQueryDefn.getMaxRows());
            this.prepareCacheQuery(this.odiQuery);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        Context.exit();
    }

    protected void prepareCacheQuery(IQuery odiQuery) {
        if (this.temporaryComputedColumns != null && this.temporaryComputedColumns.size() > 0) {
            if (odiQuery instanceof DataSourceQuery) {
                ((DataSourceQuery)odiQuery).setTempComputedColumn(this.temporaryComputedColumns);
            } else if (odiQuery instanceof CandidateQuery) {
                ((CandidateQuery)odiQuery).setTempComputedColumn(this.temporaryComputedColumns);
            }
        }
    }

    private void populateGrouping(Context cx) throws DataException {
        List groups = this.baseQueryDefn.getGroups();
        if (groups != null && !groups.isEmpty()) {
            IQuery.GroupSpec[] groupSpecs = new IQuery.GroupSpec[groups.size()];
            Iterator it = groups.iterator();
            int i = 0;
            while (it.hasNext()) {
                IQuery.GroupSpec dest;
                IGroupDefinition src = (IGroupDefinition)it.next();
                this.validateGroupExpression(src);
                String expr = this.getGroupKeyExpression(src);
                String groupName = this.populateGroupName(i, expr);
                groupSpecs[i] = dest = QueryExecutorUtil.groupDefnToSpec(cx, src, expr, groupName, -1);
                this.temporaryComputedColumns.add(this.getComputedColumnInstance(cx, groupSpecs[i].getInterval(), src, expr, groupName, dest));
                ++i;
            }
            this.odiQuery.setGrouping(Arrays.asList(groupSpecs));
        }
    }

    private void validateGroupExpression(IGroupDefinition src) throws DataException {
        if (!(src.getKeyColumn() != null && src.getKeyColumn().trim().length() != 0 || src.getKeyExpression() != null && src.getKeyExpression().trim().length() != 0)) {
            throw new DataException("data.engine.BadGroupExpr");
        }
    }

    private String populateGroupName(int i, String expr) {
        String groupName = expr.trim().equalsIgnoreCase("row[0]") || expr.trim().equalsIgnoreCase("row._rowPosition") || expr.trim().equalsIgnoreCase("dataSetRow[0]") || expr.trim().equalsIgnoreCase("dataSetRow._rowPosition") ? "_{$TEMP_GROUP_" + i + "ROWID$}_" : "_{$TEMP_GROUP_" + i + "$}_";
        return groupName;
    }

    private IComputedColumn getComputedColumnInstance(Context cx, int interval, IGroupDefinition src, String expr, String groupName, IQuery.GroupSpec dest) throws DataException {
        if (dest.getInterval() != 0 && dest.getIntervalRange() != 0.0) {
            return new GroupComputedColumn(groupName, expr, QueryExecutorUtil.getTempComputedColumnType(interval), GroupCalculatorFactory.getGroupCalculator(src.getInterval(), this.getColumnDataType(cx, expr), src.getIntervalStart(), src.getIntervalRange()));
        }
        return new ComputedColumn(groupName, expr, QueryExecutorUtil.getTempComputedColumnType(interval));
    }

    private void populateSorting() throws DataException {
        List sorts = this.baseQueryDefn.getSorts();
        if (sorts != null && !sorts.isEmpty()) {
            IQuery.SortSpec[] sortSpecs = new IQuery.SortSpec[sorts.size()];
            Iterator it = sorts.iterator();
            int i = 0;
            while (it.hasNext()) {
                IQuery.SortSpec dest;
                ISortDefinition src = (ISortDefinition)it.next();
                int sortIndex = -1;
                String sortKey = src.getColumn();
                sortKey = sortKey == null ? src.getExpression().getText() : this.getColumnRefExpression(sortKey);
                this.temporaryComputedColumns.add(new ComputedColumn("_{$TEMP_SORT_" + i + "$}_", sortKey, 0));
                sortIndex = -1;
                sortKey = String.valueOf("_{$TEMP_SORT_" + i + "$}_");
                sortSpecs[i] = dest = new IQuery.SortSpec(sortIndex, sortKey, src.getSortDirection() == 0);
                ++i;
            }
            this.odiQuery.setOrdering(Arrays.asList(sortSpecs));
        }
    }

    private void populateFetchEvent(Context cx) throws DataException {
        IResultObjectEvent objectEvent;
        List dataSetFilters = new ArrayList();
        ArrayList queryFilters = new ArrayList();
        if (this.dataSet.getFilters() != null) {
            dataSetFilters = this.dataSet.getFilters();
        }
        if (this.baseQueryDefn.getFilters() != null) {
            int i = 0;
            while (i < this.baseQueryDefn.getFilters().size()) {
                queryFilters.add(this.baseQueryDefn.getFilters().get(i));
                ++i;
            }
        }
        List multipassFilters = this.prepareFilters(cx, dataSetFilters, queryFilters, this.temporaryComputedColumns);
        ArrayList computedColumns = null;
        computedColumns = this.dataSet.getComputedColumns();
        if (computedColumns == null) {
            computedColumns = new ArrayList();
        }
        if (computedColumns.size() > 0 || this.temporaryComputedColumns.size() > 0) {
            objectEvent = new ComputedColumnHelper(this.dataSet, computedColumns, this.temporaryComputedColumns);
            this.odiQuery.addOnFetchEvent(objectEvent);
            this.dataSet.getComputedColumns().addAll(this.temporaryComputedColumns);
        }
        if (this.dataSet.getEventHandler() != null) {
            OnFetchScriptHelper event = new OnFetchScriptHelper(this.dataSet);
            this.odiQuery.addOnFetchEvent(event);
        }
        if (dataSetFilters.size() + queryFilters.size() + multipassFilters.size() > 0) {
            objectEvent = new FilterByRow(dataSetFilters, queryFilters, multipassFilters, this.dataSet);
            this.odiQuery.addOnFetchEvent(objectEvent);
        }
    }

    private int getColumnDataType(Context cx, String expr) throws DataException {
        String columnName = QueryExecutorUtil.getColInfoFromJSExpr(cx, expr).getColumnName();
        if (columnName == null) {
            return -1;
        }
        if (columnName.equals("__rownum")) {
            return 2;
        }
        Object baseExpr = this.baseQueryDefn.getBindings().get(columnName);
        if (baseExpr == null) {
            return -1;
        }
        return ((IBinding)baseExpr).getExpression().getDataType();
    }

    private String getGroupKeyExpression(IGroupDefinition src) {
        String expr = src.getKeyColumn();
        expr = expr == null ? src.getKeyExpression() : this.getColumnRefExpression(expr);
        return expr;
    }

    private String getColumnRefExpression(String expr) {
        return ExpressionUtil.createJSRowExpression((String)expr);
    }

    void setParentExecutorHelper(IExecutorHelper helper) {
        this.parentHelper = helper;
    }

    private List prepareFilters(Context cx, List dataSetFilters, List queryFilters, List temporaryComputedColumns) throws DataException {
        ArrayList result = new ArrayList();
        this.prepareFilter(cx, dataSetFilters, temporaryComputedColumns, result);
        this.prepareFilter(cx, queryFilters, temporaryComputedColumns, result);
        return result;
    }

    private void prepareFilter(Context cx, List dataSetFilters, List temporaryComputedColumns, List result) throws DataException {
        if (dataSetFilters != null && !dataSetFilters.isEmpty()) {
            Iterator it = dataSetFilters.iterator();
            int i = 0;
            while (it.hasNext()) {
                IFilterDefinition src = (IFilterDefinition)it.next();
                IBaseExpression expr = src.getExpression();
                if (this.isGroupFilter(src)) {
                    ConditionalExpression ce = (ConditionalExpression)expr;
                    String exprText = ce.getExpression().getText();
                    ColumnInfo columnInfo = QueryExecutorUtil.getColInfoFromJSExpr(cx, exprText);
                    int index = columnInfo.getColumnIndex();
                    String name = columnInfo.getColumnName();
                    if (name == null && index < 0) {
                        temporaryComputedColumns.add(new ComputedColumn("_{$TEMP_FILTER_" + i + "$}_", exprText, 0));
                        it.remove();
                        result.add(new FilterDefinition(new ConditionalExpression(new ScriptExpression(String.valueOf("dataSetRow[\"_{$TEMP_FILTER_" + i + "$}_\"]")), ce.getOperator(), ce.getOperand1(), ce.getOperand2())));
                    }
                }
                ++i;
            }
        }
    }

    private boolean isGroupFilter(IFilterDefinition filter) throws DataException {
        IBaseExpression expr = filter.getExpression();
        if (expr instanceof IConditionalExpression) {
            if (!ExpressionCompilerUtil.isValidExpressionInQueryFilter(expr)) {
                throw new DataException("data.engine.BadFilterDefn", new Object[]{((IConditionalExpression)expr).getExpression().getText()});
            }
            try {
                if (this.odiQuery instanceof BaseQuery) {
                    return ((BaseQuery)this.odiQuery).getExprProcessor().hasAggregation(expr);
                }
            }
            catch (DataException dataException) {
                return true;
            }
        }
        return false;
    }

    public IResultMetaData getResultMetaData() throws DataException {
        if (!($assertionsDisabled || this.odiQuery instanceof IPreparedDSQuery || this.odiQuery instanceof ICandidateQuery || this.odiQuery instanceof JointDataSetQuery)) {
            throw new AssertionError();
        }
        if (this.odiQuery instanceof IPreparedDSQuery) {
            if (((IPreparedDSQuery)((Object)this.odiQuery)).getResultClass() != null) {
                return new ResultMetaData(((IPreparedDSQuery)((Object)this.odiQuery)).getResultClass());
            }
            return null;
        }
        if (this.odiQuery instanceof JointDataSetQuery) {
            return new ResultMetaData(((JointDataSetQuery)this.odiQuery).getResultClass());
        }
        return new ResultMetaData(((ICandidateQuery)this.odiQuery).getResultClass());
    }

    public void execute(IEventHandler eventHandler) throws DataException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINER, clazz.getName(), "execute", "Start to execute");
        if (this.isExecuted) {
            return;
        }
        ExecutorHelper helper = new ExecutorHelper(this.parentHelper);
        eventHandler.setExecutorHelper(helper);
        this.odiResult = this.executeOdiQuery(eventHandler);
        helper.setJSRowObject(this.dataSet.getJSResultRowObject());
        this.resetComputedColumns();
        this.dataSet.setResultSet(this.odiResult, false);
        this.isExecuted = true;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINER, clazz2.getName(), "execute", "Finish executing");
    }

    private void resetComputedColumns() {
        List l = this.getDataSet().getComputedColumns();
        if (l != null) {
            l.removeAll(this.temporaryComputedColumns);
        }
    }

    public void close() {
        if (this.odiQuery == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINER, clazz.getName(), "close", "executor closed ");
            return;
        }
        try {
            this.dataSet.beforeClose();
        }
        catch (DataException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        if (this.odiResult != null) {
            this.odiResult.close();
        }
        this.odiQuery.close();
        try {
            this.dataSet.close();
        }
        catch (DataException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        this.odiQuery = null;
        this.odiDataSource = null;
        this.odiResult = null;
        this.queryScope = null;
        this.isPrepared = false;
        this.isExecuted = false;
        try {
            this.dataSet.afterClose();
        }
        catch (DataException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.logp(Level.FINE, clazz.getName(), "close", e.getMessage(), (Throwable)((Object)e));
        }
        this.dataSet = null;
        this.dataSource = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.QueryExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.logp(Level.FINER, clazz.getName(), "close", "executor closed ");
    }

    public DataSetRuntime getDataSet() {
        return this.dataSet;
    }

    public Scriptable getSharedScope() {
        return this.sharedScope;
    }

    public Scriptable getQueryScope() {
        if (this.queryScope == null) {
            this.queryScope = this.newSubScope(this.parentScope);
            this.queryScope.setPrototype(this.dataSet.getJSDataSetObject());
        }
        return this.queryScope;
    }

    private Scriptable newSubScope(Scriptable parentAndProtoScope) {
        Scriptable scriptable;
        if (parentAndProtoScope == null) {
            parentAndProtoScope = this.sharedScope;
        }
        Context cx = Context.enter();
        try {
            Scriptable scope = cx.newObject(parentAndProtoScope);
            scope.setParentScope(parentAndProtoScope);
            scope.setPrototype(parentAndProtoScope);
            scriptable = scope;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return scriptable;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public IDataSourceInstanceHandle getDataSourceInstanceHandle() {
        return this.dataSource;
    }

    public Scriptable getJSAggrValueObject() {
        return this.aggrTable.getJSAggrValueObject();
    }

    public DataSetRuntime[] getNestedDataSets(int nestedCount) {
        return this.outerResults.getDataSetRuntime(nestedCount);
    }

    public IResultIterator getOdiResultSet() {
        return this.odiResult;
    }

    protected Collection resolveDataSetParameters(boolean evaluateValue) throws DataException {
        return new ParameterUtil(this.outerResults, this.getDataSet(), (IQueryDefinition)this.baseQueryDefn, this.getQueryScope()).resolveDataSetParameters(evaluateValue);
    }

    public Map getAppContext() {
        return this.queryAppContext;
    }
}

