/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseTransform;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.document.QueryDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.RDLoadUtil;
import org.eclipse.birt.data.engine.impl.document.RDSubQueryUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.util.BaseExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataResultSet1;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataResultSet2;
import org.eclipse.birt.data.engine.impl.document.util.ExprResultSet;
import org.eclipse.birt.data.engine.impl.document.util.ExprResultSet2;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaInfo;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class RDLoad {
    private int version;
    private StreamManager streamManager;
    private RDSubQueryUtil subQueryUtil;

    RDLoad(DataEngineContext context, QueryResultInfo queryResultInfo) throws DataException {
        this.subQueryUtil = new RDSubQueryUtil(context, QueryResultIDUtil.getRealStreamID(queryResultInfo.getRootQueryResultID(), queryResultInfo.getSelfQueryResultID()), queryResultInfo.getSubQueryName());
        this.streamManager = new StreamManager(context, new QueryResultInfo(queryResultInfo.getRootQueryResultID(), queryResultInfo.getParentQueryResultID(), queryResultInfo.getSelfQueryResultID(), queryResultInfo.getSubQueryName(), queryResultInfo.getSubQueryName() == null ? 0 : this.getSubQueryIndex(queryResultInfo.getIndex())));
        this.version = this.streamManager.getVersion();
    }

    int getSubQueryIndex(int currParentIndex) throws DataException {
        return this.subQueryUtil.getSubQueryIndex(currParentIndex);
    }

    public ResultMetaData loadResultMetaData() throws DataException {
        return new ResultMetaData(this.loadResultClass());
    }

    IExprResultSet loadExprResultSet() throws DataException {
        if (this.streamManager.isSecondRD() && this.streamManager.isSubquery()) {
            return new ExprResultSet2(this.streamManager, this.version, this.streamManager.isSecondRD());
        }
        return new ExprResultSet(this.streamManager, this.version, this.streamManager.isSecondRD(), this.streamManager.isSubquery() || this.version < 50 ? null : this.loadDataSetData());
    }

    public RDGroupUtil loadRootGroupUtil() throws DataException {
        return RDLoadUtil.loadGroupUtil(this.streamManager, 0, 0);
    }

    public IExprDataResultSet loadExprDataResultSet() throws DataException {
        if (this.version == 0) {
            throw new DataException("data.engine.wrongVersion");
        }
        RAInputStream inputStream = this.streamManager.getInStream(32, 0, 0);
        BufferedInputStream buffStream = new BufferedInputStream((InputStream)inputStream);
        ExprMetaInfo[] exprMetas = ExprMetaUtil.loadExprMetaInfo(buffStream);
        try {
            buffStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {}
        BaseExprDataResultSet exprDataResultSet = null;
        exprDataResultSet = !this.streamManager.isBasedOnSecondRD() ? new ExprDataResultSet1(this.streamManager.getInStream(31, 0, 0), exprMetas, this.version, this.version < 50 ? null : this.loadDataSetData()) : new ExprDataResultSet2(this.streamManager.getInStream(31, 0, 0), this.streamManager.getInStream(33, 0, 0), this.streamManager.getInStream(51, 0, 1), exprMetas, this.version, this.version < 50 ? null : this.loadDataSetData());
        return exprDataResultSet;
    }

    private IResultClass loadResultClass() throws DataException {
        RAInputStream stream = this.streamManager.getInStream(22, 0, 0);
        BufferedInputStream buffStream = new BufferedInputStream((InputStream)stream);
        ResultClass resultClass = new ResultClass(buffStream);
        try {
            buffStream.close();
            stream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
        return resultClass;
    }

    public DataSetResultSet loadDataSetData() throws DataException {
        RAInputStream stream = this.streamManager.getInStream(21, 0, 0);
        RAInputStream lensStream = null;
        if (this.version >= 50) {
            lensStream = this.streamManager.getInStream(23, 0, 0);
        }
        DataSetResultSet populator = new DataSetResultSet(stream, lensStream, this.loadResultClass(), this.version);
        return populator;
    }

    public IBaseQueryDefinition loadOriginalQueryDefn(int streamPos, int streamScope) throws DataException {
        RAInputStream inputStream = this.streamManager.getInStream(44, streamPos, streamScope);
        return this.loadQueryDefn((InputStream)inputStream);
    }

    public IBaseQueryDefinition loadQueryDefn(int streamPos, int streamScope) throws DataException {
        RAInputStream inputStream = this.streamManager.getInStream(43, streamPos, streamScope);
        return this.loadQueryDefn((InputStream)inputStream);
    }

    private IBaseQueryDefinition loadQueryDefn(InputStream inputStream) throws DataException {
        IQueryDefinition queryDefn = QueryDefnUtil.loadQueryDefn(inputStream, this.version);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return queryDefn;
    }

    public List loadFilterDefn(int streamPos, int streamScope) throws DataException {
        return this.loadQueryDefn(streamPos, streamScope).getFilters();
    }

    public List loadGroupDefn(int streamPos, int streamScope) throws DataException {
        return this.loadQueryDefn(streamPos, streamScope).getGroups();
    }

    public ISubqueryDefinition loadSubQueryDefn(int streamPos, int streamScope, String subQueryName) throws DataException {
        if (subQueryName == null) {
            return null;
        }
        IBaseQueryDefinition baseQueryDefn = this.loadQueryDefn(streamPos, streamScope);
        return this.findSubQueryDefinition(subQueryName, baseQueryDefn);
    }

    private ISubqueryDefinition findSubQueryDefinition(String subQueryName, IBaseQueryDefinition queryDefn) throws DataException {
        if (queryDefn == null) {
            return null;
        }
        Collection subQueries = queryDefn.getSubqueries();
        ISubqueryDefinition subQueryDefn = null;
        if (subQueries != null && !subQueries.isEmpty()) {
            Iterator subQueriesIter = subQueries.iterator();
            while (subQueriesIter.hasNext()) {
                ISubqueryDefinition qd = (ISubqueryDefinition)subQueriesIter.next();
                if (qd.getName().equals(subQueryName)) {
                    return qd;
                }
                subQueryDefn = this.findSubQueryDefinition(subQueryName, qd);
            }
        }
        if (subQueryDefn == null && queryDefn.getGroups() != null) {
            List group = queryDefn.getGroups();
            int i = 0;
            while (i < group.size()) {
                Collection groupSubQueries = ((IBaseTransform)group.get(i)).getSubqueries();
                if (groupSubQueries != null && !groupSubQueries.isEmpty()) {
                    Iterator subQueriesIter = groupSubQueries.iterator();
                    while (subQueriesIter.hasNext()) {
                        ISubqueryDefinition qd = (ISubqueryDefinition)subQueriesIter.next();
                        if (qd.getName().equals(subQueryName)) {
                            return qd;
                        }
                        subQueryDefn = this.findSubQueryDefinition(subQueryName, qd);
                        if (subQueryDefn == null) continue;
                        return subQueryDefn;
                    }
                }
                ++i;
            }
        }
        return subQueryDefn;
    }
}

