/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.OLAPWarning;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfoGenerator;
import org.eclipse.birt.data.engine.olap.cursor.INavigator;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.EdgeAxis;

class EdgeNavigator
implements INavigator {
    private EdgeInfoGenerator edgeInfoGenerator;
    private IAggregationResultSet rs;
    private int fetchSize = -1;
    private List warnings;

    EdgeNavigator(EdgeAxis axis) {
        this.edgeInfoGenerator = axis.getEdgeInfoUtil();
        this.rs = axis.getQueryResultSet();
    }

    public void afterLast() throws OLAPException {
        this.edgeInfoGenerator.edge_afterLast();
    }

    public void beforeFirst() throws OLAPException {
        this.edgeInfoGenerator.edge_beforeFirst();
    }

    public void close() throws OLAPException {
        try {
            this.rs.close();
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public boolean first() throws OLAPException {
        return this.edgeInfoGenerator.edge_first();
    }

    public long getExtend() {
        return 0L;
    }

    public long getPosition() throws OLAPException {
        return this.edgeInfoGenerator.getEdgePostion();
    }

    public int getType() {
        return 0;
    }

    public boolean isAfterLast() throws OLAPException {
        return this.edgeInfoGenerator.edge_isAfterLast();
    }

    public boolean isBeforeFirst() {
        return this.edgeInfoGenerator.edge_isBeforeFirst();
    }

    public boolean isFirst() throws OLAPException {
        return this.edgeInfoGenerator.edge_isFirst();
    }

    public boolean isLast() throws OLAPException {
        return this.edgeInfoGenerator.edge_isLast();
    }

    public boolean last() throws OLAPException {
        return this.edgeInfoGenerator.edge_last();
    }

    public boolean next() throws OLAPException {
        return this.edgeInfoGenerator.edge_next();
    }

    public boolean previous() throws OLAPException {
        return this.edgeInfoGenerator.edge_previous();
    }

    public boolean relative(int arg0) throws OLAPException {
        return this.edgeInfoGenerator.edge_relative(arg0);
    }

    public void setPosition(long position) throws OLAPException {
        this.edgeInfoGenerator.edge_setPostion(position);
    }

    public void clearWarnings() throws OLAPException {
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }

    public Collection getWarnings() throws OLAPException {
        return this.warnings == null ? new ArrayList() : this.warnings;
    }

    public void setFetchSize(int arg0) throws OLAPException {
        this.fetchSize = arg0;
        this.edgeInfoGenerator.setFetchSize(arg0);
        if (this.fetchSize >= 0 && this.fetchSize != this.rs.length()) {
            if (this.warnings == null) {
                this.warnings = new ArrayList();
            }
            DataException ex = new DataException("data.olap.fetchlimitWarning", new Object[]{new Integer(arg0), new Integer(this.rs.length())});
            this.warnings.add(new OLAPWarning(ex.getLocalizedMessage()));
        }
    }
}

