/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;

public class ResultSetFetcher {
    private IAggregationResultSet rs;
    private int[] levelKeyColCount = null;

    public ResultSetFetcher(IAggregationResultSet rs) {
        this.rs = rs;
        int levelCount = rs.getLevelCount();
        this.levelKeyColCount = new int[levelCount];
        int i = 0;
        while (i < levelCount) {
            this.levelKeyColCount[i] = rs.getLevelKeyColCount(i);
            ++i;
        }
    }

    public Object getValue(int levelIndex, int attr) {
        if (attr >= this.levelKeyColCount[levelIndex]) {
            return this.rs.getLevelAttribute(levelIndex, attr - this.levelKeyColCount[levelIndex]);
        }
        return this.rs.getLevelKeyValue(levelIndex)[attr];
    }

    public int getAttributeIndex(int levelIndex, String attrName) {
        int index = this.rs.getLevelKeyIndex(levelIndex, attrName);
        if (index >= 0) {
            return index;
        }
        index = this.rs.getLevelAttributeIndex(levelIndex, attrName);
        if (index >= 0) {
            return this.levelKeyColCount[levelIndex] + index;
        }
        return -1;
    }

    public Object[] getLevelKeyValue(int levelIndex) {
        return this.rs.getLevelKeyValue(levelIndex);
    }

    public IAggregationResultSet getAggrResultSet() {
        return this.rs;
    }
}

