/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class CachedAggregationResultSet
implements IAggregationResultSet {
    private int currentPosition;
    private int length;
    private DimLevel[] levels;
    private String[][] keyNames;
    private String[][] attributeNames;
    private int[][] keyDataTypes;
    private int[][] attributeDataTypes;
    private Map aggregationResultNameMap = null;
    private int[] aggregationDataType;
    private IDiskArray aggregationResultRow;
    private AggregationResultRow resultObject;
    private int[] sortType;
    private DataInputStream inputStream;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    CachedAggregationResultSet(DataInputStream inputStream, int length, DimLevel[] levels, int[] sortTypes, String[][] keyNames, String[][] attributeNames, int[][] keyDataTypes, int[][] attributeDataTypes, String[] aggregationNames, int[] aggregationDataType) throws IOException {
        Class<?> clazz;
        Object[] params = new Object[]{inputStream, new Integer(length), levels, sortTypes, keyNames, attributeNames, keyDataTypes, attributeDataTypes, aggregationNames, aggregationDataType};
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz2.getName(), "CachedAggregationResultSet", params);
        this.inputStream = inputStream;
        this.currentPosition = 0;
        this.length = length;
        this.levels = levels;
        this.sortType = sortTypes;
        this.keyNames = keyNames;
        this.attributeNames = attributeNames;
        this.keyDataTypes = keyDataTypes;
        this.attributeDataTypes = attributeDataTypes;
        this.aggregationDataType = aggregationDataType;
        this.aggregationResultNameMap = new HashMap();
        if (aggregationNames != null) {
            int i = 0;
            while (i < aggregationNames.length) {
                this.aggregationResultNameMap.put(aggregationNames[i], new Integer(i));
                ++i;
            }
        }
        this.aggregationResultRow = new BufferedStructureArray(AggregationResultRow.getCreator(), 4000);
        if (this.length > 0) {
            this.seek(0);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz.getName(), "CachedAggregationResultSet");
    }

    public int getAggregationDataType(int aggregationIndex) throws IOException {
        if (this.aggregationDataType == null || aggregationIndex < 0) {
            return -1;
        }
        return this.aggregationDataType[aggregationIndex];
    }

    public int getAggregationIndex(String name) throws IOException {
        Object index = this.aggregationResultNameMap.get(name);
        if (index == null) {
            return -1;
        }
        return (Integer)index;
    }

    protected void finalize() throws Throwable {
        this.inputStream.close();
        super.finalize();
    }

    public Object getAggregationValue(int aggregationIndex) throws IOException {
        if (this.resultObject.getAggregationValues() == null || aggregationIndex < 0) {
            return null;
        }
        return this.resultObject.getAggregationValues()[aggregationIndex];
    }

    public String[] getLevelAttributes(int levelIndex) {
        if (this.attributeNames == null) {
            return null;
        }
        return this.attributeNames[levelIndex];
    }

    public DimLevel[] getAllLevels() {
        return this.levels;
    }

    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || this.resultObject.getLevelMembers()[levelIndex].getAttributes() == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    public int getLevelAttributeColCount(int levelIndex) {
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return 0;
        }
        return this.attributeNames[levelIndex].length;
    }

    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeDataTypes == null || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(level, attributeName)];
    }

    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        if (this.attributeDataTypes == null || levelIndex < 0 || this.attributeDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.attributeDataTypes[levelIndex][this.getLevelAttributeIndex(levelIndex, attributeName)];
    }

    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        if (this.attributeNames == null || levelIndex < 0 || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        int levelIndex = this.getLevelIndex(level);
        if (this.attributeNames == null || this.attributeNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.attributeNames[levelIndex].length) {
            if (this.attributeNames[levelIndex][i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelCount() {
        if (this.keyNames == null) {
            return 0;
        }
        return this.keyNames.length;
    }

    public int getLevelIndex(DimLevel level) {
        if (this.levels == null) {
            return -1;
        }
        int i = 0;
        while (i < this.levels.length) {
            if (this.levels[i].equals(level)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelKeyColCount(int levelIndex) {
        if (this.keyNames == null || this.keyNames[levelIndex] == null) {
            return 0;
        }
        return this.keyNames[levelIndex].length;
    }

    public int getLevelKeyDataType(DimLevel level, String keyName) {
        if (this.keyDataTypes == null) {
            return -1;
        }
        return this.getLevelKeyDataType(this.getLevelIndex(level), keyName);
    }

    public int getLevelKeyDataType(int levelIndex, String keyName) {
        if (this.keyDataTypes == null || levelIndex < 0 || this.keyDataTypes[levelIndex] == null) {
            return -1;
        }
        return this.keyDataTypes[levelIndex][this.getLevelKeyIndex(levelIndex, keyName)];
    }

    public int getLevelKeyIndex(int levelIndex, String keyName) {
        if (this.keyNames == null || levelIndex < 0 || this.keyNames[levelIndex] == null) {
            return -1;
        }
        int i = 0;
        while (i < this.keyNames[levelIndex].length) {
            if (this.keyNames[levelIndex][i].equals(keyName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelKeyIndex(DimLevel level, String keyName) {
        if (this.keyNames == null) {
            return -1;
        }
        return this.getLevelKeyIndex(this.getLevelIndex(level), keyName);
    }

    public Object[] getLevelKeyValue(int levelIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getKeyValues();
    }

    public int getSortType(int levelIndex) {
        if (this.sortType == null || this.sortType.length < levelIndex) {
            return -100;
        }
        return this.sortType[levelIndex];
    }

    public int length() {
        return this.length;
    }

    public void seek(int index) throws IOException {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
        }
        if (index >= this.aggregationResultRow.size()) {
            int i = 0;
            while (i <= index - this.aggregationResultRow.size()) {
                this.aggregationResultRow.add(AggregationResultSetSaveUtil.loadAggregationRow(this.inputStream));
                ++i;
            }
        }
        this.currentPosition = index;
        this.resultObject = (AggregationResultRow)this.aggregationResultRow.get(index);
    }

    public int getPosition() {
        return this.currentPosition;
    }

    public String[][] getAggributeNames() {
        return this.attributeNames;
    }

    public IAggregationResultRow getCurrentRow() throws IOException {
        return this.resultObject;
    }

    public String[][] getKeyNames() {
        return this.keyNames;
    }

    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.keyNames[levelIndex][keyIndex];
    }

    public DimLevel getLevel(int levelIndex) {
        return this.levels[levelIndex];
    }

    public AggregationDefinition getAggregationDefinition() {
        return null;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void clear() throws IOException {
        this.inputStream.close();
        this.length = 0;
    }
}

