/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.driver;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.EdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.MeasureNameManager;

public class CubeResultSet
implements IResultSet {
    private EdgeAxis rowEdgeAxis;
    private EdgeAxis columnEdgeAxis;
    private EdgeAxis[] calculatedEdgeAxis;
    private MeasureNameManager manager;

    public CubeResultSet(IAggregationResultSet[] rsArray, BirtCubeView view, MeasureNameManager manager, CubeQueryExecutorHelper cubeQueryExecutorHelper) throws IOException {
        int count = 0;
        if (view.getColumnEdgeView() != null) {
            this.columnEdgeAxis = new EdgeAxis(rsArray[count], view.getColumnEdgeView(), cubeQueryExecutorHelper.getColumnSort(), false);
            ++count;
        }
        if (view.getRowEdgeView() != null) {
            this.rowEdgeAxis = new EdgeAxis(rsArray[count], view.getRowEdgeView(), cubeQueryExecutorHelper.getRowSort(), false);
            ++count;
        }
        if (rsArray.length > count) {
            this.calculatedEdgeAxis = new EdgeAxis[rsArray.length - count];
            int i = count;
            while (i < rsArray.length) {
                this.calculatedEdgeAxis[i - count] = new EdgeAxis(rsArray[i], view.getMeasureEdgeView()[i - count], true);
                ++i;
            }
        }
    }

    public EdgeAxis getColumnEdgeResult() {
        return this.columnEdgeAxis;
    }

    public EdgeAxis getRowEdgeResult() {
        return this.rowEdgeAxis;
    }

    public EdgeAxis[] getMeasureResult() {
        return this.calculatedEdgeAxis;
    }

    public EdgeAxis getMeasureResult(String name) throws DataException {
        int index = this.manager.getAggregationResultID(name);
        return this.calculatedEdgeAxis[index];
    }
}

