/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.impl.query.CubeCursorImpl;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.script.JSLevelAccessor;
import org.eclipse.birt.data.engine.olap.script.JSMeasureAccessor;
import org.mozilla.javascript.Scriptable;

public class CubeQueryResults
implements ICubeQueryResults {
    private PreparedCubeQuery preparedQuery;
    private Scriptable scope;
    private DataEngineContext context;
    private DataEngineSession session;
    private String queryResultsId;
    private Map appContext;

    public CubeQueryResults(PreparedCubeQuery preparedQuery, DataEngineSession session, Scriptable scope, DataEngineContext context, Map appContext) {
        this.preparedQuery = preparedQuery;
        this.scope = scope;
        this.context = context;
        this.session = session;
        this.appContext = appContext;
        this.queryResultsId = preparedQuery.getCubeQueryDefinition().getQueryResultsID();
    }

    public CubeCursor getCubeCursor() throws DataException {
        try {
            CubeQueryExecutor executor = new CubeQueryExecutor(this.preparedQuery.getCubeQueryDefinition(), this.session, this.scope, this.context);
            BirtCubeView bcv = new BirtCubeView(executor, this.appContext);
            CubeCursor cubeCursor = bcv.getCubeCursor();
            String newResultSetId = executor.getQueryResultsId();
            if (newResultSetId != null) {
                this.queryResultsId = newResultSetId;
            }
            this.scope.put("measure", this.scope, (Object)new JSMeasureAccessor(cubeCursor));
            this.scope.put("dimension", this.scope, (Object)new JSLevelAccessor(this.preparedQuery.getCubeQueryDefinition(), bcv));
            return new CubeCursorImpl(cubeCursor, this.scope, this.preparedQuery.getCubeQueryDefinition());
        }
        catch (OLAPException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public String getID() {
        return this.queryResultsId;
    }

    public void close() throws BirtException {
    }
}

