/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;

class LayoutGroupBand {
    private List slots = new ArrayList();
    private LayoutTable tableContainer;

    LayoutGroupBand(LayoutTable table, int colCount) {
        this.tableContainer = table;
    }

    public LayoutSlot addSlot(int groupLevel, int expectedColCount) {
        LayoutSlot slot = new LayoutSlot(this.tableContainer, groupLevel, expectedColCount);
        this.slots.add(slot);
        return slot;
    }

    public int getGroupCount() {
        return this.slots.size();
    }

    public LayoutSlot getLayoutSlotWithGroupLevel(int groupLevel) {
        int i = 0;
        while (i < this.slots.size()) {
            LayoutSlot slot = (LayoutSlot)this.slots.get(i);
            if (groupLevel == slot.getGroupLevel()) {
                return slot;
            }
            ++i;
        }
        return null;
    }

    public LayoutSlot getLayoutSlot(int index) {
        if (index > this.slots.size() - 1) {
            return null;
        }
        return (LayoutSlot)this.slots.get(index);
    }

    public String getLayoutString() {
        if (this.slots.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.slots.size()) {
            LayoutSlot slot = (LayoutSlot)this.slots.get(i);
            sb.append(slot.getLayoutString());
            ++i;
        }
        return sb.toString();
    }

    protected int getColumnCount() {
        int colCount = 0;
        int i = 0;
        while (i < this.slots.size()) {
            LayoutSlot obj = (LayoutSlot)this.slots.get(i);
            int tmpCount = obj.getColumnCount();
            if (tmpCount > colCount) {
                colCount = tmpCount;
            }
            ++i;
        }
        return colCount;
    }
}

