/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabReportItemConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabReportItemTask;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class CrosstabReportItemHandle
extends AbstractCrosstabItemHandle
implements ICrosstabReportItemConstants,
ICrosstabConstants {
    CrosstabReportItemHandle(DesignElementHandle handle) {
        super(handle);
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getRowHeight(CrosstabCellHandle cell) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateRowHeightCell(this, cell)) != null) {
            return cell.getHeight();
        }
        throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.row.cell"));
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getColumnWidth(CrosstabCellHandle cell) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateColumnWidthCell(this, cell)) != null) {
            return cell.getWidth();
        }
        throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.column.cell"));
    }

    public void setRowHeight(CrosstabCellHandle cell, DimensionValue value) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateRowHeightCell(this, cell)) != null) {
            try {
                cell.getHeight().setValue((Object)value);
            }
            catch (SemanticException e) {
                throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.set.row.height"), e);
            }
        } else {
            throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.row.cell"));
        }
    }

    public void setColumnWidth(CrosstabCellHandle cell, DimensionValue value) throws CrosstabException {
        if ((cell = CrosstabModelUtil.locateColumnWidthCell(this, cell)) != null) {
            try {
                cell.getWidth().setValue((Object)value);
            }
            catch (SemanticException e) {
                throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.set.column.width"), e);
            }
        } else {
            throw new CrosstabException(this.getModelHandle().getElement(), Messages.getString("CrosstabReportItemHandle.error.locate.column.cell"));
        }
    }

    PropertyHandle getMeasuresProperty() {
        return this.handle.getPropertyHandle("measures");
    }

    PropertyHandle getRowsProperty() {
        return this.handle.getPropertyHandle("rows");
    }

    PropertyHandle getColumnsProperty() {
        return this.handle.getPropertyHandle("columns");
    }

    protected PropertyHandle getCrosstabViewProperty(int axisType) {
        switch (axisType) {
            case 0: {
                return this.getRowsProperty();
            }
            case 1: {
                return this.getColumnsProperty();
            }
        }
        return null;
    }

    public CrosstabViewHandle getCrosstabView(int axisType) {
        PropertyHandle propHandle = this.getCrosstabViewProperty(axisType);
        if (propHandle == null || propHandle.getContentCount() <= 0) {
            return null;
        }
        return (CrosstabViewHandle)CrosstabUtil.getReportItem(propHandle.getContent(0), "CrosstabView");
    }

    public CrosstabViewHandle addCrosstabView(int axisType) throws SemanticException {
        PropertyHandle propHandle = this.getCrosstabViewProperty(axisType);
        if (propHandle == null || propHandle.getContentCount() > 0) {
            return null;
        }
        ExtendedItemHandle extendedItem = CrosstabExtendedItemFactory.createCrosstabView(this.moduleHandle);
        propHandle.add((DesignElementHandle)extendedItem);
        return (CrosstabViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItem);
    }

    public String getCaption() {
        return this.handle.getStringProperty("caption");
    }

    public String getCaptionKey() {
        return this.handle.getStringProperty("captionID");
    }

    public String getMeasureDirection() {
        return this.handle.getStringProperty("measureDirection");
    }

    public void setMeasureDirection(String direction) throws SemanticException {
        CommandStack stack = this.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemHandle.msg.change.measure.direction"));
        try {
            this.handle.setStringProperty("measureDirection", direction);
            new CrosstabReportItemTask(this).validateCrosstab();
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void setPageLayout(String value) throws SemanticException {
        this.handle.setProperty("pageLayout", (Object)value);
    }

    public void setRepeatRowHeader(boolean value) throws SemanticException {
        this.handle.setProperty("repeatRowHeader", (Object)value);
    }

    public void setRepeatColumnHeader(boolean value) throws SemanticException {
        this.handle.setProperty("repeatColumnHeader", (Object)value);
    }

    public void setHideMeasureHeader(boolean value) throws SemanticException {
        this.handle.setProperty("hideMeasureHeader", (Object)value);
    }

    public String getPageLayout() {
        return this.handle.getStringProperty("pageLayout");
    }

    public boolean isRepeatRowHeader() {
        return this.handle.getBooleanProperty("repeatRowHeader");
    }

    public boolean isRepeatColumnHeader() {
        return this.handle.getBooleanProperty("repeatColumnHeader");
    }

    public boolean isHideMeasureHeader() {
        return this.handle.getBooleanProperty("hideMeasureHeader");
    }

    public String getEmptyCellValue() {
        return this.handle.getStringProperty("emptyCellValue");
    }

    public CubeHandle getCube() {
        return this.handle.getCube();
    }

    public void setCube(CubeHandle cube) throws SemanticException {
        this.handle.setProperty("cube", (Object)cube);
    }

    public String getCubeName() {
        return this.handle.getStringProperty("cube");
    }

    public DimensionViewHandle getDimension(String name) {
        DimensionViewHandle dimensionView = this.findDimension(0, name);
        if (dimensionView != null) {
            return dimensionView;
        }
        dimensionView = this.findDimension(1, name);
        if (dimensionView != null) {
            return dimensionView;
        }
        return null;
    }

    private DimensionViewHandle findDimension(int axisType, String name) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? null : crosstabView.getDimension(name);
    }

    public DimensionViewHandle getDimension(int axisType, int index) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? null : crosstabView.getDimension(index);
    }

    public int getDimensionCount(int axisType) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? 0 : crosstabView.getDimensionCount();
    }

    public MeasureViewHandle getMeasure(String name) {
        int i = 0;
        while (i < this.getMeasureCount()) {
            String cubeMeasureName;
            MeasureViewHandle measureView = this.getMeasure(i);
            if (measureView != null && ((cubeMeasureName = measureView.getCubeMeasureName()) != null && cubeMeasureName.equals(name) || cubeMeasureName == null && name == null)) {
                return measureView;
            }
            ++i;
        }
        return null;
    }

    public MeasureViewHandle getMeasure(int index) {
        DesignElementHandle element = this.getMeasuresProperty().getContent(index);
        return (MeasureViewHandle)CrosstabUtil.getReportItem(element, "MeasureView");
    }

    public int getMeasureCount() {
        return this.getMeasuresProperty().getContentCount();
    }

    public DimensionViewHandle insertDimension(DimensionHandle dimensionHandle, int axisType, int index) throws SemanticException {
        return new CrosstabReportItemTask(this).insertDimension(dimensionHandle, axisType, index);
    }

    public MeasureViewHandle insertMeasure(MeasureHandle measureHandle, int index) throws SemanticException {
        if (measureHandle != null && this.getMeasure(measureHandle.getQualifiedName()) != null) {
            logger.log(Level.SEVERE, "Error.CrosstabException.DUPLICATE_MEASURE", measureHandle.getQualifiedName());
            throw new CrosstabException(this.handle.getElement(), new String[]{measureHandle.getQualifiedName(), this.handle.getElement().getIdentifier()}, "Error.CrosstabException.DUPLICATE_MEASURE");
        }
        CommandStack stack = this.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemHandle.msg.insert.measure"));
        MeasureViewHandle mv = null;
        try {
            ExtendedItemHandle extendedItemHandle = CrosstabExtendedItemFactory.createMeasureView(this.moduleHandle, measureHandle);
            if (extendedItemHandle != null) {
                this.getMeasuresProperty().add((DesignElementHandle)extendedItemHandle, index);
                new CrosstabReportItemTask(this).validateCrosstab();
                mv = (MeasureViewHandle)CrosstabUtil.getReportItem((DesignElementHandle)extendedItemHandle);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return mv;
    }

    public void removeDimension(String name) throws SemanticException {
        new CrosstabReportItemTask(this).removeDimension(name);
    }

    public void removeDimension(int axisType, int index) throws SemanticException {
        new CrosstabReportItemTask(this).removeDimension(axisType, index);
    }

    public void removeMeasure(String name) throws SemanticException {
        MeasureViewHandle measureView = this.getMeasure(name);
        if (measureView == null) {
            logger.log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", name);
            throw new CrosstabException(this.handle.getElement(), new String[]{name, this.handle.getElement().getIdentifier()}, "Error.CrosstabException.DIMENSION_NOT_FOUND");
        }
        measureView.handle.drop();
    }

    public void removeMeasure(int index) throws SemanticException {
        this.getMeasuresProperty().drop(index);
    }

    public void pivotDimension(String name, int targetAxisType, int targetIndex) throws SemanticException {
        new CrosstabReportItemTask(this).pivotDimension(name, targetAxisType, targetIndex);
    }

    public void pivotDimension(int srcAxisType, int srcIndex, int targetAxisType, int targetIndex) throws SemanticException {
        new CrosstabReportItemTask(this).pivotDimension(srcAxisType, srcIndex, targetAxisType, targetIndex);
    }

    public CrosstabCellHandle getGrandTotal(int axisType) {
        CrosstabViewHandle crosstabView = this.getCrosstabView(axisType);
        return crosstabView == null ? null : crosstabView.getGrandTotal();
    }

    public CrosstabCellHandle addGrandTotal(int axisType) throws SemanticException {
        ArrayList<MeasureViewHandle> measures = new ArrayList<MeasureViewHandle>();
        ArrayList<String> functions = new ArrayList<String>();
        int i = 0;
        while (i < this.getMeasureCount()) {
            measures.add(this.getMeasure(i));
            functions.add("sum");
            ++i;
        }
        return this.addGrandTotal(axisType, measures, functions);
    }

    public void removeGrandTotal(int axisType) throws SemanticException {
        new CrosstabReportItemTask(this).removeGrandTotal(axisType);
    }

    public void removeGrandTotal(int axisType, int measureIndex) throws SemanticException {
        new CrosstabReportItemTask(this).removeGrandTotal(axisType, measureIndex);
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getWidth() {
        return this.handle.getDimensionProperty("width");
    }

    public org.eclipse.birt.report.model.api.DimensionHandle getHeight() {
        return this.handle.getDimensionProperty("height");
    }

    public void pivotMeasure(String name, int toIndex) throws SemanticException {
        MeasureViewHandle measureView = this.getMeasure(name);
        if (measureView == null) {
            logger.log(Level.SEVERE, "Error.CrosstabException.DIMENSION_NOT_FOUND", name);
            throw new CrosstabException(this.handle.getElement(), new String[]{name, this.handle.getElement().getIdentifier()}, "Error.CrosstabException.DIMENSION_NOT_FOUND");
        }
        measureView.handle.moveTo(toIndex);
    }

    public void pivotMeasure(int fromIndex, int toIndex) throws SemanticException {
        MeasureViewHandle measureView = this.getMeasure(fromIndex);
        if (measureView == null) {
            logger.log(Level.INFO, "Error.CrosstabException.MEASURE_NOT_FOUND", new Object[]{String.valueOf(fromIndex), this.handle.getElement().getIdentifier()});
            return;
        }
        measureView.handle.moveTo(toIndex);
    }

    public CrosstabCellHandle addGrandTotal(int axisType, List measureList, List functionList) throws SemanticException {
        return new CrosstabReportItemTask(this).addGrandTotal(axisType, measureList, functionList);
    }

    public List getAggregationMeasures(int axisType) {
        return new CrosstabReportItemTask(this).getAggregationMeasures(axisType);
    }

    public String getAggregationFunction(int axisType, MeasureViewHandle measureView) {
        return new CrosstabReportItemTask(this).getAggregationFunction(axisType, measureView);
    }

    public void setAggregationFunction(int axisType, MeasureViewHandle measureView, String function) throws SemanticException {
        new CrosstabReportItemTask(this).setAggregationFunction(axisType, measureView, function);
    }
}

