/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ContentUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.IColumnWalker;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public abstract class BaseCrosstabExecutor
implements ICrosstabConstants,
IReportItemExecutor {
    private static Logger logger;
    protected IExecutorContext context;
    protected CrosstabReportItemHandle crosstabItem;
    protected int[] rowCounter = new int[1];
    protected IColumnWalker walker;
    private IContent content;
    protected ICubeResultSet cubeRset;
    protected CubeCursor cubeCursor;
    protected Map styleCache;
    protected List rowGroups;
    protected List columnGroups;
    private Object modelHandle;
    private IReportItemExecutor parentExecutor;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    protected BaseCrosstabExecutor() {
    }

    protected BaseCrosstabExecutor(IExecutorContext context, CrosstabReportItemHandle item, IReportItemExecutor parentExecutor) {
        this();
        this.context = context;
        this.crosstabItem = item;
        this.parentExecutor = parentExecutor;
    }

    protected BaseCrosstabExecutor(BaseCrosstabExecutor parent) {
        this(parent.context, parent.crosstabItem, parent);
        this.rowCounter = parent.rowCounter;
        this.walker = parent.walker;
        this.columnGroups = parent.columnGroups;
        this.rowGroups = parent.rowGroups;
        this.styleCache = parent.styleCache;
    }

    protected void executeQuery(AbstractCrosstabItemHandle handle) {
        DesignElementHandle elementHandle = this.crosstabItem.getModelHandle();
        IDataQueryDefinition query = this.context.getQueries((Object)elementHandle)[0];
        IBaseResultSet rset = this.context.executeQuery(this.getParentResultSet(), query, (Object)elementHandle);
        if (rset instanceof ICubeResultSet) {
            this.cubeRset = (ICubeResultSet)rset;
            this.cubeCursor = this.cubeRset.getCubeCursor();
        }
    }

    protected void closeQuery() {
        if (this.cubeRset != null) {
            this.cubeRset.close();
            this.cubeRset = null;
            this.cubeCursor = null;
        }
    }

    protected CrosstabReportItemHandle getCrosstabItemHandle() {
        return this.crosstabItem;
    }

    protected void processStyle(AbstractCrosstabItemHandle handle) {
        try {
            ContentUtil.processStyle(this.context, this.content, handle, (IBaseResultSet)this.getCubeResultSet(), this.styleCache);
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, Messages.getString("BaseCrosstabExecutor.error.process.style"), e);
        }
    }

    protected void processVisibility(AbstractCrosstabItemHandle handle) {
        try {
            ContentUtil.processVisibility(this.context, this.content, handle, (IBaseResultSet)this.getCubeResultSet());
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, Messages.getString("BaseCrosstabExecutor.error.process.visibility"), e);
        }
    }

    protected void processBookmark(AbstractCrosstabItemHandle handle) {
        try {
            ContentUtil.processBookmark(this.context, this.content, handle, (IBaseResultSet)this.getCubeResultSet());
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, Messages.getString("BaseCrosstabExecutor.error.process.bookmark"), e);
        }
    }

    protected void processAction(AbstractCrosstabItemHandle handle) {
        ContentUtil.processAction(this.context, this.content, handle);
    }

    protected void processRowHeight(CrosstabCellHandle cell) {
        if (cell != null) {
            try {
                DimensionType height = ContentUtil.createDimension(this.crosstabItem.getRowHeight(cell));
                if (height != null) {
                    this.content.setHeight(height);
                }
            }
            catch (CrosstabException e) {
                logger.log(Level.SEVERE, Messages.getString("BaseCrosstabExecutor.error.process.row.height"), (Throwable)((Object)e));
            }
        }
    }

    protected CrosstabCellHandle findHeaderRowCell(int dimIndex, int levelIndex) {
        return this.crosstabItem.getDimension(1, dimIndex).getLevel(levelIndex).getCell();
    }

    protected CrosstabCellHandle findMeasureHeaderCell() {
        int i = 0;
        while (i < this.crosstabItem.getMeasureCount()) {
            CrosstabCellHandle headerCell = this.crosstabItem.getMeasure(i).getHeader();
            if (headerCell != null) {
                return headerCell;
            }
            ++i;
        }
        return null;
    }

    protected CrosstabCellHandle findMeasureRowCell(int rowIndex) {
        return this.crosstabItem.getMeasure(rowIndex).getCell();
    }

    protected CrosstabCellHandle findDetailRowCell(int rowIndex) {
        if (this.crosstabItem.getMeasureCount() > 0) {
            return this.crosstabItem.getMeasure(rowIndex).getCell();
        }
        int rdCount = this.crosstabItem.getDimensionCount(0);
        DimensionViewHandle dv = this.crosstabItem.getDimension(0, rdCount - 1);
        LevelViewHandle lv = dv.getLevel(dv.getLevelCount() - 1);
        return lv.getCell();
    }

    protected CrosstabCellHandle findSubTotalRowCell(int dimIndex, int levelIndex, int rowIndex) {
        MeasureViewHandle mv = this.crosstabItem.getMeasure(rowIndex);
        int count = mv.getAggregationCount();
        LevelHandle lh = this.crosstabItem.getDimension(0, dimIndex).getLevel(levelIndex).getCubeLevel();
        int i = 0;
        while (i < count) {
            AggregationCellHandle cell = mv.getAggregationCell(i);
            if (cell.getAggregationOnRow() == lh) {
                return cell;
            }
            ++i;
        }
        return null;
    }

    protected CrosstabCellHandle findGrandTotalRowCell(int rowIndex) {
        MeasureViewHandle mv = this.crosstabItem.getMeasure(rowIndex);
        int count = mv.getAggregationCount();
        int i = 0;
        while (i < count) {
            AggregationCellHandle cell = mv.getAggregationCell(i);
            if (cell.getAggregationOnRow() == null) {
                return cell;
            }
            ++i;
        }
        return null;
    }

    protected void initializeContent(IContent content, AbstractCrosstabItemHandle handle) {
        IContent parent;
        this.content = content;
        if (content instanceof IRowContent) {
            int n = this.rowCounter[0];
            this.rowCounter[0] = n + 1;
            ((IRowContent)content).setRowID(n);
        }
        if ((parent = this.getParentContent()) != null) {
            content.setParent((IElement)parent);
        }
    }

    private IContent getParentContent() {
        IReportItemExecutor re = this.parentExecutor;
        while (re != null) {
            IContent cont = re.getContent();
            if (cont != null) {
                return cont;
            }
            re = re.getParent();
        }
        return null;
    }

    private IBaseResultSet getParentResultSet() {
        IReportItemExecutor re = this.parentExecutor;
        while (re != null) {
            IBaseResultSet[] rsa = re.getQueryResults();
            if (rsa != null && rsa.length > 0) {
                return rsa[0];
            }
            re = re.getParent();
        }
        return null;
    }

    public IContent getContent() {
        return this.content;
    }

    protected ICubeResultSet getCubeResultSet() {
        if (this.cubeRset != null) {
            return this.cubeRset;
        }
        if (this.parentExecutor instanceof BaseCrosstabExecutor) {
            return ((BaseCrosstabExecutor)this.parentExecutor).getCubeResultSet();
        }
        return null;
    }

    protected CubeCursor getCubeCursor() {
        if (this.cubeCursor != null) {
            return this.cubeCursor;
        }
        if (this.parentExecutor instanceof BaseCrosstabExecutor) {
            return ((BaseCrosstabExecutor)this.parentExecutor).getCubeCursor();
        }
        return null;
    }

    protected EdgeCursor getColumnEdgeCursor() throws OLAPException {
        CubeCursor cs = this.getCubeCursor();
        if (cs != null) {
            List ordinates = cs.getOrdinateEdge();
            if (this.columnGroups != null && this.columnGroups.size() > 0 && ordinates.size() > 0) {
                return (EdgeCursor)ordinates.get(0);
            }
        }
        return null;
    }

    protected EdgeCursor getRowEdgeCursor() throws OLAPException {
        CubeCursor cs = this.getCubeCursor();
        if (cs != null) {
            List ordinates = cs.getOrdinateEdge();
            if (this.rowGroups != null && this.rowGroups.size() > 0 && ordinates.size() > 0) {
                return (EdgeCursor)ordinates.get(ordinates.size() - 1);
            }
        }
        return null;
    }

    protected int getStartingGroupLevel(EdgeCursor rowCursor, List groupCursors) throws OLAPException {
        if (rowCursor.isFirst()) {
            return 0;
        }
        int i = 0;
        while (i < groupCursors.size() - 1) {
            DimensionCursor dc = (DimensionCursor)groupCursors.get(i);
            if (GroupUtil.isDummyGroup(dc)) {
                return i == 0 ? 1 : i;
            }
            if (dc.getEdgeStart() == rowCursor.getPosition()) {
                return i + 1;
            }
            ++i;
        }
        return groupCursors.size();
    }

    protected int getEndingGroupLevel(EdgeCursor rowCursor, List groupCursors) throws OLAPException {
        if (rowCursor.isLast()) {
            return 0;
        }
        int i = 0;
        while (i < groupCursors.size() - 1) {
            DimensionCursor dc = (DimensionCursor)groupCursors.get(i);
            if (GroupUtil.isDummyGroup(dc)) {
                return i == 0 ? 1 : i;
            }
            if (dc.getEdgeEnd() == rowCursor.getPosition()) {
                return i + 1;
            }
            ++i;
        }
        return groupCursors.size();
    }

    public void close() {
    }

    public Object getModelObject() {
        return this.modelHandle;
    }

    public void setModelObject(Object handle) {
        this.modelHandle = handle;
    }

    public IReportItemExecutor getParent() {
        return this.parentExecutor;
    }

    public void setParent(IReportItemExecutor parent) {
        this.parentExecutor = parent;
    }

    public IBaseResultSet[] getQueryResults() {
        if (this.cubeRset == null) {
            return null;
        }
        return new IBaseResultSet[]{this.cubeRset};
    }

    public IExecutorContext getContext() {
        return this.context;
    }

    public void setContext(IExecutorContext context) {
        this.context = context;
    }
}

