/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.util.IInputXMLDataSource;

class MemoryCacheDataSource
implements IInputXMLDataSource {
    private static final int UNIT_SIZE = 100000;
    private byte[] byteArray;
    private boolean overReadLimit = false;
    private int currentPosition = -1;
    private int totalSize = 0;
    private int currentListIndex = -1;
    private int currentArrayPosition = -1;
    private List byteList = new ArrayList();

    MemoryCacheDataSource(InputStream stream, long size) {
        this.byteArray = new byte[100000];
        this.byteList.add(this.byteArray);
        int ch = -1;
        try {
            int i = 0;
            while ((long)this.totalSize < size && (ch = stream.read()) != -1) {
                if (i >= 100000) {
                    this.byteArray = new byte[100000];
                    this.byteList.add(this.byteArray);
                    i = 0;
                }
                ++this.totalSize;
                this.byteArray[i] = (byte)ch;
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ch != -1) {
            this.overReadLimit = true;
        }
    }

    boolean canUseMemoryCache() {
        return !this.overReadLimit;
    }

    public int read() {
        ++this.currentPosition;
        ++this.currentArrayPosition;
        if (this.currentPosition < this.totalSize) {
            if (this.currentArrayPosition >= 100000 || this.currentArrayPosition == 0) {
                this.currentArrayPosition = 0;
                ++this.currentListIndex;
                if (this.currentListIndex < this.byteList.size()) {
                    this.byteArray = (byte[])this.byteList.get(this.currentListIndex);
                } else {
                    return -1;
                }
            }
            return this.byteArray[this.currentArrayPosition];
        }
        return -1;
    }

    public void init() {
        this.currentPosition = -1;
        this.currentArrayPosition = -1;
        this.currentListIndex = -1;
    }

    public void close() throws IOException {
    }
}

