/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class ECrossReferenceEList
extends EContentsEList {
    public static final ECrossReferenceEList EMPTY_CROSS_REFERENCE_ELIST = new ECrossReferenceEList(null, null){

        public List basicList() {
            return this;
        }
    };

    public static ECrossReferenceEList createECrossReferenceEList(EObject eObject) {
        EStructuralFeature[] eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)eObject.eClass().getEAllStructuralFeatures()).crossReferences();
        return eStructuralFeatures == null ? EMPTY_CROSS_REFERENCE_ELIST : new ECrossReferenceEList(eObject, eStructuralFeatures);
    }

    public ECrossReferenceEList(EObject eObject) {
        super(eObject, ((EClassImpl.FeatureSubsetSupplier)eObject.eClass().getEAllStructuralFeatures()).crossReferences());
    }

    protected ECrossReferenceEList(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
        super(eObject, eStructuralFeatures);
    }

    protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
        if (FeatureMapUtil.isFeatureMap(eStructuralFeature)) {
            return true;
        }
        EReference eReference = (EReference)eStructuralFeature;
        return !eReference.isContainment() && !eReference.isContainer();
    }

    protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            return !eReference.isContainment() && !eReference.isContainer();
        }
        return false;
    }

    protected ListIterator newResolvingListIterator() {
        return new ResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    protected ListIterator newNonResolvingListIterator() {
        return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    public List basicList() {
        return new ECrossReferenceEList(this.eObject, this.eStructuralFeatures){

            protected boolean resolve() {
                return false;
            }
        };
    }

    public static class FeatureIteratorImpl
    extends EContentsEList.FeatureIteratorImpl {
        protected static final EStructuralFeature[] NO_FEATURES = new EStructuralFeature[0];

        public FeatureIteratorImpl(EObject eObject) {
            this(eObject, ((EClassImpl.FeatureSubsetSupplier)eObject.eClass().getEAllStructuralFeatures()).crossReferences());
        }

        public FeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures == null ? NO_FEATURES : eStructuralFeatures);
        }

        protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                return !eReference.isContainment() && !eReference.isContainer();
            }
            return false;
        }
    }

    public static class ResolvingFeatureIteratorImpl
    extends FeatureIteratorImpl {
        public ResolvingFeatureIteratorImpl(EObject eObject) {
            super(eObject);
        }

        public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        protected boolean resolve() {
            return true;
        }
    }
}

