/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAOutputStream;

public class RAFileOutputStream
extends RAOutputStream {
    protected static Logger logger;
    private RandomAccessFile parent;
    private long startPos;
    private long endPos;
    private long cur;
    private byte[] writeBuffer = new byte[8];
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.archive.RAFileOutputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public RAFileOutputStream(RandomAccessFile parentFile, long startPos) {
        this.parent = parentFile;
        this.startPos = startPos;
        this.endPos = startPos;
        try {
            this.seekParent(0L);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public void write(int b) throws IOException {
        this.seekParent(this.cur);
        this.parent.write(b);
        long tmp = this.parent.getFilePointer();
        if (tmp > this.endPos) {
            this.endPos = tmp;
        }
        ++this.cur;
    }

    public void write(byte[] b) throws IOException {
        this.seekParent(this.cur);
        this.parent.write(b);
        long tmp = this.parent.getFilePointer();
        if (tmp > this.endPos) {
            this.endPos = tmp;
        }
        this.cur += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.seekParent(this.cur);
        this.parent.write(b, off, len);
        long tmp = this.parent.getFilePointer();
        if (tmp > this.endPos) {
            this.endPos = tmp;
        }
        this.cur += (long)len;
    }

    public void writeInt(int v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 24);
        this.writeBuffer[1] = (byte)(v >>> 16);
        this.writeBuffer[2] = (byte)(v >>> 8);
        this.writeBuffer[3] = (byte)(v >>> 0);
        this.write(this.writeBuffer, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)(v >>> 0);
        this.write(this.writeBuffer, 0, 8);
    }

    public void seek(long localPos) throws IOException {
        this.seekParent(localPos);
        this.cur = localPos;
    }

    public long getOffset() throws IOException {
        return this.cur;
    }

    public long getStreamLength() {
        return this.endPos - this.startPos;
    }

    private long localPosToGlobalPos(long localPos) {
        return localPos + this.startPos;
    }

    private void seekParent(long localPos) throws IOException {
        this.parent.seek(this.localPosToGlobalPos(localPos));
    }

    public long length() throws IOException {
        return this.getStreamLength();
    }
}

