/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class ArchiveWriter
implements IDocArchiveWriter {
    boolean shareArchive;
    ArchiveFile archive;
    HashSet streams;

    public ArchiveWriter(String archiveName) throws IOException {
        this.archive = new ArchiveFile(archiveName, "rw");
        this.shareArchive = false;
        this.streams = new HashSet();
    }

    public ArchiveWriter(ArchiveFile archive) throws IOException {
        this.archive = archive;
        this.shareArchive = true;
        this.streams = new HashSet();
    }

    public ArchiveFile getArchive() {
        return this.archive;
    }

    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        ArchiveEntry entry = this.archive.createEntry(relativePath);
        ArchiveEntryOutputStream stream = new ArchiveEntryOutputStream(this, entry);
        this.streams.add(stream);
        return stream;
    }

    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(relativePath);
        if (entry == null) {
            entry = this.archive.createEntry(relativePath);
        }
        ArchiveEntryOutputStream stream = new ArchiveEntryOutputStream(this, entry);
        this.streams.add(stream);
        return stream;
    }

    public boolean dropStream(String relativePath) {
        try {
            return this.archive.removeEntry(relativePath);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean exists(String relativePath) {
        return this.archive.exists(relativePath);
    }

    /*
     * Exception decompiling
     */
    public void finish() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 84->88)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void flush() throws IOException {
        ArrayList unclosedStreams = new ArrayList();
        unclosedStreams.addAll(this.streams);
        Iterator iter = unclosedStreams.iterator();
        while (iter.hasNext()) {
            RAOutputStream stream = (RAOutputStream)iter.next();
            stream.flush();
        }
        this.archive.flush();
    }

    public String getName() {
        return this.archive.getName();
    }

    public void initialize() throws IOException {
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
    }

    public Object lock(String stream) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(stream);
        if (entry == null) {
            entry = this.archive.createEntry(stream);
        }
        if (entry != null) {
            return this.archive.lockEntry(entry);
        }
        throw new IOException("can't find the entry " + stream);
    }

    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {}
    }

    void registerStream(ArchiveEntryOutputStream stream) {
        this.streams.add(stream);
    }

    void unregisterStream(ArchiveEntryOutputStream stream) {
        this.streams.remove(stream);
    }
}

