/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.markup.MarkupParser;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class FactoryProperties {
    private FontFactoryImp fontImp = FontFactory.getFontImp();
    public static HashMap followTags = new HashMap();

    public Chunk createChunk(String string, ChainedProperties chainedProperties) {
        Chunk chunk = new Chunk(string, this.getFont(chainedProperties));
        if (chainedProperties.hasProperty("sub")) {
            chunk.setTextRise(-6.0f);
        } else if (chainedProperties.hasProperty("sup")) {
            chunk.setTextRise(6.0f);
        }
        return chunk;
    }

    private static void setParagraphLeading(Paragraph paragraph, String string) {
        if (string == null) {
            paragraph.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            String string2 = stringTokenizer.nextToken();
            float f = Float.parseFloat(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                paragraph.setLeading(f, 0.0f);
                return;
            }
            string2 = stringTokenizer.nextToken();
            float f2 = Float.parseFloat(string2);
            paragraph.setLeading(f, f2);
        }
        catch (Exception exception) {
            paragraph.setLeading(0.0f, 1.5f);
        }
    }

    public static Paragraph createParagraph(HashMap hashMap) {
        Paragraph paragraph = new Paragraph();
        String string = (String)hashMap.get("align");
        if (string != null) {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
            } else if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
            } else if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(paragraph, (String)hashMap.get("leading"));
        return paragraph;
    }

    public static void createParagraph(Paragraph paragraph, ChainedProperties chainedProperties) {
        String string = chainedProperties.getProperty("align");
        if (string != null) {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
            } else if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
            } else if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(paragraph, chainedProperties.getProperty("leading"));
        string = chainedProperties.getProperty("before");
        if (string != null) {
            try {
                paragraph.setSpacingBefore(Float.parseFloat(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = chainedProperties.getProperty("after")) != null) {
            try {
                paragraph.setSpacingAfter(Float.parseFloat(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = chainedProperties.getProperty("extraparaspace")) != null) {
            try {
                paragraph.setExtraParagraphSpace(Float.parseFloat(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Paragraph createParagraph(ChainedProperties chainedProperties) {
        Paragraph paragraph = new Paragraph();
        FactoryProperties.createParagraph(paragraph, chainedProperties);
        return paragraph;
    }

    public static ListItem createListItem(ChainedProperties chainedProperties) {
        ListItem listItem = new ListItem();
        FactoryProperties.createParagraph(listItem, chainedProperties);
        return listItem;
    }

    public Font getFont(ChainedProperties chainedProperties) {
        String string = chainedProperties.getProperty("face");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (string.startsWith("\"")) {
                    string = string.substring(1);
                }
                if (string.endsWith("\"")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (!this.fontImp.isRegistered(string)) continue;
            }
        }
        int n = 0;
        if (chainedProperties.hasProperty("i")) {
            n |= 2;
        }
        if (chainedProperties.hasProperty("b")) {
            n |= 1;
        }
        if (chainedProperties.hasProperty("u")) {
            n |= 4;
        }
        String string2 = chainedProperties.getProperty("size");
        float f = 12.0f;
        if (string2 != null) {
            f = Float.parseFloat(string2);
        }
        Color color = MarkupParser.decodeColor(chainedProperties.getProperty("color"));
        String string3 = chainedProperties.getProperty("encoding");
        if (string3 == null) {
            string3 = "Cp1252";
        }
        return this.fontImp.getFont(string, string3, true, f, n, color);
    }

    public static void insertStyle(HashMap hashMap) {
        String string = (String)hashMap.get("style");
        if (string == null) {
            return;
        }
        Properties properties = MarkupParser.parseAttributes(string);
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            if (string2.equals("font-family")) {
                hashMap.put("face", properties.getProperty(string2));
                continue;
            }
            if (string2.equals("font-size")) {
                hashMap.put("size", Float.toString(MarkupParser.parseLength(properties.getProperty(string2))) + "px");
                continue;
            }
            if (string2.equals("font-style")) {
                object = properties.getProperty(string2).trim().toLowerCase();
                if (!((String)object).equals("italic") && !((String)object).equals("oblique")) continue;
                hashMap.put("i", null);
                continue;
            }
            if (string2.equals("font-weight")) {
                object = properties.getProperty(string2).trim().toLowerCase();
                if (!((String)object).equals("bold") && !((String)object).equals("700") && !((String)object).equals("800") && !((String)object).equals("900")) continue;
                hashMap.put("b", null);
                continue;
            }
            if (string2.equals("font-weight")) {
                object = properties.getProperty(string2).trim().toLowerCase();
                if (!((String)object).equals("underline")) continue;
                hashMap.put("u", null);
                continue;
            }
            if (string2.equals("color")) {
                object = MarkupParser.decodeColor(properties.getProperty(string2));
                if (object == null) continue;
                int n = ((Color)object).getRGB();
                String string3 = Integer.toHexString(n);
                string3 = "000000" + string3;
                string3 = "#" + string3.substring(string3.length() - 6);
                hashMap.put("color", string3);
                continue;
            }
            if (string2.equals("line-height")) {
                object = properties.getProperty(string2).trim();
                float f = MarkupParser.parseLength(properties.getProperty(string2));
                if (((String)object).endsWith("%")) {
                    hashMap.put("leading", "0," + f / 100.0f);
                    continue;
                }
                hashMap.put("leading", f + ",0");
                continue;
            }
            if (!string2.equals("text-align")) continue;
            object = properties.getProperty(string2).trim().toLowerCase();
            hashMap.put("align", object);
        }
    }

    public FontFactoryImp getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontFactoryImp fontFactoryImp) {
        this.fontImp = fontFactoryImp;
    }

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
    }
}

