/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.util.CDateTime;

public class SeriesNameFormat {
    public static SeriesNameFormat DEFAULT_FORMAT = new SeriesNameFormat();

    private SeriesNameFormat() {
    }

    public static SeriesNameFormat getSeriesNameFormat(SeriesDefinition sd, ULocale loc) {
        SeriesGrouping sg;
        if (sd != null && sd.getQuery() != null && sd.getQuery().getGrouping() != null && (sg = sd.getQuery().getGrouping()).getGroupType() == DataType.DATE_TIME_LITERAL) {
            return new SeriesNameDateFormat(sg.getGroupingUnit(), loc);
        }
        return DEFAULT_FORMAT;
    }

    public String format(Object obj) {
        String str = "";
        if (obj != null) {
            if (obj instanceof Number) {
                double d = ((Number)obj).doubleValue();
                String sPattern = ValueFormatter.getNumericPattern(d);
                DecimalFormat df = new DecimalFormat(sPattern);
                str = df.format(d);
            } else {
                str = obj.toString();
            }
        }
        return str;
    }

    /* synthetic */ SeriesNameFormat(SeriesNameFormat seriesNameFormat) {
        this();
    }

    private static class SeriesNameDateFormat
    extends SeriesNameFormat {
        private static final String[] DEFAULT_PATTERN_PAGE = new String[]{"HH:mm:ss", "HH:mm", "HH:mm", "yyyy-MM-dd", "yyyy-MM-dd", "yyyy-MM", "yyyy QQQ", "yyyy"};
        private DateFormat fm = null;
        private DateFormat fmTimeOnly = null;
        private GroupingUnitType unitType;

        public SeriesNameDateFormat(GroupingUnitType unitType, ULocale loc) {
            super(null);
            this.unitType = unitType;
            this.fm = new SimpleDateFormat(SeriesNameDateFormat.createPattern(unitType, loc, false), loc);
            this.fmTimeOnly = new SimpleDateFormat(SeriesNameDateFormat.createPattern(unitType, loc, true), loc);
        }

        private static int groupingUnit2CDateUnit(GroupingUnitType groupingUnitType) {
            if (groupingUnitType != null) {
                switch (groupingUnitType.getValue()) {
                    case 0: {
                        return 13;
                    }
                    case 1: {
                        return 12;
                    }
                    case 2: {
                        return 11;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 7: {
                        return 1;
                    }
                    case 6: {
                        return 6;
                    }
                }
            }
            return 14;
        }

        private static String createPattern(GroupingUnitType unitType, ULocale loc, boolean isTime) {
            String[] patternPage = DEFAULT_PATTERN_PAGE;
            if (unitType.getValue() < 3) {
                String sPrefix = isTime ? "" : String.valueOf(patternPage[3]) + " ";
                return String.valueOf(sPrefix) + patternPage[unitType.getValue()];
            }
            return patternPage[unitType.getValue()];
        }

        public String format(Object obj) {
            if (obj instanceof Calendar) {
                CDateTime cd = new CDateTime((Calendar)obj);
                return this.formatCDateTime(cd);
            }
            if (obj instanceof Date) {
                CDateTime cd = new CDateTime((Date)obj);
                return this.formatCDateTime(cd);
            }
            return super.format(obj);
        }

        private String formatCDateTime(CDateTime cd) {
            cd.clearBelow(SeriesNameDateFormat.groupingUnit2CDateUnit(this.unitType));
            if (cd.isTimeOnly()) {
                return this.fmTimeOnly.format((Object)cd);
            }
            return this.fm.format((Object)cd);
        }
    }
}

