/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class AxisType
extends AbstractEnumerator {
    public static final int LINEAR = 0;
    public static final int LOGARITHMIC = 1;
    public static final int TEXT = 2;
    public static final int DATE_TIME = 3;
    public static final AxisType LINEAR_LITERAL = new AxisType(0, "Linear", "Linear");
    public static final AxisType LOGARITHMIC_LITERAL = new AxisType(1, "Logarithmic", "Logarithmic");
    public static final AxisType TEXT_LITERAL = new AxisType(2, "Text", "Text");
    public static final AxisType DATE_TIME_LITERAL = new AxisType(3, "DateTime", "DateTime");
    private static final AxisType[] VALUES_ARRAY = new AxisType[]{LINEAR_LITERAL, LOGARITHMIC_LITERAL, TEXT_LITERAL, DATE_TIME_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static AxisType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType get(int value) {
        switch (value) {
            case 0: {
                return LINEAR_LITERAL;
            }
            case 1: {
                return LOGARITHMIC_LITERAL;
            }
            case 2: {
                return TEXT_LITERAL;
            }
            case 3: {
                return DATE_TIME_LITERAL;
            }
        }
        return null;
    }

    private AxisType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

