/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;

public class ArchiveEntryInputStream
extends RAInputStream {
    private ArchiveEntry entry;
    private byte[] buffer;
    private int buffer_size;
    private int buffer_offset;
    private long offset;

    ArchiveEntryInputStream(ArchiveEntry entry) {
        this.entry = entry;
        this.offset = 0L;
        this.buffer = new byte[4096];
        this.buffer_size = 0;
        this.buffer_offset = 0;
    }

    public int read() throws IOException {
        if (this.buffer_offset >= this.buffer_size) {
            this.refreshBuffer();
        }
        if (this.buffer_offset >= this.buffer_size) {
            return -1;
        }
        return this.buffer[this.buffer_offset++] & 0xFF;
    }

    public int available() throws IOException {
        long av = this.entry.getLength() - this.getOffset();
        if (av > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)av;
    }

    public long getOffset() throws IOException {
        return this.offset + (long)this.buffer_offset;
    }

    public long length() throws IOException {
        return this.entry.getLength();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer_offset < this.buffer_size) {
            int size = this.buffer_size - this.buffer_offset;
            if (size > len) {
                size = len;
            }
            System.arraycopy(this.buffer, this.buffer_offset, b, off, size);
            this.buffer_offset += size;
            return size;
        }
        this.offset += (long)this.buffer_offset;
        this.buffer_offset = 0;
        this.buffer_size = 0;
        int size = this.entry.read(this.offset, b, off, len);
        if (size != -1) {
            this.offset += (long)size;
        }
        return size;
    }

    public int readInt() throws IOException {
        if (this.buffer_offset + 4 > this.buffer_size) {
            this.refreshBuffer();
            if (this.buffer_offset + 4 > this.buffer_size) {
                throw new EOFException();
            }
        }
        int v = ArchiveUtil.bytesToInteger(this.buffer, this.buffer_offset);
        this.buffer_offset += 4;
        return v;
    }

    public long readLong() throws IOException {
        if (this.buffer_offset + 8 > this.buffer_size) {
            this.refreshBuffer();
            if (this.buffer_offset + 8 > this.buffer_size) {
                throw new EOFException();
            }
        }
        long v = ArchiveUtil.bytesToLong(this.buffer, this.buffer_offset);
        this.buffer_offset += 8;
        return v;
    }

    private void refreshBuffer() throws IOException {
        if (this.buffer_offset < this.buffer_size) {
            System.arraycopy(this.buffer, this.buffer_offset, this.buffer, 0, this.buffer_size - this.buffer_offset);
            this.offset += (long)this.buffer_offset;
            this.buffer_size -= this.buffer_offset;
            this.buffer_offset = 0;
        } else {
            this.offset += (long)this.buffer_size;
            this.buffer_size = 0;
            this.buffer_offset = 0;
        }
        int readSize = this.entry.read(this.offset + (long)this.buffer_size, this.buffer, this.buffer_size, this.buffer.length - this.buffer_size);
        if (readSize != -1) {
            this.buffer_size += readSize;
        }
    }

    public void refresh() throws IOException {
        this.offset += (long)this.buffer_offset;
        this.buffer_offset = 0;
        this.buffer_size = 0;
        this.entry.refresh();
    }

    public void seek(long localPos) throws IOException {
        if (localPos < 0L) {
            throw new IOException("Invalid seek offset " + localPos);
        }
        if (localPos >= this.entry.getLength()) {
            throw new EOFException("exceed the file length");
        }
        if (localPos < this.offset || localPos > this.offset + (long)this.buffer_size) {
            this.offset = localPos;
            this.buffer_size = 0;
            this.buffer_offset = 0;
            return;
        }
        this.buffer_offset = (int)(localPos - this.offset);
    }
}

